/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.builtin;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import jsynoptic.base.ContextualActionProvider;
import jsynoptic.builtin.Abstract1DShape;
import simtools.data.DataSource;
import simtools.data.DataSourceListener;
import simtools.data.DataSourcePool;
import simtools.data.UnsupportedOperation;
import simtools.diagram.DiagramParameters;
import simtools.diagram.Resizable;
import simtools.ui.ColorMapper;
import simtools.ui.DynamicColorChooser;
import simtools.ui.ResourceFinder;

public abstract class Abstract2DShape
extends Abstract1DShape
implements Resizable,
DataSourceListener,
ContextualActionProvider {
    static final long serialVersionUID = -251037943033567016L;
    public static ResourceBundle resources = ResourceFinder.get(class$jsynoptic$builtin$Abstract2DShape == null ? (class$jsynoptic$builtin$Abstract2DShape = Abstract2DShape.class$("jsynoptic.builtin.Abstract2DShape")) : class$jsynoptic$builtin$Abstract2DShape);
    protected Color fillColor = null;
    protected transient Color fillDynamicColor = null;
    protected ColorMapper fillMapper;
    protected transient DataSource fillMapperSource;
    protected transient long fillMapperIndex;
    protected transient boolean dirtyFillColor = false;
    static /* synthetic */ Class class$jsynoptic$builtin$Abstract2DShape;

    public Abstract2DShape(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    public void draw(Graphics2D graphics2D) {
        Color color = graphics2D.getColor();
        Color color2 = graphics2D.getBackground();
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.drawHook(graphics2D, false);
        Color color3 = this.fillDynamicColor != null ? this.fillDynamicColor : this.fillColor;
        Shape shape = null;
        if (color3 != null) {
            graphics2D.setColor(color3);
            shape = this.getDelegateShape();
            graphics2D.fill(shape);
        }
        Color color4 = color3 = this.drawDynamicColor != null ? this.drawDynamicColor : this.drawColor;
        if (color3 != null) {
            graphics2D.setColor(color3);
            if (shape == null) {
                shape = this.getDelegateShape();
            }
            graphics2D.draw(shape);
        }
        this.drawHook(graphics2D, true);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        graphics2D.setBackground(color2);
        graphics2D.setColor(color);
    }

    public Abstract1DShape.PropertiesPanel createPanel() {
        return new PropertiesPanel2D();
    }

    public void notificationEnd(Object object) {
        if (this.dirtyFillColor) {
            this.dirtyFillColor = false;
            Color color = null;
            if (this.fillMapper != null) {
                color = (Color)this.fillMapper.getPaint(this.fillMapperSource, this.fillMapperIndex);
            }
            this.dirtyFillColor = color == null ? this.fillDynamicColor != null : !color.equals(this.fillDynamicColor);
            this.fillDynamicColor = color;
            this.dirty |= this.dirtyFillColor;
            this.dirtyFillColor = false;
        }
        super.notificationEnd(object);
    }

    public void DataSourceIndexRangeChanged(DataSource dataSource, long l, long l2) {
        if (dataSource.equals(this.fillMapperSource)) {
            this.fillMapperIndex = l2;
            this.dirtyFillColor = true;
        }
        super.DataSourceIndexRangeChanged(dataSource, l, l2);
    }

    public void DataSourceValueChanged(DataSource dataSource, long l, long l2) {
        if (dataSource.equals(this.fillMapperSource) && this.fillMapperIndex >= l && this.fillMapperIndex <= l2) {
            this.dirtyFillColor = true;
        }
        super.DataSourceValueChanged(dataSource, l, l2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        DataSourcePool.global.writeDataSource(objectOutputStream, this.fillMapperSource);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.fillMapperSource = DataSourcePool.global.readDataSource(objectInputStream);
        if (this.fillMapperSource != null) {
            try {
                this.fillMapperSource.addListener(this);
                this.fillMapperSource.addEndNotificationListener(this);
                this.fillMapperIndex = this.fillMapperSource.getLastIndex();
            }
            catch (UnsupportedOperation unsupportedOperation) {
                this.fillMapperIndex = 0L;
            }
        }
        this.fillDynamicColor = this.fillMapper != null ? (Color)this.fillMapper.getPaint(this.fillMapperSource, this.fillMapperIndex) : null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class PropertiesPanel2D
    extends Abstract1DShape.PropertiesPanel {
        protected JButton bfillcolor;
        protected JCheckBox cbfill;
        protected Color fillColor;
        protected ColorMapper fillMapper;
        protected transient DataSource fillMapperSource;

        public JComponent createContent(boolean bl, boolean bl2) {
            Box box = (Box)super.createContent(bl, bl2);
            this.fillColor = Abstract2DShape.this.fillColor;
            this.fillMapper = Abstract2DShape.this.fillMapper;
            this.fillMapperSource = Abstract2DShape.this.fillMapperSource;
            Box box2 = Box.createHorizontalBox();
            this.cbfill = new JCheckBox(this.fillColorLabel(), this.fillColor != null || this.fillMapper != null && this.fillMapperSource != null);
            box2.add(this.cbfill);
            box2.add(Box.createHorizontalGlue());
            this.bfillcolor = new JButton("    ");
            box2.add(this.bfillcolor);
            this.bfillcolor.setFocusPainted(false);
            if (this.fillColor == null) {
                this.fillColor = DiagramParameters.DEFAULT_COLOR;
            }
            this.bfillcolor.setBackground(this.fillColor);
            box.add((Component)box2, 1);
            this.bfillcolor.addActionListener(new ActionListener(this){
                private final /* synthetic */ PropertiesPanel2D this$1;
                {
                    this.this$1 = propertiesPanel2D;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Color color = DynamicColorChooser.showDialog(null, this.this$1.fillColorChooserTitle(), null, this.this$1.fillColor, this.this$1.fillMapperSource, this.this$1.fillMapper);
                    if (color == null) {
                        return;
                    }
                    this.this$1.fillColor = color;
                    this.this$1.fillMapperSource = DynamicColorChooser.getSource();
                    this.this$1.fillMapper = DynamicColorChooser.getMapper();
                    this.this$1.bfillcolor.setBackground(this.this$1.fillColor);
                    this.this$1.cbfill.setSelected(true);
                }
            });
            return box;
        }

        public void updateProperties() {
            super.updateProperties();
            if (!this.cbfill.isSelected()) {
                this.fillColor = null;
                this.fillMapper = null;
                this.fillMapperSource = null;
            }
            Abstract2DShape.this.fillColor = this.fillColor;
            Abstract2DShape.this.fillMapper = this.fillMapper;
            if (Abstract2DShape.this.fillMapperSource != null) {
                Abstract2DShape.this.fillMapperSource.removeListener(Abstract2DShape.this);
                Abstract2DShape.this.fillMapperSource.removeEndNotificationListener(Abstract2DShape.this);
            }
            Abstract2DShape.this.fillMapperSource = this.fillMapperSource;
            if (Abstract2DShape.this.fillMapperSource != null) {
                try {
                    Abstract2DShape.this.fillMapperIndex = Abstract2DShape.this.fillMapperSource.getLastIndex();
                }
                catch (UnsupportedOperation unsupportedOperation) {
                    Abstract2DShape.this.fillMapperIndex = 0L;
                }
                Abstract2DShape.this.fillMapperSource.addListener(Abstract2DShape.this);
                Abstract2DShape.this.fillMapperSource.addEndNotificationListener(Abstract2DShape.this);
            }
        }

        protected String fillColorLabel() {
            return resources.getString("FillShapeColor");
        }

        protected String fillColorChooserTitle() {
            return resources.getString("FillShapeColorTitle");
        }
    }
}

