/*
 * Decompiled with CFR 0.152.
 */
package simtools.data.buffer;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import simtools.data.DataException;
import simtools.data.ValueProvider;
import simtools.data.buffer.Buffer;

public class SimpleBuffer
extends Buffer {
    static final long serialVersionUID = -6461227937739750821L;
    static int DEFAULT_BUFFER_SIZE = 200;
    protected transient boolean[] valid;

    protected void initialize(int n) {
        this.valid = new boolean[n];
        this.startIndex = -1L;
        this.endIndex = -2L;
    }

    public SimpleBuffer() {
        this(null);
    }

    public SimpleBuffer(ValueProvider valueProvider) {
        this(valueProvider, DEFAULT_BUFFER_SIZE);
    }

    public SimpleBuffer(int n) {
        this(n, null);
    }

    public SimpleBuffer(int n, ValueProvider valueProvider) {
        this(n, valueProvider, DEFAULT_BUFFER_SIZE);
    }

    public SimpleBuffer(ValueProvider valueProvider, int n) {
        this(7, valueProvider, n);
    }

    public SimpleBuffer(int n, ValueProvider valueProvider, int n2) {
        super(n, valueProvider);
        this.initialize(n2);
    }

    public Object clone() {
        SimpleBuffer simpleBuffer = (SimpleBuffer)super.clone();
        simpleBuffer.valid = (boolean[])this.valid.clone();
        return simpleBuffer;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.valid.length);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initialize(objectInputStream.readInt());
    }

    protected Buffer.Manipulator createManipulator(int n) {
        switch (n) {
            case 1: {
                return new SimpleByteManipulator();
            }
            case 2: {
                return new SimpleShortManipulator();
            }
            case 3: {
                return new SimpleIntegerManipulator();
            }
            case 4: {
                return new SimpleLongManipulator();
            }
            case 5: {
                return new SimpleFloatManipulator();
            }
            case 6: {
                return new SimpleDoubleManipulator();
            }
            case 7: {
                return new SimpleObjectManipulator();
            }
        }
        return null;
    }

    public class SimpleObjectManipulator
    extends Buffer.ObjectManipulator {
        protected transient Object[] buffer;

        public SimpleObjectManipulator() {
            if (SimpleBuffer.this.valid != null) {
                this.buffer = new Object[SimpleBuffer.this.valid.length];
            }
        }

        public Object getValue(long l) throws DataException {
            if (l >= SimpleBuffer.this.startIndex && l <= SimpleBuffer.this.endIndex) {
                int n = (int)(l - SimpleBuffer.this.startIndex);
                if (!SimpleBuffer.this.valid[n]) {
                    this.buffer[n] = SimpleBuffer.this.provider.getObjectValue(l);
                    SimpleBuffer.this.valid[n] = true;
                }
                return this.buffer[n];
            }
            Object object = SimpleBuffer.this.provider.getObjectValue(l);
            if (SimpleBuffer.this.startIndex < 0L || SimpleBuffer.this.endIndex < 0L) {
                SimpleBuffer.this.startIndex = SimpleBuffer.this.endIndex = l;
                this.buffer[0] = object;
                SimpleBuffer.this.valid[0] = true;
                return object;
            }
            if (l < SimpleBuffer.this.startIndex) {
                int n = (int)(SimpleBuffer.this.startIndex - l);
                if (n >= this.buffer.length) {
                    SimpleBuffer.this.startIndex = SimpleBuffer.this.endIndex = l;
                } else {
                    try {
                        System.arraycopy(this.buffer, 0, this.buffer, n, this.buffer.length - n);
                        System.arraycopy(SimpleBuffer.this.valid, 0, SimpleBuffer.this.valid, n, SimpleBuffer.this.valid.length - n);
                        Arrays.fill(SimpleBuffer.this.valid, 0, n, false);
                        SimpleBuffer.this.startIndex = l;
                        if (SimpleBuffer.this.endIndex - SimpleBuffer.this.startIndex >= (long)this.buffer.length) {
                            SimpleBuffer.this.endIndex = SimpleBuffer.this.startIndex + (long)this.buffer.length - 1L;
                        }
                    }
                    catch (Exception exception) {
                        SimpleBuffer.this.startIndex = SimpleBuffer.this.endIndex = l;
                    }
                }
                this.buffer[0] = object;
                SimpleBuffer.this.valid[0] = true;
                return object;
            }
            int n = (int)(l - SimpleBuffer.this.startIndex);
            if (n < this.buffer.length) {
                if (SimpleBuffer.this.endIndex - SimpleBuffer.this.startIndex + 1L <= (long)n) {
                    Arrays.fill(SimpleBuffer.this.valid, (int)(SimpleBuffer.this.endIndex - SimpleBuffer.this.startIndex + 1L), n, false);
                }
                SimpleBuffer.this.endIndex = l;
                this.buffer[n] = object;
                SimpleBuffer.this.valid[n] = true;
                return object;
            }
            n = this.buffer.length >> 1;
            int n2 = (int)(l - (long)n);
            if (SimpleBuffer.this.endIndex >= (long)n2) {
                int n3 = (int)(SimpleBuffer.this.endIndex - (long)n2 + 1L);
                int n4 = (int)((long)n2 - SimpleBuffer.this.startIndex);
                System.arraycopy(this.buffer, n4, this.buffer, 0, n3);
                System.arraycopy(SimpleBuffer.this.valid, n4, SimpleBuffer.this.valid, 0, n3);
                Arrays.fill(SimpleBuffer.this.valid, n3, SimpleBuffer.this.valid.length, false);
            } else {
                Arrays.fill(SimpleBuffer.this.valid, 0, SimpleBuffer.this.valid.length, false);
            }
            SimpleBuffer.this.startIndex = n2;
            SimpleBuffer.this.endIndex = l;
            this.buffer[n] = object;
            SimpleBuffer.this.valid[n] = true;
            return object;
        }

        public boolean setValue(long l, Object object) throws DataException {
            if (SimpleBuffer.this.startIndex < 0L || SimpleBuffer.this.endIndex < 0L) {
                SimpleBuffer.this.startIndex = SimpleBuffer.this.endIndex = l;
                this.buffer[0] = object;
                SimpleBuffer.this.valid[0] = true;
                return true;
            }
            if (l < SimpleBuffer.this.startIndex || l >= (long)this.buffer.length + SimpleBuffer.this.startIndex) {
                return false;
            }
            int n = (int)(l - SimpleBuffer.this.startIndex);
            if (SimpleBuffer.this.endIndex < l) {
                Arrays.fill(SimpleBuffer.this.valid, (int)(SimpleBuffer.this.endIndex - SimpleBuffer.this.startIndex + 1L), n, false);
                SimpleBuffer.this.endIndex = l;
            }
            this.buffer[n] = object;
            SimpleBuffer.this.valid[n] = true;
            return true;
        }

        public Object clone() {
            SimpleObjectManipulator simpleObjectManipulator = (SimpleObjectManipulator)super.clone();
            simpleObjectManipulator.buffer = (Object[])this.buffer.clone();
            return simpleObjectManipulator;
        }
    }

    public class SimpleDoubleManipulator
    extends Buffer.DoubleManipulator {
        protected transient double[] buffer;

        public SimpleDoubleManipulator() {
            if (SimpleBuffer.this.valid != null) {
                this.buffer = new double[SimpleBuffer.this.valid.length];
            }
        }

        public double getValue(long l) throws DataException {
            if (l >= SimpleBuffer.this.startIndex && l <= SimpleBuffer.this.endIndex) {
                int n = (int)(l - SimpleBuffer.this.startIndex);
                if (!SimpleBuffer.this.valid[n]) {
                    this.buffer[n] = SimpleBuffer.this.provider.getDoubleValue(l);
                    SimpleBuffer.this.valid[n] = true;
                }
                return this.buffer[n];
            }
            double d = SimpleBuffer.this.provider.getDoubleValue(l);
            if (SimpleBuffer.this.startIndex < 0L || SimpleBuffer.this.endIndex < 0L) {
                SimpleBuffer.this.startIndex = SimpleBuffer.this.endIndex = l;
                this.buffer[0] = d;
                SimpleBuffer.this.valid[0] = true;
                return d;
            }
            if (l < SimpleBuffer.this.startIndex) {
                int n = (int)(SimpleBuffer.this.startIndex - l);
                if (n >= this.buffer.length) {
                    SimpleBuffer.this.startIndex = SimpleBuffer.this.endIndex = l;
                } else {
                    try {
                        System.arraycopy(this.buffer, 0, this.buffer, n, this.buffer.length - n);
                        System.arraycopy(SimpleBuffer.this.valid, 0, SimpleBuffer.this.valid, n, SimpleBuffer.this.valid.length - n);
                        Arrays.fill(SimpleBuffer.this.valid, 0, n, false);
                        SimpleBuffer.this.startIndex = l;
                        if (SimpleBuffer.this.endIndex - SimpleBuffer.this.startIndex >= (long)this.buffer.length) {
                            SimpleBuffer.this.endIndex = SimpleBuffer.this.startIndex + (long)this.buffer.length - 1L;
                        }
                    }
                    catch (Exception exception) {
                        SimpleBuffer.this.startIndex = SimpleBuffer.this.endIndex = l;
                    }
                }
                this.buffer[0] = d;
                SimpleBuffer.this.valid[0] = true;
                return d;
            }
            int n = (int)(l - SimpleBuffer.this.startIndex);
            if (n < this.buffer.length) {
                if (SimpleBuffer.this.endIndex - SimpleBuffer.this.startIndex + 1L <= (long)n) {
                    Arrays.fill(SimpleBuffer.this.valid, (int)(SimpleBuffer.this.endIndex - SimpleBuffer.this.startIndex + 1L), n, false);
                }
                SimpleBuffer.this.endIndex = l;
                this.buffer[n] = d;
                SimpleBuffer.this.valid[n] = true;
                return d;
            }
            n = this.buffer.length >> 1;
            int n2 = (int)(l - (long)n);
            if (SimpleBuffer.this.endIndex >= (long)n2) {
                int n3 = (int)(SimpleBuffer.this.endIndex - (long)n2 + 1L);
                int n4 = (int)((long)n2 - SimpleBuffer.this.startIndex);
                System.arraycopy(this.buffer, n4, this.buffer, 0, n3);
                System.arraycopy(SimpleBuffer.this.valid, n4, SimpleBuffer.this.valid, 0, n3);
                Arrays.fill(SimpleBuffer.this.valid, n3, SimpleBuffer.this.valid.length, false);
            } else {
                Arrays.fill(SimpleBuffer.this.valid, 0, SimpleBuffer.this.valid.length, false);
            }
            SimpleBuffer.this.startIndex = n2;
            SimpleBuffer.this.endIndex = l;
            this.buffer[n] = d;
            SimpleBuffer.this.valid[n] = true;
            return d;
        }

        public boolean setValue(long l, double d) throws DataException {
            if (SimpleBuffer.this.startIndex < 0L || SimpleBuffer.this.endIndex < 0L) {
                SimpleBuffer.this.startIndex = SimpleBuffer.this.endIndex = l;
                this.buffer[0] = d;
                SimpleBuffer.this.valid[0] = true;
                return true;
            }
            if (l < SimpleBuffer.this.startIndex || l >= (long)this.buffer.length + SimpleBuffer.this.startIndex) {
                return false;
            }
            int n = (int)(l - SimpleBuffer.this.startIndex);
            if (SimpleBuffer.this.endIndex < l) {
                Arrays.fill(SimpleBuffer.this.valid, (int)(SimpleBuffer.this.endIndex - SimpleBuffer.this.startIndex + 1L), n, false);
                SimpleBuffer.this.endIndex = l;
            }
            this.buffer[n] = d;
            SimpleBuffer.this.valid[n] = true;
            return true;
        }

        public Object clone() {
            SimpleDoubleManipulator simpleDoubleManipulator = (SimpleDoubleManipulator)super.clone();
            simpleDoubleManipulator.buffer = (double[])this.buffer.clone();
            return simpleDoubleManipulator;
        }
    }

    public class SimpleFloatManipulator
    extends Buffer.FloatManipulator {
        protected transient float[] buffer;

        public SimpleFloatManipulator() {
            if (SimpleBuffer.this.valid != null) {
                this.buffer = new float[SimpleBuffer.this.valid.length];
            }
        }

        public float getValue(long l) throws DataException {
            if (l >= SimpleBuffer.this.startIndex && l <= SimpleBuffer.this.endIndex) {
                int n = (int)(l - SimpleBuffer.this.startIndex);
                if (!SimpleBuffer.this.valid[n]) {
                    this.buffer[n] = SimpleBuffer.this.provider.getFloatValue(l);
                    SimpleBuffer.this.valid[n] = true;
                }
                return this.buffer[n];
            }
            float f = SimpleBuffer.this.provider.getFloatValue(l);
            if (SimpleBuffer.this.startIndex < 0L || SimpleBuffer.this.endIndex < 0L) {
                SimpleBuffer.this.startIndex = SimpleBuffer.this.endIndex = l;
                this.buffer[0] = f;
                SimpleBuffer.this.valid[0] = true;
                return f;
            }
            if (l < SimpleBuffer.this.startIndex) {
                int n = (int)(SimpleBuffer.this.startIndex - l);
                if (n >= this.buffer.length) {
                    SimpleBuffer.this.startIndex = SimpleBuffer.this.endIndex = l;
                } else {
                    try {
                        System.arraycopy(this.buffer, 0, this.buffer, n, this.buffer.length - n);
                        System.arraycopy(SimpleBuffer.this.valid, 0, SimpleBuffer.this.valid, n, SimpleBuffer.this.valid.length - n);
                        Arrays.fill(SimpleBuffer.this.valid, 0, n, false);
                        SimpleBuffer.this.startIndex = l;
                        if (SimpleBuffer.this.endIndex - SimpleBuffer.this.startIndex >= (long)this.buffer.length) {
                            SimpleBuffer.this.endIndex = SimpleBuffer.this.startIndex + (long)this.buffer.length - 1L;
                        }
                    }
                    catch (Exception exception) {
                        SimpleBuffer.this.startIndex = SimpleBuffer.this.endIndex = l;
                    }
                }
                this.buffer[0] = f;
                SimpleBuffer.this.valid[0] = true;
                return f;
            }
            int n = (int)(l - SimpleBuffer.this.startIndex);
            if (n < this.buffer.length) {
                if (SimpleBuffer.this.endIndex - SimpleBuffer.this.startIndex + 1L <= (long)n) {
                    Arrays.fill(SimpleBuffer.this.valid, (int)(SimpleBuffer.this.endIndex - SimpleBuffer.this.startIndex + 1L), n, false);
                }
                SimpleBuffer.this.endIndex = l;
                this.buffer[n] = f;
                SimpleBuffer.this.valid[n] = true;
                return f;
            }
            n = this.buffer.length >> 1;
            int n2 = (int)(l - (long)n);
            if (SimpleBuffer.this.endIndex >= (long)n2) {
                int n3 = (int)(SimpleBuffer.this.endIndex - (long)n2 + 1L);
                int n4 = (int)((long)n2 - SimpleBuffer.this.startIndex);
                System.arraycopy(this.buffer, n4, this.buffer, 0, n3);
                System.arraycopy(SimpleBuffer.this.valid, n4, SimpleBuffer.this.valid, 0, n3);
                Arrays.fill(SimpleBuffer.this.valid, n3, SimpleBuffer.this.valid.length, false);
            } else {
                Arrays.fill(SimpleBuffer.this.valid, 0, SimpleBuffer.this.valid.length, false);
            }
            SimpleBuffer.this.startIndex = n2;
            SimpleBuffer.this.endIndex = l;
            this.buffer[n] = f;
            SimpleBuffer.this.valid[n] = true;
            return f;
        }

        public boolean setValue(long l, float f) throws DataException {
            if (SimpleBuffer.this.startIndex < 0L || SimpleBuffer.this.endIndex < 0L) {
                SimpleBuffer.this.startIndex = SimpleBuffer.this.endIndex = l;
                this.buffer[0] = f;
                SimpleBuffer.this.valid[0] = true;
                return true;
            }
            if (l < SimpleBuffer.this.startIndex || l >= (long)this.buffer.length + SimpleBuffer.this.startIndex) {
                return false;
            }
            int n = (int)(l - SimpleBuffer.this.startIndex);
            if (SimpleBuffer.this.endIndex < l) {
                Arrays.fill(SimpleBuffer.this.valid, (int)(SimpleBuffer.this.endIndex - SimpleBuffer.this.startIndex + 1L), n, false);
                SimpleBuffer.this.endIndex = l;
            }
            this.buffer[n] = f;
            SimpleBuffer.this.valid[n] = true;
            return true;
        }

        public Object clone() {
            SimpleFloatManipulator simpleFloatManipulator = (SimpleFloatManipulator)super.clone();
            simpleFloatManipulator.buffer = (float[])this.buffer.clone();
            return simpleFloatManipulator;
        }
    }

    public class SimpleLongManipulator
    extends Buffer.LongManipulator {
        protected transient long[] buffer;

        public SimpleLongManipulator() {
            if (SimpleBuffer.this.valid != null) {
                this.buffer = new long[SimpleBuffer.this.valid.length];
            }
        }

        public long getValue(long l) throws DataException {
            if (l >= SimpleBuffer.this.startIndex && l <= SimpleBuffer.this.endIndex) {
                int n = (int)(l - SimpleBuffer.this.startIndex);
                if (!SimpleBuffer.this.valid[n]) {
                    this.buffer[n] = SimpleBuffer.this.provider.getLongValue(l);
                    SimpleBuffer.this.valid[n] = true;
                }
                return this.buffer[n];
            }
            long l2 = SimpleBuffer.this.provider.getLongValue(l);
            if (SimpleBuffer.this.startIndex < 0L || SimpleBuffer.this.endIndex < 0L) {
                SimpleBuffer.this.startIndex = SimpleBuffer.this.endIndex = l;
                this.buffer[0] = l2;
                SimpleBuffer.this.valid[0] = true;
                return l2;
            }
            if (l < SimpleBuffer.this.startIndex) {
                int n = (int)(SimpleBuffer.this.startIndex - l);
                if (n >= this.buffer.length) {
                    SimpleBuffer.this.startIndex = SimpleBuffer.this.endIndex = l;
                } else {
                    try {
                        System.arraycopy(this.buffer, 0, this.buffer, n, this.buffer.length - n);
                        System.arraycopy(SimpleBuffer.this.valid, 0, SimpleBuffer.this.valid, n, SimpleBuffer.this.valid.length - n);
                        Arrays.fill(SimpleBuffer.this.valid, 0, n, false);
                        SimpleBuffer.this.startIndex = l;
                        if (SimpleBuffer.this.endIndex - SimpleBuffer.this.startIndex >= (long)this.buffer.length) {
                            SimpleBuffer.this.endIndex = SimpleBuffer.this.startIndex + (long)this.buffer.length - 1L;
                        }
                    }
                    catch (Exception exception) {
                        SimpleBuffer.this.startIndex = SimpleBuffer.this.endIndex = l;
                    }
                }
                this.buffer[0] = l2;
                SimpleBuffer.this.valid[0] = true;
                return l2;
            }
            int n = (int)(l - SimpleBuffer.this.startIndex);
            if (n < this.buffer.length) {
                if (SimpleBuffer.this.endIndex - SimpleBuffer.this.startIndex + 1L <= (long)n) {
                    Arrays.fill(SimpleBuffer.this.valid, (int)(SimpleBuffer.this.endIndex - SimpleBuffer.this.startIndex + 1L), n, false);
                }
                SimpleBuffer.this.endIndex = l;
                this.buffer[n] = l2;
                SimpleBuffer.this.valid[n] = true;
                return l2;
            }
            n = this.buffer.length >> 1;
            int n2 = (int)(l - (long)n);
            if (SimpleBuffer.this.endIndex >= (long)n2) {
                int n3 = (int)(SimpleBuffer.this.endIndex - (long)n2 + 1L);
                int n4 = (int)((long)n2 - SimpleBuffer.this.startIndex);
                System.arraycopy(this.buffer, n4, this.buffer, 0, n3);
                System.arraycopy(SimpleBuffer.this.valid, n4, SimpleBuffer.this.valid, 0, n3);
                Arrays.fill(SimpleBuffer.this.valid, n3, SimpleBuffer.this.valid.length, false);
            } else {
                Arrays.fill(SimpleBuffer.this.valid, 0, SimpleBuffer.this.valid.length, false);
            }
            SimpleBuffer.this.startIndex = n2;
            SimpleBuffer.this.endIndex = l;
            this.buffer[n] = l2;
            SimpleBuffer.this.valid[n] = true;
            return l2;
        }

        public boolean setValue(long l, long l2) throws DataException {
            if (SimpleBuffer.this.startIndex < 0L || SimpleBuffer.this.endIndex < 0L) {
                SimpleBuffer.this.startIndex = SimpleBuffer.this.endIndex = l;
                this.buffer[0] = l2;
                SimpleBuffer.this.valid[0] = true;
                return true;
            }
            if (l < SimpleBuffer.this.startIndex || l >= (long)this.buffer.length + SimpleBuffer.this.startIndex) {
                return false;
            }
            int n = (int)(l - SimpleBuffer.this.startIndex);
            if (SimpleBuffer.this.endIndex < l) {
                Arrays.fill(SimpleBuffer.this.valid, (int)(SimpleBuffer.this.endIndex - SimpleBuffer.this.startIndex + 1L), n, false);
                SimpleBuffer.this.endIndex = l;
            }
            this.buffer[n] = l2;
            SimpleBuffer.this.valid[n] = true;
            return true;
        }

        public Object clone() {
            SimpleLongManipulator simpleLongManipulator = (SimpleLongManipulator)super.clone();
            simpleLongManipulator.buffer = (long[])this.buffer.clone();
            return simpleLongManipulator;
        }
    }

    public class SimpleIntegerManipulator
    extends Buffer.IntegerManipulator {
        protected transient int[] buffer;

        public SimpleIntegerManipulator() {
            if (SimpleBuffer.this.valid != null) {
                this.buffer = new int[SimpleBuffer.this.valid.length];
            }
        }

        public int getValue(long l) throws DataException {
            if (l >= SimpleBuffer.this.startIndex && l <= SimpleBuffer.this.endIndex) {
                int n = (int)(l - SimpleBuffer.this.startIndex);
                if (!SimpleBuffer.this.valid[n]) {
                    this.buffer[n] = SimpleBuffer.this.provider.getIntegerValue(l);
                    SimpleBuffer.this.valid[n] = true;
                }
                return this.buffer[n];
            }
            int n = SimpleBuffer.this.provider.getIntegerValue(l);
            if (SimpleBuffer.this.startIndex < 0L || SimpleBuffer.this.endIndex < 0L) {
                SimpleBuffer.this.startIndex = SimpleBuffer.this.endIndex = l;
                this.buffer[0] = n;
                SimpleBuffer.this.valid[0] = true;
                return n;
            }
            if (l < SimpleBuffer.this.startIndex) {
                int n2 = (int)(SimpleBuffer.this.startIndex - l);
                if (n2 >= this.buffer.length) {
                    SimpleBuffer.this.startIndex = SimpleBuffer.this.endIndex = l;
                } else {
                    try {
                        System.arraycopy(this.buffer, 0, this.buffer, n2, this.buffer.length - n2);
                        System.arraycopy(SimpleBuffer.this.valid, 0, SimpleBuffer.this.valid, n2, SimpleBuffer.this.valid.length - n2);
                        Arrays.fill(SimpleBuffer.this.valid, 0, n2, false);
                        SimpleBuffer.this.startIndex = l;
                        if (SimpleBuffer.this.endIndex - SimpleBuffer.this.startIndex >= (long)this.buffer.length) {
                            SimpleBuffer.this.endIndex = SimpleBuffer.this.startIndex + (long)this.buffer.length - 1L;
                        }
                    }
                    catch (Exception exception) {
                        SimpleBuffer.this.startIndex = SimpleBuffer.this.endIndex = l;
                    }
                }
                this.buffer[0] = n;
                SimpleBuffer.this.valid[0] = true;
                return n;
            }
            int n3 = (int)(l - SimpleBuffer.this.startIndex);
            if (n3 < this.buffer.length) {
                if (SimpleBuffer.this.endIndex - SimpleBuffer.this.startIndex + 1L <= (long)n3) {
                    Arrays.fill(SimpleBuffer.this.valid, (int)(SimpleBuffer.this.endIndex - SimpleBuffer.this.startIndex + 1L), n3, false);
                }
                SimpleBuffer.this.endIndex = l;
                this.buffer[n3] = n;
                SimpleBuffer.this.valid[n3] = true;
                return n;
            }
            n3 = this.buffer.length >> 1;
            int n4 = (int)(l - (long)n3);
            if (SimpleBuffer.this.endIndex >= (long)n4) {
                int n5 = (int)(SimpleBuffer.this.endIndex - (long)n4 + 1L);
                int n6 = (int)((long)n4 - SimpleBuffer.this.startIndex);
                System.arraycopy(this.buffer, n6, this.buffer, 0, n5);
                System.arraycopy(SimpleBuffer.this.valid, n6, SimpleBuffer.this.valid, 0, n5);
                Arrays.fill(SimpleBuffer.this.valid, n5, SimpleBuffer.this.valid.length, false);
            } else {
                Arrays.fill(SimpleBuffer.this.valid, 0, SimpleBuffer.this.valid.length, false);
            }
            SimpleBuffer.this.startIndex = n4;
            SimpleBuffer.this.endIndex = l;
            this.buffer[n3] = n;
            SimpleBuffer.this.valid[n3] = true;
            return n;
        }

        public boolean setValue(long l, int n) throws DataException {
            if (SimpleBuffer.this.startIndex < 0L || SimpleBuffer.this.endIndex < 0L) {
                SimpleBuffer.this.startIndex = SimpleBuffer.this.endIndex = l;
                this.buffer[0] = n;
                SimpleBuffer.this.valid[0] = true;
                return true;
            }
            if (l < SimpleBuffer.this.startIndex || l >= (long)this.buffer.length + SimpleBuffer.this.startIndex) {
                return false;
            }
            int n2 = (int)(l - SimpleBuffer.this.startIndex);
            if (SimpleBuffer.this.endIndex < l) {
                Arrays.fill(SimpleBuffer.this.valid, (int)(SimpleBuffer.this.endIndex - SimpleBuffer.this.startIndex + 1L), n2, false);
                SimpleBuffer.this.endIndex = l;
            }
            this.buffer[n2] = n;
            SimpleBuffer.this.valid[n2] = true;
            return true;
        }

        public Object clone() {
            SimpleIntegerManipulator simpleIntegerManipulator = (SimpleIntegerManipulator)super.clone();
            simpleIntegerManipulator.buffer = (int[])this.buffer.clone();
            return simpleIntegerManipulator;
        }
    }

    public class SimpleShortManipulator
    extends Buffer.ShortManipulator {
        protected transient short[] buffer;

        public SimpleShortManipulator() {
            if (SimpleBuffer.this.valid != null) {
                this.buffer = new short[SimpleBuffer.this.valid.length];
            }
        }

        public short getValue(long l) throws DataException {
            if (l >= SimpleBuffer.this.startIndex && l <= SimpleBuffer.this.endIndex) {
                int n = (int)(l - SimpleBuffer.this.startIndex);
                if (!SimpleBuffer.this.valid[n]) {
                    this.buffer[n] = SimpleBuffer.this.provider.getShortValue(l);
                    SimpleBuffer.this.valid[n] = true;
                }
                return this.buffer[n];
            }
            short s = SimpleBuffer.this.provider.getShortValue(l);
            if (SimpleBuffer.this.startIndex < 0L || SimpleBuffer.this.endIndex < 0L) {
                SimpleBuffer.this.startIndex = SimpleBuffer.this.endIndex = l;
                this.buffer[0] = s;
                SimpleBuffer.this.valid[0] = true;
                return s;
            }
            if (l < SimpleBuffer.this.startIndex) {
                int n = (int)(SimpleBuffer.this.startIndex - l);
                if (n >= this.buffer.length) {
                    SimpleBuffer.this.startIndex = SimpleBuffer.this.endIndex = l;
                } else {
                    try {
                        System.arraycopy(this.buffer, 0, this.buffer, n, this.buffer.length - n);
                        System.arraycopy(SimpleBuffer.this.valid, 0, SimpleBuffer.this.valid, n, SimpleBuffer.this.valid.length - n);
                        Arrays.fill(SimpleBuffer.this.valid, 0, n, false);
                        SimpleBuffer.this.startIndex = l;
                        if (SimpleBuffer.this.endIndex - SimpleBuffer.this.startIndex >= (long)this.buffer.length) {
                            SimpleBuffer.this.endIndex = SimpleBuffer.this.startIndex + (long)this.buffer.length - 1L;
                        }
                    }
                    catch (Exception exception) {
                        SimpleBuffer.this.startIndex = SimpleBuffer.this.endIndex = l;
                    }
                }
                this.buffer[0] = s;
                SimpleBuffer.this.valid[0] = true;
                return s;
            }
            int n = (int)(l - SimpleBuffer.this.startIndex);
            if (n < this.buffer.length) {
                if (SimpleBuffer.this.endIndex - SimpleBuffer.this.startIndex + 1L <= (long)n) {
                    Arrays.fill(SimpleBuffer.this.valid, (int)(SimpleBuffer.this.endIndex - SimpleBuffer.this.startIndex + 1L), n, false);
                }
                SimpleBuffer.this.endIndex = l;
                this.buffer[n] = s;
                SimpleBuffer.this.valid[n] = true;
                return s;
            }
            n = this.buffer.length >> 1;
            int n2 = (int)(l - (long)n);
            if (SimpleBuffer.this.endIndex >= (long)n2) {
                int n3 = (int)(SimpleBuffer.this.endIndex - (long)n2 + 1L);
                int n4 = (int)((long)n2 - SimpleBuffer.this.startIndex);
                System.arraycopy(this.buffer, n4, this.buffer, 0, n3);
                System.arraycopy(SimpleBuffer.this.valid, n4, SimpleBuffer.this.valid, 0, n3);
                Arrays.fill(SimpleBuffer.this.valid, n3, SimpleBuffer.this.valid.length, false);
            } else {
                Arrays.fill(SimpleBuffer.this.valid, 0, SimpleBuffer.this.valid.length, false);
            }
            SimpleBuffer.this.startIndex = n2;
            SimpleBuffer.this.endIndex = l;
            this.buffer[n] = s;
            SimpleBuffer.this.valid[n] = true;
            return s;
        }

        public boolean setValue(long l, short s) throws DataException {
            if (SimpleBuffer.this.startIndex < 0L || SimpleBuffer.this.endIndex < 0L) {
                SimpleBuffer.this.startIndex = SimpleBuffer.this.endIndex = l;
                this.buffer[0] = s;
                SimpleBuffer.this.valid[0] = true;
                return true;
            }
            if (l < SimpleBuffer.this.startIndex || l >= (long)this.buffer.length + SimpleBuffer.this.startIndex) {
                return false;
            }
            int n = (int)(l - SimpleBuffer.this.startIndex);
            if (SimpleBuffer.this.endIndex < l) {
                Arrays.fill(SimpleBuffer.this.valid, (int)(SimpleBuffer.this.endIndex - SimpleBuffer.this.startIndex + 1L), n, false);
                SimpleBuffer.this.endIndex = l;
            }
            this.buffer[n] = s;
            SimpleBuffer.this.valid[n] = true;
            return true;
        }

        public Object clone() {
            SimpleShortManipulator simpleShortManipulator = (SimpleShortManipulator)super.clone();
            simpleShortManipulator.buffer = (short[])this.buffer.clone();
            return simpleShortManipulator;
        }
    }

    public class SimpleByteManipulator
    extends Buffer.ByteManipulator {
        protected transient byte[] buffer;

        public SimpleByteManipulator() {
            if (SimpleBuffer.this.valid != null) {
                this.buffer = new byte[SimpleBuffer.this.valid.length];
            }
        }

        public byte getValue(long l) throws DataException {
            if (l >= SimpleBuffer.this.startIndex && l <= SimpleBuffer.this.endIndex) {
                int n = (int)(l - SimpleBuffer.this.startIndex);
                if (!SimpleBuffer.this.valid[n]) {
                    this.buffer[n] = SimpleBuffer.this.provider.getByteValue(l);
                    SimpleBuffer.this.valid[n] = true;
                }
                return this.buffer[n];
            }
            byte by = SimpleBuffer.this.provider.getByteValue(l);
            if (SimpleBuffer.this.startIndex < 0L || SimpleBuffer.this.endIndex < 0L) {
                SimpleBuffer.this.startIndex = SimpleBuffer.this.endIndex = l;
                this.buffer[0] = by;
                SimpleBuffer.this.valid[0] = true;
                return by;
            }
            if (l < SimpleBuffer.this.startIndex) {
                int n = (int)(SimpleBuffer.this.startIndex - l);
                if (n >= this.buffer.length) {
                    SimpleBuffer.this.startIndex = SimpleBuffer.this.endIndex = l;
                } else {
                    try {
                        System.arraycopy(this.buffer, 0, this.buffer, n, this.buffer.length - n);
                        System.arraycopy(SimpleBuffer.this.valid, 0, SimpleBuffer.this.valid, n, SimpleBuffer.this.valid.length - n);
                        Arrays.fill(SimpleBuffer.this.valid, 0, n, false);
                        SimpleBuffer.this.startIndex = l;
                        if (SimpleBuffer.this.endIndex - SimpleBuffer.this.startIndex >= (long)this.buffer.length) {
                            SimpleBuffer.this.endIndex = SimpleBuffer.this.startIndex + (long)this.buffer.length - 1L;
                        }
                    }
                    catch (Exception exception) {
                        SimpleBuffer.this.startIndex = SimpleBuffer.this.endIndex = l;
                    }
                }
                this.buffer[0] = by;
                SimpleBuffer.this.valid[0] = true;
                return by;
            }
            int n = (int)(l - SimpleBuffer.this.startIndex);
            if (n < this.buffer.length) {
                if (SimpleBuffer.this.endIndex - SimpleBuffer.this.startIndex + 1L <= (long)n) {
                    Arrays.fill(SimpleBuffer.this.valid, (int)(SimpleBuffer.this.endIndex - SimpleBuffer.this.startIndex + 1L), n, false);
                }
                SimpleBuffer.this.endIndex = l;
                this.buffer[n] = by;
                SimpleBuffer.this.valid[n] = true;
                return by;
            }
            n = this.buffer.length >> 1;
            int n2 = (int)(l - (long)n);
            if (SimpleBuffer.this.endIndex >= (long)n2) {
                int n3 = (int)(SimpleBuffer.this.endIndex - (long)n2 + 1L);
                int n4 = (int)((long)n2 - SimpleBuffer.this.startIndex);
                System.arraycopy(this.buffer, n4, this.buffer, 0, n3);
                System.arraycopy(SimpleBuffer.this.valid, n4, SimpleBuffer.this.valid, 0, n3);
                Arrays.fill(SimpleBuffer.this.valid, n3, SimpleBuffer.this.valid.length, false);
            } else {
                Arrays.fill(SimpleBuffer.this.valid, 0, SimpleBuffer.this.valid.length, false);
            }
            SimpleBuffer.this.startIndex = n2;
            SimpleBuffer.this.endIndex = l;
            this.buffer[n] = by;
            SimpleBuffer.this.valid[n] = true;
            return by;
        }

        public boolean setValue(long l, byte by) throws DataException {
            if (SimpleBuffer.this.startIndex < 0L || SimpleBuffer.this.endIndex < 0L) {
                SimpleBuffer.this.startIndex = SimpleBuffer.this.endIndex = l;
                this.buffer[0] = by;
                SimpleBuffer.this.valid[0] = true;
                return true;
            }
            if (l < SimpleBuffer.this.startIndex || l >= (long)this.buffer.length + SimpleBuffer.this.startIndex) {
                return false;
            }
            int n = (int)(l - SimpleBuffer.this.startIndex);
            if (SimpleBuffer.this.endIndex < l) {
                Arrays.fill(SimpleBuffer.this.valid, (int)(SimpleBuffer.this.endIndex - SimpleBuffer.this.startIndex + 1L), n, false);
                SimpleBuffer.this.endIndex = l;
            }
            this.buffer[n] = by;
            SimpleBuffer.this.valid[n] = true;
            return true;
        }

        public Object clone() {
            SimpleByteManipulator simpleByteManipulator = (SimpleByteManipulator)super.clone();
            simpleByteManipulator.buffer = (byte[])this.buffer.clone();
            return simpleByteManipulator;
        }
    }
}

