/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.generator.model;

import java.util.ArrayList;
import java.util.HashMap;
import org.jfree.util.Log;
import org.jfree.xml.generator.model.ManualMappingInfo;
import org.jfree.xml.generator.model.MultiplexMappingInfo;

public class MappingModel {
    private HashMap mappingInfos = new HashMap();
    private ArrayList manualMappings = new ArrayList();
    private ArrayList multiplexMappings = new ArrayList();

    public MultiplexMappingInfo[] getMultiplexMapping() {
        return this.multiplexMappings.toArray(new MultiplexMappingInfo[this.multiplexMappings.size()]);
    }

    public ManualMappingInfo[] getManualMapping() {
        return this.manualMappings.toArray(new ManualMappingInfo[this.manualMappings.size()]);
    }

    public void addManualMapping(ManualMappingInfo manualMappingInfo) {
        if (!this.mappingInfos.containsKey(manualMappingInfo.getBaseClass())) {
            this.manualMappings.add(manualMappingInfo);
            this.mappingInfos.put(manualMappingInfo.getBaseClass(), manualMappingInfo);
        } else {
            Object v = this.mappingInfos.get(manualMappingInfo.getBaseClass());
            if (v instanceof ManualMappingInfo) {
                Log.info("Duplicate manual mapping: " + manualMappingInfo.getBaseClass());
            } else {
                throw new IllegalArgumentException("This mapping is already a multiplex mapping.");
            }
        }
    }

    public void addMultiplexMapping(MultiplexMappingInfo multiplexMappingInfo) {
        if (!this.mappingInfos.containsKey(multiplexMappingInfo.getBaseClass())) {
            this.multiplexMappings.add(multiplexMappingInfo);
            this.mappingInfos.put(multiplexMappingInfo.getBaseClass(), multiplexMappingInfo);
        } else {
            Object v = this.mappingInfos.get(multiplexMappingInfo.getBaseClass());
            if (v instanceof ManualMappingInfo) {
                throw new IllegalArgumentException("This mapping is already a manual mapping.");
            }
            Log.info("Duplicate Multiplex mapping: " + multiplexMappingInfo.getBaseClass(), new Exception());
        }
    }

    public MultiplexMappingInfo lookupMultiplexMapping(Class clazz) {
        Object v = this.mappingInfos.get(clazz);
        if (v instanceof MultiplexMappingInfo) {
            return (MultiplexMappingInfo)v;
        }
        return null;
    }
}

