/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.builtin;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import jsynoptic.base.ContextualActionProvider;
import jsynoptic.base.Linkable;
import jsynoptic.builtin.Abstract1DShape;
import jsynoptic.builtin.AutomatonAction;
import jsynoptic.builtin.AutomatonActionList;
import jsynoptic.builtin.AutomatonActionMapper;
import jsynoptic.builtin.TextShape;
import jsynoptic.ui.LongAction;
import jsynoptic.ui.SourceTree;
import simtools.data.DataException;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.DataSourceListener;
import simtools.data.DataSourcePool;
import simtools.data.EndNotificationListener;
import simtools.data.UnsupportedOperation;
import simtools.diagram.Resizable;
import simtools.shapes.AbstractShape;
import simtools.ui.NumberField;
import simtools.ui.ResourceFinder;

public class AutomatonShape
extends AbstractShape
implements Resizable,
DataSourceListener,
ContextualActionProvider,
Linkable,
EndNotificationListener {
    static final long serialVersionUID = -2166910190999229946L;
    public static ResourceBundle resources = ResourceFinder.get(class$jsynoptic$builtin$AutomatonShape == null ? (class$jsynoptic$builtin$AutomatonShape = AutomatonShape.class$("jsynoptic.builtin.AutomatonShape")) : class$jsynoptic$builtin$AutomatonShape, Abstract1DShape.resources);
    public static int MIN_CELL_WIDTH = 5;
    public static int MIN_CELL_HEIGHT = 5;
    protected AutomatonActionMapper mapper;
    protected transient DataSource source;
    protected transient long index;
    protected boolean allowResize;
    protected boolean fixedRatio;
    protected double ratio;
    protected int activeX;
    protected int activeY;
    protected String link;
    protected Cell[][] cells;
    protected transient boolean dirtyState = false;
    static /* synthetic */ Class class$jsynoptic$builtin$AutomatonShape;

    public String getLink() {
        return this.link;
    }

    public void setLink(String string) {
        this.link = string;
    }

    public AutomatonShape(int n, int n2) {
        this(n, n2, 5, 5);
    }

    public AutomatonShape(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, n3 * MIN_CELL_WIDTH, n4 * MIN_CELL_HEIGHT);
    }

    public AutomatonShape(int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2);
        this._w = n5;
        this._h = n6;
        this.cells = new Cell[n4][n3];
        for (int i = 0; i < this.cells.length; ++i) {
            for (int j = 0; j < this.cells[i].length; ++j) {
                this.cells[i][j] = new Cell();
            }
        }
        this.mapper = new AutomatonActionMapper();
        this.allowResize = true;
    }

    public void draw(Graphics2D graphics2D) {
        Color color = graphics2D.getColor();
        Color color2 = graphics2D.getBackground();
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, AbstractShape.ANTI_ALIASING ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        int n = this._w / this.cells[0].length;
        int n2 = this._h / this.cells.length;
        Rectangle rectangle = graphics2D.getClipBounds();
        Font font = graphics2D.getFont();
        for (int i = 0; i < this.cells.length; ++i) {
            for (int j = 0; j < this.cells[i].length; ++j) {
                Cell cell = this.cells[i][j];
                if (cell == null) continue;
                int n3 = this._ox + j * n;
                int n4 = this._oy - this._h + i * n2;
                if (cell.backgroundColor != null) {
                    graphics2D.setColor(cell.backgroundColor);
                    graphics2D.fillRect(n3, n4, n, n2);
                }
                if (cell.textColor != null && cell.text != null && !cell.text.equals("")) {
                    graphics2D.setColor(cell.textColor);
                    graphics2D.setClip(n3, n4, n, n2);
                    Font font2 = TextShape.getFontToFitText(cell.text, n, n2);
                    if (font2 != null) {
                        graphics2D.setFont(font2);
                        graphics2D.drawString(cell.text, n3 + 5, n4 + n2 - 5 - graphics2D.getFontMetrics(font2).getDescent());
                    }
                    graphics2D.setClip(rectangle);
                }
                if (cell.frameColor == null) continue;
                graphics2D.setColor(cell.frameColor);
                graphics2D.drawRect(n3, n4, n - 1, n2 - 1);
            }
        }
        graphics2D.setFont(font);
        graphics2D.setClip(rectangle);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        graphics2D.setBackground(color2);
        graphics2D.setColor(color);
    }

    public String[] getActions(double d, double d2, Object object, int n) {
        if (n == 3) {
            return null;
        }
        if (n == 4) {
            return null;
        }
        if (n == 5) {
            return null;
        }
        if (n == 1) {
            // empty if block
        }
        Vector<String> vector = new Vector<String>();
        vector.add(resources.getString("properties"));
        return vector.toArray(new String[vector.size()]);
    }

    public boolean doAction(double d, double d2, Object object, String string) {
        if (string.equals(resources.getString("properties"))) {
            new LongAction(16L, null, this){

                protected void doAction() {
                    PropertiesPanel propertiesPanel = AutomatonShape.this.createPanel();
                    int n = JOptionPane.showConfirmDialog(null, propertiesPanel, resources.getString("propertiesTitle"), 2, -1);
                    if (n == 0) {
                        Rectangle rectangle = AutomatonShape.this.getBounds();
                        propertiesPanel.updateProperties();
                        rectangle.add(AutomatonShape.this.getBounds());
                        AutomatonShape.this.notifyChange(rectangle);
                    }
                }
            }.start();
            return true;
        }
        return false;
    }

    public boolean canDoAction(double d, double d2, Object object, String string, int n) {
        return true;
    }

    public PropertiesPanel createPanel() {
        return new PropertiesPanel();
    }

    public void applyRules() {
        AutomatonActionList automatonActionList = (AutomatonActionList)this.mapper.getMapping(this.source, this.index);
        if (automatonActionList == null) {
            return;
        }
        Iterator iterator = automatonActionList.iterator();
        while (iterator.hasNext()) {
            AutomatonAction automatonAction = (AutomatonAction)iterator.next();
            block1 : switch (automatonAction.action) {
                case 0: {
                    int n;
                    Object[] objectArray;
                    --this.activeY;
                    if (this.activeY >= 0) break;
                    if (AutomatonAction.OPTION_WRAP.equals(automatonAction.option)) {
                        this.activeY = this.cells.length - 1;
                        break;
                    }
                    if (AutomatonAction.OPTION_EXTEND.equals(automatonAction.option)) {
                        this.activeY = 0;
                        objectArray = new Cell[this.cells.length + 1][this.cells[0].length];
                        for (n = 0; n < this.cells[0].length; ++n) {
                            objectArray[0][n] = new Cell();
                        }
                        for (n = 0; n < this.cells.length; ++n) {
                            objectArray[n + 1] = this.cells[n];
                        }
                        this.cells = objectArray;
                        if (this._h < this.cells.length * MIN_CELL_HEIGHT) {
                            this._h = this.cells.length * MIN_CELL_HEIGHT;
                        }
                        this._h = (int)(Math.ceil((double)this._h / (double)this.cells.length) * (double)this.cells.length);
                        if (!this.fixedRatio) break;
                        this._w = (int)(Math.ceil((double)this._h * this.ratio / (double)this.cells[0].length) * (double)this.cells[0].length);
                        break;
                    }
                    this.activeY = 0;
                    break;
                }
                case 1: {
                    int n;
                    Object[] objectArray;
                    ++this.activeX;
                    if (this.activeX < this.cells[0].length) break;
                    if (AutomatonAction.OPTION_WRAP.equals(automatonAction.option)) {
                        this.activeX = 0;
                        break;
                    }
                    if (AutomatonAction.OPTION_EXTEND.equals(automatonAction.option)) {
                        this.activeX = this.cells[0].length;
                        objectArray = new Cell[this.cells.length][this.cells[0].length + 1];
                        for (n = 0; n < this.cells.length; ++n) {
                            System.arraycopy(this.cells[n], 0, objectArray[n], 0, this.cells[0].length);
                            objectArray[n][this.cells[0].length] = new Cell();
                        }
                        this.cells = objectArray;
                        if (this._w < this.cells[0].length * MIN_CELL_WIDTH) {
                            this._w = this.cells[0].length * MIN_CELL_WIDTH;
                        }
                        this._w = (int)(Math.ceil((double)this._w / (double)this.cells[0].length) * (double)this.cells[0].length);
                        if (!this.fixedRatio) break;
                        this._h = (int)(Math.ceil((double)this._w / this.ratio / (double)this.cells.length) * (double)this.cells.length);
                        break;
                    }
                    this.activeX = this.cells[0].length - 1;
                    break;
                }
                case 2: {
                    int n;
                    Object[] objectArray;
                    ++this.activeY;
                    if (this.activeY < this.cells.length) break;
                    if (AutomatonAction.OPTION_WRAP.equals(automatonAction.option)) {
                        this.activeY = 0;
                        break;
                    }
                    if (AutomatonAction.OPTION_EXTEND.equals(automatonAction.option)) {
                        this.activeY = this.cells.length;
                        objectArray = new Cell[this.cells.length + 1][this.cells[0].length];
                        for (n = 0; n < this.cells[0].length; ++n) {
                            objectArray[this.cells.length][n] = new Cell();
                        }
                        for (n = 0; n < this.cells.length; ++n) {
                            objectArray[n] = this.cells[n];
                        }
                        this.cells = objectArray;
                        if (this._h < this.cells.length * MIN_CELL_HEIGHT) {
                            this._h = this.cells.length * MIN_CELL_HEIGHT;
                        }
                        this._h = (int)(Math.ceil((double)this._h / (double)this.cells.length) * (double)this.cells.length);
                        if (!this.fixedRatio) break;
                        this._w = (int)(Math.ceil((double)this._h * this.ratio / (double)this.cells[0].length) * (double)this.cells[0].length);
                        break;
                    }
                    this.activeY = this.cells.length - 1;
                    break;
                }
                case 3: {
                    int n;
                    Object[] objectArray;
                    --this.activeX;
                    if (this.activeX >= 0) break;
                    if (AutomatonAction.OPTION_WRAP.equals(automatonAction.option)) {
                        this.activeX = this.cells[0].length - 1;
                        break;
                    }
                    if (AutomatonAction.OPTION_EXTEND.equals(automatonAction.option)) {
                        this.activeX = 0;
                        objectArray = new Cell[this.cells.length][this.cells[0].length + 1];
                        for (n = 0; n < this.cells.length; ++n) {
                            objectArray[n][0] = new Cell();
                            System.arraycopy(this.cells[n], 0, objectArray[n], 1, this.cells[0].length);
                        }
                        this.cells = objectArray;
                        if (this._w < this.cells[0].length * MIN_CELL_WIDTH) {
                            this._w = this.cells[0].length * MIN_CELL_WIDTH;
                        }
                        this._w = (int)(Math.ceil((double)this._w / (double)this.cells[0].length) * (double)this.cells[0].length);
                        if (!this.fixedRatio) break;
                        this._h = (int)(Math.ceil((double)this._w / this.ratio / (double)this.cells.length) * (double)this.cells.length);
                        break;
                    }
                    this.activeX = 0;
                    break;
                }
                case 4: {
                    if (automatonAction.option == null || !(automatonAction.option instanceof Color)) break;
                    this.cells[this.activeY][this.activeX].backgroundColor = (Color)automatonAction.option;
                    break;
                }
                case 5: {
                    if (automatonAction.option == null || !(automatonAction.option instanceof Color)) break;
                    this.cells[this.activeY][this.activeX].frameColor = (Color)automatonAction.option;
                    break;
                }
                case 6: {
                    if (automatonAction.option == null || !(automatonAction.option instanceof Color)) break;
                    this.cells[this.activeY][this.activeX].textColor = (Color)automatonAction.option;
                    break;
                }
                case 7: {
                    Object object;
                    if (automatonAction.option == null || !(automatonAction.option instanceof Object[])) break;
                    Object[] objectArray = (Object[])automatonAction.option;
                    int n = (Integer)objectArray[0];
                    if (n == 6) {
                        this.cells[this.activeY][this.activeX].text = objectArray[1] == null ? null : objectArray[1].toString();
                        break;
                    }
                    try {
                        object = this.source.getValue(this.index);
                    }
                    catch (DataException dataException) {
                        this.cells[this.activeY][this.activeX].text = null;
                        break;
                    }
                    if (!(object instanceof Number)) {
                        this.cells[this.activeY][this.activeX].text = object.toString();
                        break;
                    }
                    Number number = (Number)object;
                    switch (n) {
                        case 1: 
                        case 2: {
                            this.cells[this.activeY][this.activeX].text = ((NumberFormat)objectArray[1]).format(number);
                            break block1;
                        }
                        case 3: {
                            this.cells[this.activeY][this.activeX].text = "0x" + Long.toHexString(number.longValue()).toUpperCase();
                            break block1;
                        }
                        case 4: {
                            this.cells[this.activeY][this.activeX].text = "0" + Long.toOctalString(number.longValue());
                            break block1;
                        }
                        case 5: {
                            this.cells[this.activeY][this.activeX].text = Long.toBinaryString(number.longValue());
                            break block1;
                        }
                    }
                    this.cells[this.activeY][this.activeX].text = object.toString();
                }
            }
        }
        this.notifyChange();
    }

    public void DataSourceIndexRangeChanged(DataSource dataSource, long l, long l2) {
        if (!dataSource.equals(this.source)) {
            return;
        }
        this.index = l2;
        this.dirtyState = true;
    }

    public void DataSourceInfoChanged(DataSource dataSource, DataInfo dataInfo) {
    }

    public void DataSourceOrderChanged(DataSource dataSource, int n) {
    }

    public void DataSourceValueChanged(DataSource dataSource, long l, long l2) {
        if (!dataSource.equals(this.source)) {
            return;
        }
        if (this.index < l || this.index > l2) {
            return;
        }
        this.dirtyState = true;
    }

    public void DataSourceValueRangeChanged(DataSource dataSource) {
    }

    public void notificationEnd(Object object) {
        if (this.dirtyState) {
            this.applyRules();
        }
        this.dirtyState = false;
    }

    public void resize(int n, int n2) {
        if (!this.allowResize) {
            return;
        }
        this._w += n;
        this._h += n2;
        if (this.fixedRatio) {
            double d = Math.max((double)this._w, (double)this._h * this.ratio);
            this._w = (int)d;
            this._h = (int)(d / this.ratio);
        }
        int n3 = this.cells[0].length;
        int n4 = this.cells.length;
        if (this._w < n3 * MIN_CELL_WIDTH) {
            this._w = n3 * MIN_CELL_WIDTH;
        }
        if (this._h < n4 * MIN_CELL_HEIGHT) {
            this._h = n4 * MIN_CELL_HEIGHT;
        }
        this._w = n >= 0 ? (int)(Math.ceil((double)this._w / (double)n3) * (double)n3) : (int)(Math.floor((double)this._w / (double)n3) * (double)n3);
        this._h = n2 >= 0 ? (int)(Math.ceil((double)this._h / (double)n4) * (double)n4) : (int)(Math.floor((double)this._h / (double)n4) * (double)n4);
        if (!this.fixedRatio) {
            this.ratio = (double)this._w / (double)this._h;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        DataSourcePool.global.writeDataSource(objectOutputStream, this.source);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.source = DataSourcePool.global.readDataSource(objectInputStream);
        if (this.source != null) {
            try {
                this.source.addListener(this);
                this.source.addEndNotificationListener(this);
                this.index = this.source.getLastIndex();
            }
            catch (UnsupportedOperation unsupportedOperation) {
                this.index = 0L;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class PropertiesPanel
    extends JPanel {
        protected JButton bdrawcolor;
        protected Color noColor;
        protected JCheckBox cbResize;
        protected JCheckBox cbRatio;
        protected JCheckBox cbdraw;
        protected JLabel lwidth;
        protected JLabel lheight;
        protected NumberField nfWidth;
        protected NumberField nfHeight;
        protected transient DataSource sourceCopy;
        protected SourceTree dstree;
        protected AutomatonActionMapper mapperCopy;
        private NumberField nfActiveX;
        private NumberField nfActiveY;
        private NumberField nfNumCellX;
        private NumberField nfNumCellY;

        public PropertiesPanel() {
            this.sourceCopy = AutomatonShape.this.source;
            try {
                this.mapperCopy = (AutomatonActionMapper)AutomatonShape.this.mapper.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                this.mapperCopy = AutomatonShape.this.mapper;
            }
            Box box = Box.createVerticalBox();
            Box box2 = Box.createHorizontalBox();
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(BorderFactory.createTitledBorder(resources.getString("GridArrayParameters")));
            JPanel jPanel2 = new JPanel(new GridLayout(2, 2));
            jPanel2.add(new JLabel(resources.getString("NumberOfColumns")));
            this.nfNumCellX = new NumberField(AutomatonShape.this.cells[0].length, 5);
            jPanel2.add(this.nfNumCellX);
            jPanel2.add(new JLabel(resources.getString("ActiveColumn")));
            this.nfActiveX = new NumberField(AutomatonShape.this.activeX, 5);
            jPanel2.add(this.nfActiveX);
            jPanel.add((Component)jPanel2, "West");
            JPanel jPanel3 = new JPanel(new GridLayout(2, 2));
            jPanel3.add(new JLabel(resources.getString("NumberOfRows")));
            this.nfNumCellY = new NumberField(AutomatonShape.this.cells.length, 5);
            jPanel3.add(this.nfNumCellY);
            jPanel3.add(new JLabel(resources.getString("ActiveRow")));
            this.nfActiveY = new NumberField(AutomatonShape.this.activeY, 5);
            jPanel3.add(this.nfActiveY);
            jPanel.add((Component)jPanel3, "East");
            box2.add(jPanel);
            JPanel jPanel4 = new JPanel(new BorderLayout());
            jPanel4.setBorder(BorderFactory.createTitledBorder(resources.getString("Dimensions")));
            Box box3 = Box.createHorizontalBox();
            this.cbResize = new JCheckBox(resources.getString("AllowResize"), AutomatonShape.this.allowResize);
            box3.add(this.cbResize);
            box3.add(Box.createHorizontalGlue());
            this.cbRatio = new JCheckBox(resources.getString("FixedRatio"), AutomatonShape.this.fixedRatio);
            box3.add(this.cbRatio);
            jPanel4.add((Component)box3, "North");
            box3 = Box.createHorizontalBox();
            this.lwidth = new JLabel(resources.getString("Width"));
            box3.add(this.lwidth);
            this.nfWidth = new NumberField((long)AutomatonShape.this._w);
            box3.add(this.nfWidth);
            this.nfWidth.setHorizontalAlignment(4);
            box3.add(Box.createHorizontalGlue());
            this.lheight = new JLabel(resources.getString("Height"));
            box3.add(this.lheight);
            this.nfHeight = new NumberField((long)AutomatonShape.this._h);
            box3.add(this.nfHeight);
            this.nfHeight.setHorizontalAlignment(4);
            jPanel4.add((Component)box3, "South");
            box2.add(jPanel4);
            box.add(box2);
            box3 = Box.createHorizontalBox();
            JPanel jPanel5 = this.mapperCopy.createPanel(null, null);
            jPanel5.setBorder(BorderFactory.createTitledBorder(resources.getString("ActionMapper")));
            box3.add(jPanel5);
            jPanel5 = new JPanel(new BorderLayout());
            this.dstree = new SourceTree(DataSourcePool.global);
            this.dstree.setVisibleRowCount(5);
            JScrollPane jScrollPane = new JScrollPane(this.dstree);
            jPanel5.add(jScrollPane);
            jPanel5.setBorder(BorderFactory.createTitledBorder(resources.getString("DataSource")));
            box3.add(jPanel5);
            this.dstree.setSelectedValue(this.sourceCopy);
            this.dstree.addTreeSelectionListener(new TreeSelectionListener(this){
                private final /* synthetic */ PropertiesPanel this$1;
                {
                    this.this$1 = propertiesPanel;
                }

                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    if (!treeSelectionEvent.isAddedPath()) {
                        return;
                    }
                    Object object = this.this$1.dstree.getSelectedSourceOrCollection();
                    if (object instanceof DataSource) {
                        this.this$1.sourceCopy = (DataSource)object;
                    }
                }
            });
            box.add(box3);
            this.add(box);
        }

        public void updateProperties() {
            int n = (int)this.nfNumCellX.getLongValue();
            int n2 = (int)this.nfNumCellY.getLongValue();
            int n3 = (int)this.nfActiveX.getLongValue();
            int n4 = (int)this.nfActiveY.getLongValue();
            if (n <= 0) {
                n = AutomatonShape.this.cells[0].length;
            }
            if (n2 <= 0) {
                n2 = AutomatonShape.this.cells.length;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            if (n3 >= n) {
                n3 = n - 1;
            }
            if (n4 < 0) {
                n4 = 0;
            }
            if (n4 >= n2) {
                n4 = n2 - 1;
            }
            AutomatonShape.this.activeX = n3;
            AutomatonShape.this.activeY = n4;
            if (n != AutomatonShape.this.cells[0].length || n2 != AutomatonShape.this.cells.length) {
                int n5;
                int n6;
                Cell[][] cellArray = new Cell[n2][n];
                int n7 = Math.min(n, AutomatonShape.this.cells[0].length);
                int n8 = Math.min(n2, AutomatonShape.this.cells.length);
                for (n6 = 0; n6 < n8; ++n6) {
                    System.arraycopy(AutomatonShape.this.cells[n6], 0, cellArray[n6], 0, n7);
                    for (n5 = n7; n5 < n; ++n5) {
                        cellArray[n6][n5] = new Cell();
                    }
                }
                for (n6 = n8; n6 < n2; ++n6) {
                    for (n5 = 0; n5 < n; ++n5) {
                        cellArray[n6][n5] = new Cell();
                    }
                }
                AutomatonShape.this.cells = cellArray;
            }
            AutomatonShape.this.allowResize = this.cbResize.isSelected();
            AutomatonShape.this.fixedRatio = this.cbRatio.isSelected();
            AutomatonShape.this._w = (int)this.nfWidth.getLongValue();
            AutomatonShape.this._h = (int)this.nfHeight.getLongValue();
            if (AutomatonShape.this._w < n * MIN_CELL_WIDTH) {
                AutomatonShape.this._w = n * MIN_CELL_WIDTH;
            }
            if (AutomatonShape.this._h < n2 * MIN_CELL_HEIGHT) {
                AutomatonShape.this._h = n2 * MIN_CELL_HEIGHT;
            }
            AutomatonShape.this._w = (int)(Math.ceil((double)AutomatonShape.this._w / (double)n) * (double)n);
            AutomatonShape.this._h = (int)(Math.ceil((double)AutomatonShape.this._h / (double)n2) * (double)n2);
            AutomatonShape.this.ratio = (double)AutomatonShape.this._w / (double)AutomatonShape.this._h;
            if (AutomatonShape.this.source != null) {
                AutomatonShape.this.source.removeListener(AutomatonShape.this);
                AutomatonShape.this.source.removeEndNotificationListener(AutomatonShape.this);
            }
            AutomatonShape.this.source = this.sourceCopy;
            if (AutomatonShape.this.source != null) {
                try {
                    AutomatonShape.this.index = AutomatonShape.this.source.getLastIndex();
                }
                catch (UnsupportedOperation unsupportedOperation) {
                    AutomatonShape.this.index = 0L;
                }
                AutomatonShape.this.source.addListener(AutomatonShape.this);
                AutomatonShape.this.source.addEndNotificationListener(AutomatonShape.this);
            }
            AutomatonShape.this.mapper = this.mapperCopy;
        }
    }

    public static class Cell
    implements Serializable {
        public Color frameColor = Color.black;
        public Color backgroundColor;
        public Color textColor = Color.black;
        public String text;

        Cell() {
        }
    }
}

