/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.builtin.ui;

import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jsynoptic.builtin.ui.AxePropertiesPanel;
import jsynoptic.builtin.ui.CurvePropertiesPanel;
import simtools.ui.CustomizedLocale;
import simtools.ui.JPropertiesPanel;
import simtools.ui.MenuResourceBundle;

public class PlotPropertiesPanel
extends JPropertiesPanel {
    protected JTextField tftitle;
    protected JCheckBox cblegend;
    protected static MenuResourceBundle resources;
    protected int primaryCurvesSize;
    protected CurvePropertiesPanel curvPrimProp;
    protected int secondaryCurvesSize;
    protected CurvePropertiesPanel curvSecProp;
    protected AxePropertiesPanel[] axeprop;

    public PlotPropertiesPanel(int n, int n2) {
        this.primaryCurvesSize = n;
        this.secondaryCurvesSize = n2;
        this.setLayout(new BoxLayout(this, 1));
        this.createContent();
    }

    protected void createContent() {
        this.axeprop = new AxePropertiesPanel[4];
        this.axeprop[0] = new AxePropertiesPanel(resources, "primX");
        this.add(this.axeprop[0]);
        this.axeprop[1] = new AxePropertiesPanel(resources, "primY");
        this.add(this.axeprop[1]);
        this.curvPrimProp = new CurvePropertiesPanel(resources, "prim");
        this.add(this.curvPrimProp);
        this.axeprop[2] = new AxePropertiesPanel(resources, "secX");
        this.add(this.axeprop[2]);
        this.axeprop[3] = new AxePropertiesPanel(resources, "secY");
        this.add(this.axeprop[3]);
        this.curvSecProp = new CurvePropertiesPanel(resources, "sec");
        this.add(this.curvSecProp);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(new JLabel(resources.getStringValue("titleLabel")));
        this.tftitle = new JTextField(25);
        jPanel.add(this.tftitle);
        this.cblegend = resources.getCheckBox("legend", null);
        jPanel.add(this.cblegend);
        this.add(jPanel);
    }

    public static String[] getPropertyNames(int n, int n2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(AxePropertiesPanel.getPropertyNames("primX")));
        arrayList.addAll(Arrays.asList(AxePropertiesPanel.getPropertyNames("primY")));
        arrayList.addAll(Arrays.asList(AxePropertiesPanel.getPropertyNames("secX")));
        arrayList.addAll(Arrays.asList(AxePropertiesPanel.getPropertyNames("secY")));
        arrayList.addAll(Arrays.asList(CurvePropertiesPanel.getPropertyNames("prim", n)));
        arrayList.addAll(Arrays.asList(CurvePropertiesPanel.getPropertyNames("sec", n2)));
        arrayList.add("PLOT_LEGEND");
        arrayList.add("PLOT_TITLE");
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String[] getPropertyNames() {
        return PlotPropertiesPanel.getPropertyNames(this.primaryCurvesSize, this.secondaryCurvesSize);
    }

    public Object getPropertyValue(String string) {
        Object object = super.getPropertyValue(string);
        for (int i = 0; i < this.axeprop.length; ++i) {
            object = this.axeprop[i].getPropertyValue(string);
            if (object == null) continue;
            return object;
        }
        object = this.curvPrimProp.getPropertyValue(string);
        if (object != null) {
            return object;
        }
        object = this.curvSecProp.getPropertyValue(string);
        if (object != null) {
            return object;
        }
        if (string.equalsIgnoreCase("PLOT_TITLE")) {
            object = this.tftitle.getText().length() > 0 ? this.tftitle.getText() : null;
        } else if (string.equalsIgnoreCase("PLOT_LEGEND")) {
            object = new Boolean(this.cblegend.isSelected());
        }
        return object;
    }

    public void setPropertyValue(String string, Object object) {
        super.setPropertyValue(string, object);
        if (string.equalsIgnoreCase("PLOT_TITLE")) {
            if (object instanceof String) {
                this.tftitle.setText((String)object);
            } else {
                this.tftitle.setText("");
            }
        } else if (string.equalsIgnoreCase("PLOT_LEGEND") && object instanceof Boolean) {
            this.cblegend.setSelected((Boolean)object);
        } else {
            for (int i = 0; i < this.axeprop.length; ++i) {
                this.axeprop[i].setPropertyValue(string, object);
            }
            this.curvPrimProp.setPropertyValue(string, object);
            this.curvSecProp.setPropertyValue(string, object);
        }
    }

    static {
        try {
            resources = (MenuResourceBundle)ResourceBundle.getBundle("jsynoptic.builtin.resources.PlotResources", CustomizedLocale.get());
        }
        catch (Exception exception) {
            System.err.println("Can't load Plot resources");
            System.exit(0);
        }
    }
}

