/*
 * Decompiled with CFR 0.152.
 */
package simtools.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

public class SysExec {
    public static final int MISS_ERROR = 999;
    public static final int WAIT_ERROR = 888;
    public static final int EXEC_ERROR = 777;
    public static final int READ_ERROR = 666;
    public static final int SYNC_ERROR = 555;
    public static final int KILL_ERROR = 444;
    Vector vector = new Vector();
    public boolean finished;
    public int exitValue;
    public OutPrintThread outPrintThread;
    public ErrPrintThread errPrintThread;
    public WaitThread waitThread;
    Process process = null;
    ErrOutWriter writer;

    public SysExec() {
        this.writer = null;
        this.outPrintThread = null;
        this.errPrintThread = null;
        this.waitThread = null;
    }

    public SysExec(ErrOutWriter errOutWriter) {
        this.writer = errOutWriter;
        this.outPrintThread = null;
        this.errPrintThread = null;
        this.waitThread = null;
    }

    public void reset() {
        this.vector.removeAllElements();
    }

    public void add(String string) {
        this.vector.addElement(string);
    }

    public void killAll() {
        if (this.process != null) {
            this.process.destroy();
        }
        this.exitValue = 444;
    }

    public int run() {
        while (this.waitThread != null) {
            try {
                this.waitThread.join();
                continue;
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.err.println("Waiting for the end of previous run ...");
        }
        String[] stringArray = new String[this.vector.size()];
        for (int i = 0; i < this.vector.size(); ++i) {
            stringArray[i] = (String)this.vector.elementAt(i);
        }
        this.exitValue = 999;
        try {
            this.process = Runtime.getRuntime().exec(stringArray);
            InputStream inputStream = this.process.getInputStream();
            InputStream inputStream2 = this.process.getErrorStream();
            this.finished = false;
            this.outPrintThread = new OutPrintThread(this, inputStream);
            this.errPrintThread = new ErrPrintThread(this, inputStream2);
            this.waitThread = new WaitThread(this, this.process);
            this.outPrintThread.start();
            this.errPrintThread.start();
            this.waitThread.start();
            try {
                this.waitThread.join();
            }
            catch (InterruptedException interruptedException) {
                this.exitValue = 555;
                this.errPrintln("SysExec error : " + interruptedException);
            }
        }
        catch (IOException iOException) {
            this.exitValue = 777;
            this.errPrintln("SysExec error : " + iOException);
        }
        this.process = null;
        this.outPrintThread = null;
        this.errPrintThread = null;
        this.waitThread = null;
        return this.exitValue;
    }

    public void outPrintln(String string) {
        if (this.writer != null) {
            this.writer.outPrintln(string);
        } else {
            System.out.println(string);
        }
    }

    public void errPrintln(String string) {
        if (this.writer != null) {
            this.writer.errPrintln(string);
        } else {
            System.err.println(string);
        }
    }

    public void print() {
        Enumeration enumeration = this.vector.elements();
        while (enumeration.hasMoreElements()) {
            System.out.println("--> \"" + (String)enumeration.nextElement() + "\"");
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("SysExec.class");
        SysExec sysExec = new SysExec();
        sysExec.add("sh");
        sysExec.add("-c");
        sysExec.add("ls > ls.txt");
        sysExec.print();
        sysExec.run();
        sysExec.reset();
        sysExec.add("cat");
        sysExec.add("ls.txt");
        sysExec.print();
        sysExec.run();
    }

    class WaitThread
    extends Thread {
        SysExec parent;
        Process process;

        public WaitThread(SysExec sysExec2, Process process) {
            super("WaitThread");
            this.parent = sysExec2;
            this.process = process;
        }

        public void run() {
            try {
                this.parent.exitValue = this.process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                this.parent.exitValue = 888;
                this.parent.errPrintln("SysExec error " + this.getName() + " : " + interruptedException);
            }
            try {
                this.parent.finished = true;
                this.parent.outPrintThread.join();
                this.parent.errPrintThread.join();
            }
            catch (InterruptedException interruptedException) {
                this.parent.exitValue = 555;
                this.parent.errPrintln("SysExec error " + this.getName() + " : " + interruptedException);
            }
            catch (NullPointerException nullPointerException) {
                this.parent.exitValue = 555;
                this.parent.errPrintln("SysExec error " + this.getName() + " : " + nullPointerException);
            }
        }
    }

    abstract class PrintThread
    extends Thread {
        InputStream input;
        SysExec parent;

        protected abstract void println(String var1);

        public PrintThread(String string, SysExec sysExec2, InputStream inputStream) {
            super(string);
            this.parent = sysExec2;
            this.input = inputStream;
        }

        public void run() {
            try {
                StringBuffer stringBuffer = new StringBuffer(200);
                DataInputStream dataInputStream = new DataInputStream(this.input);
                while (!this.parent.finished) {
                    PrintThread.sleep(10L);
                    while (dataInputStream.available() > 0) {
                        int n = dataInputStream.readUnsignedByte();
                        if (n == 13) continue;
                        if (n == 10) {
                            this.println(stringBuffer.toString());
                            PrintThread.yield();
                            stringBuffer = new StringBuffer(200);
                            continue;
                        }
                        stringBuffer.append((char)n);
                    }
                }
                if (stringBuffer.toString().length() > 0) {
                    this.println(stringBuffer.toString());
                }
            }
            catch (IOException iOException) {
                this.parent.exitValue = 666;
                this.parent.errPrintln("SysExec error " + this.getName() + " : " + iOException);
            }
            catch (InterruptedException interruptedException) {
                this.parent.exitValue = 666;
                this.parent.errPrintln("SysExec error " + this.getName() + " : " + interruptedException);
            }
        }
    }

    class ErrPrintThread
    extends PrintThread {
        public ErrPrintThread(SysExec sysExec2, InputStream inputStream) {
            super("ErrPrintThread", sysExec2, inputStream);
        }

        protected void println(String string) {
            this.parent.errPrintln(string);
        }
    }

    class OutPrintThread
    extends PrintThread {
        public OutPrintThread(SysExec sysExec2, InputStream inputStream) {
            super("OutPrintThread", sysExec2, inputStream);
        }

        protected void println(String string) {
            this.parent.outPrintln(string);
        }
    }

    public static interface ErrOutWriter {
        public void outPrintln(String var1);

        public void errPrintln(String var1);
    }
}

