#   Copyright (c) 2009 Axel Wachtler
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   * Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#   * Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#   * Neither the name of the authors nor the names of its contributors
#     may be used to endorse or promote products derived from this software
#     without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
#   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
#   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
#   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
#   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
#   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
#   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
#   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
#   POSSIBILITY OF SUCH DAMAGE.

# $Id: xmpl.mk,v 1.5 2009/05/14 20:26:35 awachtler Exp $

# === main parameters of the project =========================================
PROJECT=%(app)s
BOARD = %(brd)s
URACOLI_INSTALL=..
PART = %(part)s
SOURCES = $(PROJECT).c
INCDIRS = . $(URACOLI_INSTALL)/inc
LIBDIRS = $(URACOLI_INSTALL)/lib
DBGFMT=stabs
# automatically derived parameters
OBJECTS = $(SOURCES:%%.c=%%_$(BOARD).o)
TARGET = $(PROJECT)_$(BOARD)

# === compiler settings ======================================================
CC = avr-gcc
CCFLAGS = -Wall -Wundef -g$(DBGFMT) -Os -mmcu=$(PART)
CCFLAGS += -D$(BOARD) -DBOOT_LOADER_ADDRESS=0xf000 -DF_CPU=%(f_cpu)s
CCFLAGS += -Wa,-adhlns=$(<:%%.c=%%_$(BOARD).lst)
CCFLAGS += $(patsubst %%,-I%%,$(INCDIRS))

# === linker settings ========================================================
LDFLAGS= $(patsubst %%,-L%%,$(LIBDIRS)) -lradio_$(BOARD) -lio_$(BOARD)

# === object code conversion =================================================
OC=avr-objcopy
OCFLAGS=-O ihex

# === build rules ============================================================
$(TARGET).hex: $(TARGET).elf
	$(OC) $(OCFLAGS) $< $@

$(TARGET).elf: $(OBJECTS)
	$(CC) -o $@ $(CCFLAGS) $^ $(LDFLAGS)

%%_$(BOARD).o: %%.c
	$(CC) $(CCFLAGS) -c -o $@ $<

clean:
	-rm $(TARGET).hex $(TARGET).elf $(TARGET).lst $(OBJECTS)
