/* Copyright (c) 2012 - 2013 Samuel Klipphahn
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   * Neither the name of the authors nor the names of its contributors
     may be used to endorse or promote products derived from this software
     without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. */

/* $Id: $ */
/**
 * @file
 * @brief Simple Routing Protocoll.
 * @_addtogroup grplwMesh
 */


/* === includes ============================================================ */
#include "lw_cmd.h"
#include "lw_mesh.h"
#include "lw_route.h"

/* === macros ============================================================== */

/* === types =============================================================== */

/* === globals ============================================================= */
uint8_t ack_ctrl_message;
/* === prototypes ========================================================== */
static bool lwc_data_ind(NWK_DataInd_t *ind);

/* === functions =========================================================== */

void lwc_init()
{
    ack_ctrl_message = 0;
    lw_mesh_open_endpoint(NWK_ENDPOINT_ID_LW_COMMAND, lwc_data_ind);
}

/* lightweight command receives data */
static bool lwc_data_ind(NWK_DataInd_t *ind)
{
    if(ind->size == sizeof(NWK_cmd_ack_t)
            || ind->size == sizeof(NWK_cmd_r_err_t))
    {
        NWK_cmd_ack_t *ack = (NWK_cmd_ack_t *) ind->data;
        NWK_cmd_r_err_t *r_err = (NWK_cmd_r_err_t *) ind->data;
        switch(ack->lw_cmd_id)
        {
        case NWK_CMD_ID_ACK:
            /* inform lightweight about acknowledgment */
            lw_ack_received(ack->lw_cmd_seq, ack->lw_cmd_ctrl_message);
            break;

        case NWK_CMD_ID_ROUTE_ERROR:
            /* inform lightweight route about route error */
            lwr_r_err_received(r_err->lw_cmd_src_addr, r_err->lw_cmd_dst_addr);
            break;
        }
    }
    return false;
}

/* confirmation call back function for sent lightweight command frames */
void lwc_data_confirm(NWK_DataReq_t *req)
{

}

void lwc_set_ack_control(uint8_t control)
{
    ack_ctrl_message = control;
}

void lwc_prep_ack_pl(NWK_FrameFormat_t *rx_frame, NWK_cmd_ack_t *ack_pl)
{
    ack_pl->lw_cmd_id           = NWK_CMD_ID_ACK;
    ack_pl->lw_cmd_seq          = rx_frame->lw_seq;
    ack_pl->lw_cmd_ctrl_message = ack_ctrl_message;
    /* reset ctrl_message */
    ack_ctrl_message = 0;
}

void lwc_prep_r_err_pl(NWK_FrameFormat_t *rx_frame, NWK_cmd_r_err_t *err_pl)
{
    err_pl->lw_cmd_id           = NWK_CMD_ID_ROUTE_ERROR;
    err_pl->lw_cmd_src_addr     = rx_frame->lw_srcAddr;
    err_pl->lw_cmd_dst_addr     = rx_frame->lw_dstAddr;
}

