/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.eld.doc.api.dom;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import org.x4o.xml.eld.doc.api.dom.ApiDocConcept;
import org.x4o.xml.eld.doc.api.dom.ApiDocNode;
import org.x4o.xml.eld.doc.api.dom.ApiDocNodeWriter;
import org.x4o.xml.eld.doc.api.dom.ApiDocPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiDoc {
    private String name = null;
    private String description = null;
    private ApiDocNode rootNode = null;
    private ApiDocNode rootNodeTreePage = null;
    private List<ApiDocNodeWriter> nodeBodyWriters = new ArrayList<ApiDocNodeWriter>(20);
    private List<ApiDocConcept> concepts = new ArrayList<ApiDocConcept>(10);
    private String docCopyright = null;
    private String docAbout = null;
    private List<String> docKeywords = new ArrayList<String>(5);
    private List<ApiDocPage> docPages = new ArrayList<ApiDocPage>(5);
    private Class<?> frameNavConceptClass = null;
    private Boolean frameNavOverviewPrintParent = null;
    private Boolean frameNavPrintParentId = null;
    private Boolean frameNavPrintParent = null;
    private Boolean frameNavPrintParentParent = null;
    private List<Class<?>> treeNodeClassExcludes = new ArrayList(5);

    public void checkModel() throws NullPointerException, IllegalArgumentException {
        this.checkNull(this.name, "name");
        this.checkNull(this.description, "description");
        this.checkNull(this.docAbout, "docAbout");
        this.checkNull(this.docCopyright, "docCopyright");
        this.checkNull(this.rootNode, "rootNode");
        this.checkNull(this.frameNavConceptClass, "frameNavConceptClass");
        if (this.concepts.isEmpty()) {
            throw new IllegalStateException("Can't work with empty concepts");
        }
        if (this.nodeBodyWriters.isEmpty()) {
            throw new IllegalStateException("Can't work with empty nodeBodyWriters");
        }
        if (this.frameNavOverviewPrintParent == null) {
            this.setFrameNavOverviewPrintParent(false);
        }
        if (this.frameNavPrintParent == null) {
            this.setFrameNavPrintParent(false);
        }
        if (this.frameNavPrintParentParent == null) {
            this.setFrameNavPrintParentParent(false);
        }
        if (this.frameNavPrintParentId == null) {
            this.setFrameNavPrintParentId(false);
        }
    }

    private void checkNull(Object obj, String objName) {
        if (obj == null) {
            throw new NullPointerException("Can't work with null " + objName);
        }
    }

    public ApiDocNodeWriter addNodeBodyWriter(ApiDocNodeWriter writer) {
        this.nodeBodyWriters.add(writer);
        return writer;
    }

    public boolean removeNodeBodyWriter(ApiDocNodeWriter writer) {
        return this.nodeBodyWriters.remove(writer);
    }

    public List<ApiDocNodeWriter> getNodeBodyWriters() {
        return this.nodeBodyWriters;
    }

    public ApiDocConcept addConcept(ApiDocConcept concept) {
        this.concepts.add(concept);
        return concept;
    }

    public boolean removeConcept(ApiDocConcept concept) {
        return this.concepts.remove(concept);
    }

    public List<ApiDocConcept> getConcepts() {
        return this.concepts;
    }

    public void addDocKeyword(String keyword) {
        this.docKeywords.add(keyword);
    }

    public void addDocKeywordAll(Collection<String> keywords) {
        this.docKeywords.addAll(keywords);
    }

    public boolean removeDocKeyword(String keyword) {
        return this.docKeywords.remove(keyword);
    }

    public List<String> getDocKeywords() {
        return this.docKeywords;
    }

    public String getDocCopyright() {
        return this.docCopyright;
    }

    public void setDocCopyright(String docCopyright) {
        this.docCopyright = docCopyright;
    }

    public void createDocCopyright(String owner) {
        Calendar calendar = Calendar.getInstance();
        StringBuffer buf = new StringBuffer(100);
        buf.append("Copyright&nbsp;&#x00a9;&nbsp;");
        buf.append(calendar.get(1));
        buf.append("&nbsp;");
        buf.append(owner.toUpperCase());
        buf.append("&nbsp;");
        buf.append("All Rights Reserved.");
        this.setDocCopyright(buf.toString());
    }

    public String getDocAbout() {
        return this.docAbout;
    }

    public void setDocAbout(String docAbout) {
        this.docAbout = docAbout;
    }

    public ApiDocPage addDocPage(ApiDocPage page) {
        this.docPages.add(page);
        return page;
    }

    public boolean removeDocPage(ApiDocPage page) {
        return this.docPages.remove(page);
    }

    public List<ApiDocPage> getDocPages() {
        return this.docPages;
    }

    public ApiDocPage findDocPageById(String docPageId) {
        if (docPageId == null) {
            throw new NullPointerException("Can't search for null id.");
        }
        for (ApiDocPage page : this.docPages) {
            if (!page.getId().equals(docPageId)) continue;
            return page;
        }
        return null;
    }

    public Class<?> addTreeNodeClassExclude(Class<?> excludeClass) {
        this.treeNodeClassExcludes.add(excludeClass);
        return excludeClass;
    }

    public boolean removeTreeNodeClassExclude(Class<?> excludeClass) {
        return this.treeNodeClassExcludes.remove(excludeClass);
    }

    public List<Class<?>> getTreeNodeClassExcludes() {
        return this.treeNodeClassExcludes;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ApiDocNode getRootNodeTreePage() {
        return this.rootNodeTreePage;
    }

    public void setRootNodeTreePage(ApiDocNode rootNodeTreePage) {
        this.rootNodeTreePage = rootNodeTreePage;
    }

    public ApiDocNode getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(ApiDocNode rootNode) {
        this.rootNode = rootNode;
    }

    public Class<?> getFrameNavConceptClass() {
        return this.frameNavConceptClass;
    }

    public void setFrameNavConceptClass(Class<?> frameNavConceptClass) {
        this.frameNavConceptClass = frameNavConceptClass;
    }

    public Boolean getFrameNavPrintParent() {
        return this.frameNavPrintParent;
    }

    public void setFrameNavPrintParent(Boolean frameNavPrintParent) {
        this.frameNavPrintParent = frameNavPrintParent;
    }

    public Boolean getFrameNavPrintParentParent() {
        return this.frameNavPrintParentParent;
    }

    public void setFrameNavPrintParentParent(Boolean frameNavPrintParentParent) {
        this.frameNavPrintParentParent = frameNavPrintParentParent;
    }

    public Boolean getFrameNavOverviewPrintParent() {
        return this.frameNavOverviewPrintParent;
    }

    public void setFrameNavOverviewPrintParent(Boolean frameNavOverviewPrintParent) {
        this.frameNavOverviewPrintParent = frameNavOverviewPrintParent;
    }

    public Boolean getFrameNavPrintParentId() {
        return this.frameNavPrintParentId;
    }

    public void setFrameNavPrintParentId(Boolean frameNavPrintParentId) {
        this.frameNavPrintParentId = frameNavPrintParentId;
    }
}

