Usage
=====

ZitherLayout is a small tool to layout songs to get Zither-style note sheets, to be put underneeth the strings.
Therefore the program reads inputs and notes from simple text files and create a LaTeX file.
This file can be compiled with LaTeX, where MusixTex is needed.


The tool is called like this:
  ZitherLayout [-s <input file>]* [-i <input file>]* [-o <output file>] [-S <setting>]* [-v/-q] [-l [<mode>]] [-p/-c]
(* means any number of such parameter)
the parameters have the following meaning:
  -s <file> | --settings-file <file>
      specify settings file (read as normal input file, see input file format);
  -i <file> | --input-file <file>
      specify input file (same as settings file)
      if no input file is given (but maybe one or more settings files), stdin is read in addition
  -o <file> | --output-file <file>
      specify output file
      if no output file is given, use stdout
  -S <setting> |  --set <setting>
      specify input command (see 'Commands and their input format')
      commands given on command line overwrite input file commands, so they are useable for 'latest changes' or temporary settings (like 'g=1')
  -v | --verbose
      run in verbose mode
      additional information is given
  -q | --quiet
      run in quiet mode
      only errors and warnings are printed to stderr, no other output (except output file, see -o)
      if neither -v nor -q is given, the program runs in 'normal' mode giving some process information (and of course errors and warnings)
  -l [<mode>] | --lyrics [<mode>]
      export lyrics only
      <mode> specifies the output format:
        1 : normal mode (default)
        2 : output as LaTeX commands
        3 : output as LaTeX commands for alternative lyrics
  -p | --part
      export part document only, parts can be combined later using the -c (--combine) option
  -c | --combine
      combine multiple part documents (given by -i options) into one export document

Input and settings files are read in the order given at the command line. Each input file overwrites settings made from the files before, but adds! notes.
If there is a file '~/.PiperSoft/ZitherLayout/default-settings', this file will be read before any of the given input and settings files.

By such a call, the file <file>.tex will be created (if specified by -o=<file>.tex).
To create a PDF file you can call the following commands afterwards:
  latex <file>
  dvipdfmx <file>
where <file> is the name of the output file (see Option -o) without extension.


Input file format
=================

Each input file may contain notes and field values, where field values are song information like lyrics or the title, and settings like lyrics positions, string distance and many more.
Each line can consisti of one or more items seperated by white space (space, tabulator). An exception are lines starting with '@' (see below), where white space characters are part of the value (which is important for lyrics, for example).
Each line starting with ';' is ignored, so represents comments, or just something you don't want to delete, but you also don't want to be printed right now.
Each line starting with '\' or '@' contains field values, so settings or song information. If the line starts with '\', field values end at the next white space, if the line starts with '@', the field value ends at the end of the line.
All other lines contain notes.
Each input line can contain ';', the rest of the line is than ignored. An exception is a line starting with '@' again, where the ';' and the following text will be part of the field value.
A special field 'end' marks the end of the input file, and can be used on stdin for example.

In the following format descriptions <xxx> represents a value, [xx] an optional parameter and x/y possible values of the field.


Note input format
-----------------
Each note item contains of note value, pitch and optionally an chord and has the following format:
  note item := [<length>][.][+/-]<pitch-name>[<octave>][(C/A)<chord>[./_]]*
where the fields have following meanings:
  [<length>]    : base length of note value, one of 1 (whole note), 2 (half note), 4 (quarter), 8, ...
                  set to default length, if omitted *)
  [.]           : if present, produces a dotted note
  [+/-]         : rise / lower the given pitch by semitone
  <pitch-name>  : name of pitch (a-h)
                  ! using GERMAN notation, so 'h' will produce english 'b', 'b' is the same as '-h' or english '-b' !
  [<octave>]    : octave (1-x)
                  set to default octave, if omitted *)
  C/A           : marks the presence of an chord (ger: Akkord)
  <chord>       : chord number
  [./_]         : specifies the chord type (produces dotted or underlined chord number)
                * multiple chords may be specified

*) Default length is 4 (quarter note), default octave is 1, but these values may be changed by specific commands, see 'dl' / 'do'.
Which pitches (octaves) can be used depends on the lowest and highest pitch, which is c1 to c3 for default, but can be changed by specific commands, see 'lp' / 'hp'.

Example:
4g1           creates quarter note at first g pitch
2.e2A2        creates dotted half note at second e pitch with chord 2
32-h1A3_      creates 1/32 note at first b (=bh, = #a) pitch with underlined chord 3
c d e f g     creates the beginning of the c scale with default note values in the default octave
2.e1A1A1.A1.  creates dotted half note at pitch e1 with 3 chords to be played



Field values and their input formats
------------------------------------
To specify field values (song information or settings), the input line has to start with '\' or '@', see above. Each entry has to be given in the following format:
  <field-name>[op]=<value>
The fields have the following meanings:
  <name>   : name of field to set, see below
             if and unknown field name is specified, a warning is given, and the program ignores the entry.
  [op]     : optional operator
             the following operators are supported:
               +  given value will be added to the current field value (strings will be concatenated)
               -  given value will be subtracted from the current field value (integer values only)
  <value>  : value to set to field
             using the @<name2> notation, it is possible to reference the value of any field
             (referencing by \<name2> does not work, since LaTeX commands are used often, which also start with \)

example:
@l1=this is the first lyrics   defines the lyrics for the first strophe
\lp1=1,1                       defines the position of the first strophe
\ l2=\l1 l2+=again             sets the second strophe to the text of the first strophe, which is later extended
\lp2=lp1 lp2+=0,2              defines the position of the second strophe's lyrics exactly 2 rows below the first


The following fields can be used:
- - - - - - - - - - - - - - - - -
special fields:
  end
      marks the end of the input file (usefull for breaking read on stdin)
  in | input-file
      read given file as additional input file
      <value> is relative file name (to location of current input file)
fields for the page layout *):
  pb | page-borders
      change page border (default is 5mm at each side)
      <value> is the border width in 1/10mm
      changes all borders (top, bottom, left and right)
  pb(t|b|l|r) | page-border-(top|bottom|left|right)
      only changes top / bottom / left / right border
  nb(l|r) | note-border-(left|right>
      change note border width (left default depends on string distance, right defaults to 20mm)
      <value> is border width in 1/10mm
fields for the Zither layout *):
  sc | string-count
      change string count (default is c1 to c3)
      <value> is the number of melody strings (numeric)
  sd | string-distance
      change string distance (default is 8.8mm for 3 1/2 Zither)
      <value> is string distance in 1/10mm
  cc | chord-count
      change number of chords (chord count, 6 is default)
      <value> is the number of chords (numeric)
  cd | chord-distance
      change chord distance
      <value> is the distance in 1/10mm
  cw | chord-width
      change the width of one chord
      <value> is the width in 1/10mm
fields for default values:
  dl | default-length
      specify default note value (length)
      <value> is one of 1,2,4, ... (see above)
  do | default-octave
      specify default octave
      <value> is one of 1,2,...
fields for song information:
  sn | short-name
      short name of the song
  t | title
      song title
  s | sub-title
      subtitle
  a | artist
      artist (music and lyrics)
  c | composer
      composer of the song (music)
  te | texter
      texter of the song (lyrics)
  arr | arrangement
      arrangement
fields for lyrics:
  l<x> | lyrics-<x>
      lyrics for x-th strophe, x is in 1 to 16 (I think more than 16 strophes won't have place on the sheet...)
  lp<x> | lyrics-position-<x>
      set lyrics position for x-th strophe (see 'How to position lyrics')
      <x> is the number of the strophe
      <value> is the position in the format <col>,<row>
        depending on the format (see 'lpf') these are relative or absolute postion values
  lr | lyrics-refrain
      set the lyrics of the refrain
      <value> is the text used as refrain lyrics
  lpr | lyrics-position-refrain
      set the position of the refrain
      <value> is the position in <col>,<row> format
  ln | show-lyric-numbers
      print/omit lyric numbers
      <value> is either 1 (print numbers) or 0 (do not)
  lpf | lyrics-positioning-format
      change the format of lyrics position field values
      <value> is the format, and is one of:
        cr | col-row             position given in column and row, relative to notes' positions
        cra | col-row-absolute   position given in column and row, but independent from the current compression level
        xy                       position given in absolute x-y-coordinates
        <x>f | <x>-fine          with higher accuracy, scaled by 1/10th of the basic unit
  lv<x> | lyrics-visible-<x>
      change visibility of a strophe's lyrics
      <x> is the strophe number
      <value> is either 1/true (show lyrics) or 0/false (don't show)
      as default all lyrics will be printed
  lv | lyrics-visible
      change vilibility of a set of strophes' lyrics
      <value> is a list of strophe number to show / hide
      depending on the optional operator <op> the behaviour changes:
        =    only the given strophes will be printed later
        +=   the given strophes's lyris will be printed, additionally the already marked
        -=   the given strophes will not be printed
  lrx | lyrics-rel-size
      change the relative text size of lyrics
      <value> is the relative size (<0: use smaller font, >0: use larger font)
fields for additional texts:
  h | hint
      hint
  w | warning
      warning (maybe used to say 'you have to change chord tuning before you play this!' f.ex.), will be red in the output
  atpf | additional-text-positioning-format
      format of the positions of additional texts
      <value> is the format, see lpf | lyrics-positioning-format
  at<x> | additional-text-<x>
      additional text including its position
      <value> is the position and the text in the format <col>,<row>,<text>
fields for layout parameters:
  sty | style
      change the output style
      <value> is the style, the following styles are available:
        m | melody   melody-style, print note pages for melody strings
        b | bass     bass-style, print note pages for bass strings
  np | notes-position
      change position of notes (see 'How to position notes')
      <value> is the position:
        t | top      position notes on top of the page
        c            center notes vertically
        b | bottom   position on the bottom
  (l|h|f)c | (lowest|highest|fix)-compression
      change minimum, maximum or fixed compression (see 'How to position notes')
      <value> is the compression level (numeric)
      fc sets minimum and maximum compression to the same value
the following commands control the debug grid and a cut edge marker:
  g | print-grid
      print/omit grid
      <value> is either 1/true (print grid) or 0/false (do not)
      you can use the grid to find the best lyric positions (see 'How to position lyrics')
  gf | grid-format
      change format of the grid
      <value> is the format, see 'lpf'
        in col/row format column and row numbers are printed
        in x/y format absolute coordinates are printed
  cew | cut-edge-width
      set width of cut edge
      <value> is width in 1/10mm (from pictures right edge, see green frame of debug grid)
  ceh | cut-edge-height
      set height of cut edge
      <value> is heigth in 1/10mm (from pictures top edge, see green frame of debug grid)
  ce | print-cut-edge
      print/omit cut edge
      <value> is either 1/true (print cut edge) or 0/false (do not)
      the cut edge is automatically printed with the grid
  csw | cut-side-width
      set width of right border to be cut
      <value> is the width of that border in 1/10mm
  cs | print-cut-side
      print or ommit cut side
      <value> is 1/true (print) or 0/false (don't print)

*) Hint: The commands for page layout change can be put into a page-layout specific settings file (like page-layout-A4ls.conf), the commands for zither layout can be put into a zither specific file (like zither-layout-3,5.conf).
This way you can easily swap between one or more page layouts and zither layouts by specifying these files on the command line, see 'Usage'.



How to position notes
---------------------
When you create a note sheet to be put under your zither's strings, you have to keep in mind you may have to cut the upper right edge of the sheet.
For this purpose, there is a cut edge marking line printed with the debug grid. You can use this line to look for notes positioned in the area that will be cut. If there are such notes, you should tell ZitherLayout to position them outside of the cut area.
This can be done by using a higher compression (see commands 'lc' or 'fc') and aligning the notes at the bottom of the page (see 'np=b' command). This way you will get some free space on top of the page. You should just play around with the parameters for 'lc' or 'fc' to find the best compression rate.



How to position lyrics
----------------------
If you want to include lyrics into your note sheet, you have to specify the lyrics itself and their positions.
To get possible positions, just create the sheet without lyrics, print the grid (see command g=1) and look for free space on the sheet.
Then specify the lyrics positions in your input file (using commands lp<x>=<pos>) and remove the grid (omit g=1 command or use g=0).
So you need at least two steps, but feel free to use even more iterations to find the best positions...
The input format of lyrics positions and positions of additional texts can be changed using the 'lpf' and 'atpf' fields. This way it is possible to use either relative positions (relative to the prited notes), or absolute positions in form of x-y-coordinates. The 'fine' mode allows specifing positions in 1/10th of the accordant basic units.

