# Copyright (C) 2022 The Qt Company Ltd.
# SPDX-License-Identifier: LicenseRef-Qt-Commercial

'''Test cases for __hash__'''

import os
import sys
import unittest

from pathlib import Path
sys.path.append(os.fspath(Path(__file__).resolve().parents[1]))
from init_paths import init_test_paths
init_test_paths(False)

from PySide6.QtWidgets import QTreeWidgetItem
from helper.usesqapplication import UsesQApplication


class HashableTest(UsesQApplication):

    def testQTreeWidgetItemHash(self):
        h = {}
        obj = QTreeWidgetItem()
        h[obj] = 2
        self.assertTrue(h.get(obj), 2)


if __name__ == '__main__':
    unittest.main()

