<!--
AAMfP: a simple personal kanban metrics spreadsheet

Copyright (C)  2019  Marco Bresciani.

Copying and distribution of this file, with or without modification,
are permitted in any medium without royalty provided the copyright
notice and this notice are preserved.  This file is offered as-is,
without any warranty.
-->
> 2019-08-20 **Atlassian has decided to remove Mercurial SCM support from
BitBucket (see https://bitbucket.org/blog/sunsetting-mercurial-support-in-bitbucket).
While I fully understand that now Git is the de facto standard,
I feel Git is way too complex for a simple project like this.
Something good for Linux kernel, does not mean that might be good for
everyone. For this reason, this project will be moved to another place,
as soon as possible. Please stay tuned for the new location!**

# AAMfP: a simple personal kanban metrics spreadsheet #
Copyright (C)  2019  Marco Bresciani.

## Intro ##
Improve your daily workflow with this
[LibreOffice](https://www.libreoffice.org/) Calc spreadsheet using the
concepts of [Personal Kanban](http://personalkanban.com/pk/) and
applying some Kanban flow metrics as described in the book [Actionable
Agile Metrics for
Predictability](https://leanpub.com/actionableagilemetrics) (and
compatible with [Actionable Agile™
Analytics](https://www.actionableagile.com/) tool) by Dan Vacanti.

### Visualize your work ###
The project also contains PDF and ODG (LibreOffice Draw) versions of an
[A3 format](https://en.wikipedia.org/wiki/ISO_216) printable kanban
board with **Backlog**, **Next**, **In-progress** and **Done** columns.
Feel free to use it to visualize your work flow and items!

### Limit your work-in-progress ###
On top of **Next** and **In-progress** columns of the board, there is a
specific **WIP** badge inside which you can write the WIP limit for such
column: remember to write the limit in both columns, to be sure to
properly apply Kanban method concepts and obtain real improvements.

## Download ##
Current version is **v.14.0.0**. See
[Downloads](https://bitbucket.org/marcobresciani/aamfp/downloads/).

For versions history see the
[Changelog](https://bitbucket.org/marcobresciani/aamfp/src/tip/CHANGELOG.md)
file.

## Contacts ##
Feel free to open an
[issue](https://bitbucket.org/marcobresciani/aamfp/issues) for bugs,
enhancements, proposals or tasks. For further questions or requests,
let's keep in touch:
 
 * **[@AAMfP@fosstodon.org](https://fosstodon.org/@AAMfP)** on the
   [Mastodon](https://en.wikipedia.org/wiki/Mastodon_(software)
   federated social network.
 * **aamfp_** user (ring:2e5e3ab18b487d096464ed0a0b2c2af468a8838a) on
   the [GNU Jami](https://jami.net) (former GNU Ring, former SFLphone)
   distributed communication platform.

## How To ##
> Complete, detailed usage instructions and data explanations can be
found in the [Usage](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md)
file.

Briefly: the only sheet you need to work on, is the
[WorkItems](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#WorkItems)
sheet where you need to add, for each work item, the dates when such
work items have changed state. **CoS** (Class of Service) and **WIT**
(Work Item Type) column values are not mandatory.

Please note that
[WorkItems](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#WorkItems)
sheet already contains some data. Those are example data to show you how
to use and write them. Feel free to remove them.

*While bug [#6](https://bitbucket.org/marcobresciani/aamfp/issues/6/)
is open*, when a work item has to be discarded or is aborted, you have
to write such cancellation date in all remaining columns cells and also
write the same date in the **Deleted** column. With this, the work item
will be properly identified as deleted.

> In order to have correct metrics, chart, and data *you* have to keep
the *Workitems* sheet rows in the correct order. Specifically, select
the data in such sheet and and apply the following sorting criteria (all
crescent order): **Done**, **In-progress**, **Next**, **Deadline**,
**Backlog**, **ID**. Once the columns are ordered in this way, you can
scroll all other sheets where you can find the metrics and charts
properly computed and rendered.

**Deadline** column value is optional and the content is automatically
and conditionally formatted. Deadline is:

 * *today*, red cell;
 * *this week*, orange cell;
 * *this month*, yellow cell;
 * *next month*, green cell.
 * *expired completed activity*, red text.

The whole [WorkItems](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#WorkItems)
sheet is compatible with [Actionable Agile™
Analytics](https://www.actionableagile.com/) tool (see [Format for Data
File](https://www.actionableagile.com/format-data-file/)): simply export
[WorkItems](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#WorkItems)
sheet as CSV (select comma (**,**) as cell separator and quotes (**"**)
for fields) and then import it in the tool.

## References ##
For **Kanban** method starts from here:
[What is Kanban | Lean Kanban](https://leankanban.com/project/wkanban/)
and the [Essential Kanban Condensed 
Guide](https://leankanban.com/guide/).

For **Personal Kanban** starts from here: [Map your work, control your
life: Personal Kanban](http://personalkanban.com/pk/)
and [Personal Kanban: The Book | Personal
Kanban](http://personalkanban.com/pk/book/).

For more details and explanations on metrics please see the book
[Actionable Agile Metrics for
Predictability](https://leanpub.com/actionableagilemetrics) by Vacanti,
Daniel S..

See also **[Kanban One](https://www.kanbanone.com)**, an online tool
aiming to cover the features of this spreadsheet (and more).

## Thanks ##
Thanks to (in appearing order):

* [Gavi](https://bitbucket.org/classicPintus/) for having solved bug
[#1](https://bitbucket.org/marcobresciani/aamfp/issues/1/wrong-cfd-counting)
and for creating **[Kanban One](https://www.kanbanone.com)** together
with Francesco.

* [Samuele Accordini](https://it.linkedin.com/in/samueleaccordini) for
citing this spreadsheet in his LinkedIn article (in Italian) [Personal
Kanban: il trainer del
tempo](https://www.linkedin.com/pulse/personal-kanban-il-trainer-del-tempo-samuele-accordini).

* [Rudiger Wolf](https://bitbucket.org/rnwolf/) for having creating his
  [Pandas Agile Metrics](https://github.com/rnwolf/pandas_agile_metrics)
  project "Inspired by https://bitbucket.org/marcobresciani/aamfp/".

----

AAMfP: a simple personal kanban metrics spreadsheet

Copyright (C)  2019  Marco Bresciani.

Copying and distribution of this file, with or without modification,
are permitted in any medium without royalty provided the copyright
notice and this notice are preserved.  This file is offered as-is,
without any warranty.
