# -*- coding: iso-8859-1 -*-

#Copyright  2005 Pol Danilov
###############################################################################
#    This file is part of "SIL".
#
#    A copy of the GNU General Public License should be included with any
#    redistribution of this program in a file named "COPYING".
#
#    "SIL" is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    "SIL" is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with "SIL"; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
###############################################################################

"""config.py
"""
from pygame.locals import *   # for CONTROLLER_LIST
from cPickle import load, dump

class config_base:
    def __init__(self):
        self.KEY_LIST = (
            False,          False,          False,          False,          False,
            False,          False,          False,          'Backspace',    'Tab',
            False,          False,          False,          'Enter',        False,
            False,          False,          False,          False,          ' ',
            False,          False,          False,          False,          False,
            False,          False,          False,          False,          False,
            False,          False,          'Space',        False,          False,
            False,          False,          False,          False,          'Quote',
            False,          False,          False,          False,          'Less Than',
            'Minus',        'Grtr Than',    'Fw Slash',     '0',            '1',
            '2',            '3',            '4',            '5',            '6',
            '7',            '8',            '9',            False,          'Semicolon',
            False,          'Plus',         False,          False,          False,
            False,          False,          False,          False,          False,
            False,          False,          False,          False,          False,
            False,          False,          False,          False,          False,
            False,          False,          False,          False,          False,
            False,          False,          False,          False,          False,
            False,          'Left Brkt',    'Bk Slash',    'Right Brkt',    False,
            False,          'Tilde',        'A',            'B',            'C',
            'D',            'E',            'F',            'G',            'H',
            'I',            'J',            'K',            'L',            'M',
            'N',            'O',            'P',            'Q',            'R',
            'S',            'T',            'U',            'V',            'W',
            'X',            'Y',            'Z',            False,          False,
            False,          False,          'Delete',       False,          False,
            False,          False,          False,          False,          False,
            False,          False,          False,          False,          False,
            False,          False,          False,          False,          False,
            False,          False,          False,          False,          False,
            False,          False,          False,          False,          False,
            False,          False,          False,          False,          False,
            False,          False,          False,          False,          False,
            False,          False,          False,          False,          False,
            False,          False,          False,          False,          False,
            False,          False,          False,          False,          False,
            False,          False,          False,          False,          False,
            False,          False,          False,          False,          False,
            False,          False,          False,          False,          False,
            False,          False,          False,          False,          False,
            False,          False,          False,          False,          False,
            False,          False,          False,          False,          False,
            False,          False,          False,          False,          False,
            False,          False,          False,          False,          False,
            False,          False,          False,          False,          False,
            False,          False,          False,          False,          False,
            False,          False,          False,          False,          False,
            False,          False,          False,          False,          False,
            False,          False,          False,          False,          False,
            False,          False,          False,          False,          False,
            False,          False,          False,          False,          False,
            False,          'Num Insert',   'Num 1',        'Num 2',        'Num 3',
            'Num 4',        'Num 5',        'Num 6',        'Num 7',        'Num 8',
            'Num 9',        'Num Delete',   'Num Slash',    'Num Star',     'Num Minus',
            'Num Plus',     'Num Enter',    False,          'Up',           'Down',
            'Right',        'Left',         'Insert',       'Home',         'End',
            'Page Up',      'Page Down',    'F1',           'F2',           'F3',
            'F4',           'F5',           'F6',           'F7',           'F8',
            'F9',           'F10',          'F11',          'F12',          False,
            False,          False,          False,          False,          False,
            'Num Lock',     'Caps Lock',    'Scroll Lock',  'Right Shift',  'Left Shift',
            'Right Ctrl',   'Left Ctrl',    'Right Alt',    'Left Alt',     False,
            False,          False,          False,          False,          False,
            False,          'Print Screen'
            )
        try: self.load() # try to load config file, otherwise use defaults
        except: self.reset(); print 'first-run'

    def reset(self):
        """Reset to default config"""
        
        self.CONTROLLER_LIST = [
            ['Move Up',             K_KP8,          K_PAUSE],
            ['Move Down',           K_KP2,          K_PAUSE],
            ['Move Left',           K_KP4,          K_PAUSE],
            ['Move Right',          K_KP6,          K_PAUSE],
            ['Aim Up/Left',         K_KP7,          K_PAUSE],
            ['Aim Up/Right',        K_KP9,          K_PAUSE],
            ['Aim Down/Left',       K_KP1,          K_PAUSE],
            ['Aim Down/Right',      K_KP3,          K_PAUSE],
            ['Fire',                K_RCTRL,        K_PAUSE],
            ['Jump',                K_KP8,          K_PAUSE],
            ['Activate/Hack',       K_SPACE,        K_PAUSE],
            ['Use/Buy Inventory',   K_RETURN,       K_PAUSE],
            ['World Info',          K_RALT,         K_PAUSE],
            ['Disguise',            K_KP5,          K_PAUSE],
            ['Look Ahead',          K_SLASH,        K_PAUSE],
            ['Chat',                K_TAB,          K_PAUSE],
            ['Next Weapon',         K_KP0,          K_PAUSE],
            ['Next Invent',         K_RIGHTBRACKET, K_PAUSE],
            ['Jet Pack',            K_RSHIFT,       K_PAUSE],
            ['Camera Next',         K_COMMA,        K_PAUSE],
            ['Camera Previous',     K_PERIOD,       K_PAUSE],
            ['Camera Detonate',     K_m,            K_PAUSE],
            ['Gesture 1',           K_j,            K_PAUSE],
            ['Gesture 2',           K_k,            K_PAUSE],
            ['Gesture 3',           K_l,            K_PAUSE],
            ['Gesture 4',           K_SEMICOLON,    K_PAUSE]
            ]

        self.WEATHER_FX = True
        self.PALETTE_FX = True

        self.save()

    def load(self):
        """Load config file"""
        
        f = file('data/main.cfg', 'r')
        self.Dump = load(f)
        f.close()
        self.CONTROLLER_LIST = self.Dump[0]
        self.WEATHER_FX = self.Dump[1]
        self.PALETTE_FX = self.Dump[2]

    def save(self):
        """Save config file"""

        self.Dump = (self.CONTROLLER_LIST,
                self.WEATHER_FX,
                self.PALETTE_FX)

        f = file('data/main.cfg', 'w')
        dump(self.Dump, f)
        f.close()

config = config_base()
