<?php

/* Appora server
 * Copyright (C) 2011 Appora contributors
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

require_once(dirname(__FILE__)."/../../env.php");
require_once($_DATA_MODULES_DIR."/IDataGetter.php");

/** Data getter that gets data on local file system. */
class FileDataGetter implements IDataGetter {

	private $sBasePath;

	public function __construct($sBasePath) {
		$this->sBasePath = $sBasePath;
	}

	private function getContents($path) {
		// TODO: handle read error nicely
		$data = file_get_contents($this->sBasePath . $path);
		if ($data === FALSE) {
			return NULL;
		}
		return $data;
	}

	public function getApplication($appId, $version) {
		return $this->getContents($appId . "/" . $version . "/application");
	}

	public function getIcon($appId) {
		return $this->getContents($appId . "/icon");
	}
}

?>
