<?php

/* Appora server
 * Copyright (C) 2011 Appora contributors
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/** Utility to check if variables are of expected type and throw an exception
 * if not.
 * All functions takes 3 parameters with 2 optionnals for debugging
 * $var is the variable to check
 * $sVarName is the name to display in debug mode (default is "")
 */
class TypeChecker {

	// TODO: create TypeCheckException
	private function __construct() {}

	private static function throwError($sVarName, $sType) {
		throw new Exception("Illegal variable " . $sVarName
				. " expecting " . $sType . ".");
	}

	public static function checkNotNull($var, $sVarName = "") {
		if ($var == NULL) {
			TypeChecker::throwError($sVarName, "non null");
		}
	}

	public static function checkBoolean($var, $sVarName = "") {
		if (!is_bool($var)) {
			TypeChecker::throwError($sVarName, "boolean");
		}
	}


	public static function checkInt($var, $sVarName = "") {
		if (!is_int($var)) {
			TypeChecker::throwError($sVarName, "int");
		}
	}

	public static function checkString($var, $bNotEmpty = false,
			$sVarName = "") {
		if (!is_string($var)) {
			TypeChecker::throwError($sVarName, "string");
		}
		if ($var == "") {
			TypeChecker::throwError($sVarName, "non empty string");
		}
	}

	public static function checkArray($var, $sVarName = "") {
		if (!is_array($var)) {
			TypeChecker::throwError($sVarName, "array");
		}
	}
}

?>
