<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "blog";

include_once ("config/blg.config.php");
include_once ("inc/blg_initiate.inc.php");


if (isset($_POST['save_blog'])) {
	
	if (empty($_POST['blog_title'])) {
		$GLOBALS['am_error_log'][] = array('title_empty');
	}
	
	if (empty($_POST['blog_synopsis'])) {
		$GLOBALS['am_error_log'][] = array('synopsis_empty');
	}
	
	if (empty($GLOBALS['am_error_log'])) {
	
		if (empty($_POST['language_id'])) {
			$_POST['language_id'] = $core_config['language']['default_id'];
		}
		
		
		$blog_rec = array();
		$blog_rec['blog_title'] = strip_tags($_POST['blog_title']);
		$blog_rec['blog_synopsis'] = strip_tags($_POST['blog_synopsis']);
		$blog_rec['language_id'] = $_POST['language_id'];
		$blog_rec['blog_type'] = $_POST['blog_type'];
		
		if (isset($_POST['permission']['blog'])) {
			$permission_count = "0";
			
			foreach ($_POST['permission']['blog'] as $key => $i):
				$permission_count = $permission_count+$i;
			endforeach;
			
			$blog_rec['blog_permission'] = $permission_count;
		}
		
		if (empty($_POST['file_id'])) {
			$_POST['file_id'] = "null";
		}
		
		$blog_rec['file_id'] = $_POST['file_id'];
		$blog_rec['level_id'] = $_POST['level_id'];
		
		if (!empty($_POST['blog_id'])) { // we update
			
			$blog_rec['status_id'] = $_POST['status_id'];
			
			$query = "
				SELECT * 
				FROM " . $db->prefix . "_blog  
				WHERE 
				blog_id=" . $_POST['blog_id']
			;
			
			$set_result = $db->Execute($query);
	
			if (isset($set_result->fields)) {
				$query = $db->GetUpdateSQL($set_result, $blog_rec, false, get_magic_quotes_gpc());
				$result = $db->Execute($query);
			}
				
			$blog_id = $_POST['blog_id'];
			
			
		}
		else { // we insert
			
			// apply all permissions
			$owner_permissions = 0;
			
			if (!empty($blog_config['resource']['user'])) {
				foreach ($blog_config['resource']['user'] as $key => $i):
					$owner_permissions = $owner_permissions + $i;
				endforeach;
			}
			
			$blog_rec['participation_permission'] = $owner_permissions;
			$blog_rec['blog_create_datetime'] = time();
			$blog_rec['user_id'] = $_SESSION['user_id'];
			$blog_rec['level_id'] = $_POST['level_id'];
			$blog_rec['status_id'] = $blog_config['status']['live'];
			$blog_rec['default_user_permission'] = $blog_config['default_participation_permission'];
			
			$table = $db->prefix . "_blog";
		
			$query = $db->GetInsertSQL($table, $blog_rec, get_magic_quotes_gpc());
			$result = $db->Execute($query);
			
			if (isset($result)) {
				$blog_id = $db->Insert_ID();
			}
			
			// I add myself to the participation table
			$author_permissions = 0;
			
			if (!empty($blog_config['resource']['blog'])) {
				foreach ($blog_config['resource']['blog'] as $key => $i):
					$author_permissions = $author_permissions + $i;
				endforeach;
			}		
			
			$user->identity_type = $core_config['user']['identity']['type']['registered'];
// 			$output_identity = $user->selUserIdentity($_SESSION['user_id']);	
			
			$rec = array();
			$rec['module_id'] = $core_config['module_id']['blog'];
			$rec['item_id'] = $blog_id;
			$rec['user_id'] = $_SESSION['user_id'];
			$rec['status_id'] = $blog_config['user']['status']['active'];
			$rec['identity_id'] = $_POST['identity_id'];;
			$rec['participation_permission'] = $author_permissions;
			$rec['participation_create_datetime'] = time();
			$rec['role_id'] = $blog_config['role']['author'];
			
			$table = $db->prefix . "_participation";
		
			$query = $db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
			$result = $db->Execute($query);
			
			// we set the allocation
			$rec = array();
			$rec['module_id'] = $core_config['module_id']['blog'];
			$rec['item_id'] = $blog_id;
			$rec['file_allocation'] = $blog_config['default_file_allocation'];
			
			$table = $db->prefix . "_file_allocation";
			
			$query = $db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
			$result = $db->Execute($query);
		}
		
		// we add membership types to the am_module_membership_type_access table
		if ($_POST['blog_type'] == $blog_config['type']['membership_type']) {
			
			$query = "
				DELETE FROM " . $db->prefix . "_mem_type_access 
				WHERE 
				module_id=" . $core_config['module_id']['blog'] . " AND 
				item_id=" . $blog_id
			;
			
			if (!empty($_POST['membership_types'])) {
				foreach ($_POST['membership_types'] as $key => $i) :
					$rec = array();
					$rec['module_id'] = $core_config['module_id']['blog'];
					$rec['item_id'] = $blog_id;
					$rec['membership_type_id'] = $i;
						
					$table = $db->prefix . "_mem_type_access";
						
					$query = $db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
					$result = $db->Execute($query);
				endforeach;
			}
		}
	}
	
	header("Location: index.php?amn=blg_item&blog_id=" . $blog_id . "&" . strip_tags(SID));
	exit;

}


if (!empty($_REQUEST['blog_id'])) {
	$output_blog = $blog->selBlog($_REQUEST['blog_id']);
	
	if (!empty($output_blog)) {
		// are we the owner of this blog?
		if ($_SESSION['user_id'] == $output_blog['user_id']) {
			// obtain any roles
			$query = "
				SELECT * 
				FROM " . $db->prefix . "_mem_type_access 
				WHERE 
				module_id=" . $core_config['module_id']['blog'] . " AND 
				item_id=" . $output_blog['blog_id']
			;
		
			$result = $db->Execute($query);
		
			if (isset($result->fields)) {
				$membership_type_ids = array();

				while (!$result->EOF) {
					array_push($membership_type_ids, $result->fields);
					$result->MoveNext();
				}
				
				$output_blog['membership_type_ids'] = $membership_type_ids;
			}
			
			$body->set('blog', $output_blog);
			
		}
		else {
			header("Location: index.php?amn=blg_item&blog_id=" . $output_blog['blog_id'] . "&" . strip_tags(SID));
			exit;
		}
	}
}
else {
	$output_identities = $user->selUserIdentities($_SESSION['user_id']);
	$body->set('identities', $output_identities);
}

	
// get available images
if (isset($output_blog['blog_id'])) {
	require_once ("components/core/class/File.class.php");
	$file = new File($db, $core_config['file']);
	$file->module_id = $core_config['module_id']['blog'];
	$file->item_id = $output_blog['blog_id'];
	$file->core_config_module = $core_config['module'];
	$file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
	$file->thumbs = $core_config['file']['image']['thumb'];
	
	$images = $file->selFiles("images", "t2");
	$body->set("images", $images);
}

// get coordinators
$output_authors = $participation->selParticipants(null, $blog_config['role']['author']);
	
if (!empty($output_authors)) {
	foreach ($output_authors as $key => $i):
		$user->identity_ids[] = $i['identity_id'];
	endforeach;
	
	$user->identity_ids = array_unique($user->identity_ids);
	
	if (!empty($user->identity_ids)) {
		$output_authors = $user->selUserIdentities();
		$body->set('authors', $output_authors);
	}
}


$body->set("module_prefix", $core_config['module'][$core_config['module_id']['blog']]['prefix']);

?>
