<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "event";

include_once($language_path . 'inc/evt_common.inc.php');

// Setup Event -----------------------------------------------------------
include_once ("config/evt.config.php");
require_once ("class/Event.class.php");
$evt                  = new Event($db, $core_config);
$evt->event_config    = $event_config;

if (isset($_SESSION['user_id'])) {
	$evt->user_id         = $_SESSION['user_id'];
	$evt->language_id     = $_SESSION['language_id'];
	$evt->location_id     = $_SESSION['location_id'];
}
else {
	$evt->event_config['view']['default_list'] = "all";
	$evt->level_id = $event_config['level']['public'];
}

$evt->high_attendance = true;
$evt->max_events      = 3;
$evt->date            = new Date;
$evt->allEvents();

$event_tags = $evt->selTagCloud();
$popular_events = $evt->selEvents(true, false);



$query = "
	SELECT e.event_id, e.event_title, COUNT(*) AS total, event_start_datetime
	FROM " . $db->prefix . "_event e 
	INNER JOIN " . $db->prefix . "_bookmark b 
	ON (b.item_id=e.event_id AND b.module_id=" . $core_config['module_id']['event'] . ") 
	WHERE b.bookmark_type=" . $core_config['bookmark']['type']['recommend'] . " AND "
;

if (isset($evt->level_id)) {
	$query .= "e.level_id=" . $evt->level_id . " AND ";
}

$query .= "1=1 "; 
$query .= "GROUP BY e.event_id ORDER BY total";

$result = $db->selectLimit($query, 10, 0);

if (isset($result->fields)) {
	$output_recommendations = array();
	while(!$result->EOF) {
		array_push($output_recommendations, $result->fields);
		$result->moveNext();
	}
	$result->Close();
}

if (!empty($event_tags)) {
	$body->set('tags', $event_tags);
}

if (!empty($popular_events)) {
	$body->set('events', $popular_events);
}

if (!empty($output_recommendations)) {
	$body->set('recommendations', $output_recommendations);
}

?>
