<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


// this include file is used in the core and in the event
// if it receives either a item_id or a event_id it gets the event
// if it returns the event it checks your participation in that

$menu_section = "group";


//setup group
$group_config['module_id'] = $core_config['module_id']['group'];

require_once('components/grp/class/Group.class.php');
$group = new Group($db, $group_config);

if (empty($_SESSION['md5'])) {
	$group->level_id = $group_config['level']['public'];
	$group->membership_type_id = 0;
}
else {
	$group->membership_type_id = $_SESSION['membership_type_id'];
}



require_once('components/core/class/Participation.class.php');
$participation = new Participation($db, $core_config);
$participation->module_id = $core_config['module_id']['group'];


// GET GROUP ----------------------------------------------------------
if (isset($_REQUEST['item_id']) && $_REQUEST['item_id'] > 0) {
	$_REQUEST['group_id'] = $_REQUEST['item_id'];
}

if (isset($_REQUEST['group_id']) && $_REQUEST['group_id'] > 0) {
	$group->group_id = $_REQUEST['group_id'];
	$output_group = $group->selGroup();
}


if (!empty($output_group)) {
	// a participant is a contributor; someone who has edited a page revision
	$participation->item_id = $output_group['group_id'];
	
	if (isset($_SESSION['user_id'])) {
		$output_participation = $participation->selParticipation($_SESSION['user_id']);
	}
	else { // we are not logged in
		if ($output_group['level_id'] == $group_config['level']['public']) {
			$output_participation = array();
		}
		else {
			header("Location: index.php?amn=grp_list&" . strip_tags(SID));
			exit;
		}
	}
	
	
	if (!empty($output_participation)) {
		$tpl->set('participation', $output_participation);
		$body->set('participation', $output_participation);
	}
	else {
		unset($output_participation);
	}
	
	$tpl->set('group', $output_group);
	$body->set('group', $output_group);
}

// we authenticate the user
if (isset($output_group['group_id']) && $script_name != "participation_edit") {
	//check status	
	if (isset($output_participation['status_id']) && $output_participation['status_id'] == $group_config['user']['status']['barred']) {
		header("Location: index.php?amn=grp_participate&" . strip_tags(SID));
		exit;
	}
	elseif ($output_group['level_id'] < $group_config['level']['public'] && $output_group['group_type'] == $group_config['type']['membership_type'] && $output_group['user_id'] != $_SESSION['user_id']) {
		// we need to check that my membership_type corresponds to those that can access the group
		if (!$participation->checkSetMembershipTypeAccess($_SESSION['membership_type_id'])) {
			header("Location: index.php?amn=grp_overview&" . strip_tags(SID));
			exit;
		}
	}
}

$tpl->set("group_config", $group_config);
$body->set("group_config", $group_config);


// FULLSCREEN MODE ------------------------------------------
if (isset($_REQUEST['exit_fullscreen']) || empty($output_group['group_unix_title'])) {
	unset ($_SESSION['fullscreen']);
}
elseif (isset($_REQUEST['enter_fullscreen']) && !empty($output_group['group_unix_title'])) {
	$_SESSION['fullscreen'] = 1;
}

if (!empty($_SESSION['fullscreen']) && !empty($output_group['group_title'])) {
	$lang['txt_page_title'] = $output_group['group_title'];
}

// prepare resource should we be adding an annoucement
$add_annoucement_resource = $group_config['resource']['user']['add_annoucements'];

?>
