<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------



class Activity {
	// CLASS FUNCTIONS
	// Activity
	// getActivity
	// getTasks
	// getTask
	// countActivityTaskUser
	// getActivities
	// updateActivity
	// insertActivity
	// deleteActivity
	// insertActivity
	// updateActivity
	// deleteActivity
	// getTaskApplicants
	// updateTaskApplicants
	// getUserTask
	// updateTaskUserStatus
	// insertTaskUserStatus
	// getUserTasks
	
	
	
	
	// Activity --------------------------------------------------------------------
	// the constuctor
	// tom calthrop - 7th April 2004
	//
	function Activity($db, $section_id, $date, $file = null) {
		$this->db = $db;
		$this->section_id = $section_id;
		$this->date = $date;
		
		if (isset($file)) {
		    $this->file = $file;
		}
		
	}//EO Activity
	
	
	
	// getActivity --------------------------------------------------------------------
	// returns single DB row
	// tom calthrop - 7th April 2004
	//
	function getActivity() {

		$query = "
			SELECT activity_id, activity_start_datetime, activity_end_datetime, 
			activity_title, activity_synopsis, activity_body, activity_location, 
			activity_frequency, file_id, user_id, activity_type_id, status_id 
			FROM " . $this->db->prefix . "_activity 
			WHERE "
		;
		
		if (isset($this->section_item_id)) {
		   $query .= "section_item_id=" . $this->section_item_id . " AND ";
		}
		
		if (isset($this->activity_id)) {
		   $query .= "activity_id=" . $this->activity_id . " AND ";
		}
		
		$query .= "1=1";
		
		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$temp = $result->fields;
			
			$temp['display_activity_start_datetime'] = $this->date->formatDate($temp['activity_start_datetime']);
			$temp['display_activity_end_datetime'] = $this->date->formatDate($temp['activity_end_datetime']);
			
			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=getActivity class=Activity.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	} //getActivity


	
	// getTasks --------------------------------------------------------------------
	// returns multiple DB rows
	// tom calthrop - 7th April 2004
	//
	function getTasks($search = null) {
		$query = "
			SELECT task_id, user_id, task_type_id, task_title,
			task_synopsis, task_start_datetime, task_end_datetime, 
			task_user_requirement, activity_id  
			FROM " . $this->db->prefix . "_activity_task 
			WHERE "
		;
		
		if (isset($this->activity_id)) {
		    $query .= "activity_id=" . $this->activity_id . " AND ";
		}
		
		if (isset($this->user_id)) {
		    $query .= "user_id=" . $this->user_id . " AND ";
		}
		
		if (isset($this->task_ids)) {
			$task_ids = "";
			foreach($this->task_ids as $key => $i):
				$task_ids .= $i;
				if (count($this->task_ids) > $key+1) {
				    $task_ids .=",";
				}
			endforeach;
			$query .= "task_id in (" . $task_ids . ") AND ";
		}
		
		if (isset($search)) {
			$query .= "
				(task_title like '%" . $search . "%' or
				task_synopsis like '%" . $search . "%') AND "
			;
		}
		
		$query .= "1=1 ";
		
		if (isset($this->orderby)) {
			$query .= "ORDER BY " . $this->orderby;
		}
		else {
			$query .= "ORDER BY task_title";
		}
		//echo $query;
		if (isset($this->limit)) {
			$result = $this->db->SelectLimit($query, $this->limit);
		} else {
			$result = $this->db->Execute($query);
		}

		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				$this->task_id = $temp1['task_id'];
				$temp1['task_start_datetime'] = $this->date->formatDate($temp1['task_start_datetime']);
				$temp1['task_applicants'] = $this->countActivityTaskUser($this->task_user_status_ids['pending']);
				$temp1['task_confirmed'] = $this->countActivityTaskUser($this->task_user_status_ids['confirmed']);
				$temp1['status'] = $this->getUserTask($temp1['task_id'], $temp1['user_id']);
				
				if (isset($search)) { //format search results
					$temp1['task_title'] = searchTextFormat($search, $temp1['task_title']);
					$temp1['task_synopsis'] = searchTextFormat($search, $temp1['task_synopsis']);
				}
				
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=getTasks class=Activity.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO getTasks

	
	
	// getTask --------------------------------------------------------------------
	// returns single DB row
	// tom calthrop - 7th April 2004
	//
	function getTask($task_id) {

		$query = "
			SELECT at.*
			FROM " . $this->db->prefix . "_activity_task at 
			WHERE
			at.task_id=" . $task_id
		;
		
		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$temp = $result->fields;
			$this->task_id = $temp['task_id'];
			$temp['display_task_start_datetime'] = $this->date->formatDate($temp['task_start_datetime']);
			$temp['task_applicants'] = $this->countActivityTaskUser($temp['task_id']);
			$temp['task_confirmed'] = $this->countActivityTaskUser($temp['task_id'], $this->task_user_status_ids['confirmed']);

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=getTask class=Activity.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO getTask

	
	
	// countActivityTaskUser --------------------------------------------------------------------
	// returns count of task applicants
	// tom calthrop - 25th December 2004
	//
	function countActivityTaskUser($status_id = null) {

		$query = "
			SELECT count(task_id) as total
			FROM " . $this->db->prefix . "_activity_task_user 
			WHERE 
			task_id=" . $this->task_id . " AND "
		;
		
		if (isset($status_id)) {
		    $query .= "status_id=" . $status_id . " AND ";
		}
		
		$query .= "1=1";
		
		$result = $this->db->Execute($query);

		if (isset($result->fields['total'])) {
			return $result->fields['total'];
		}
		else {
			$error_info = "function=countActivityTaskUser class=Activity.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO countActivityTaskUser



	// getActivities --------------------------------------------------------------------
	// returns multiple rows from DB
	// tom calthrop - 7th April 2004
	//
	function getActivities($search = null) {
		$query = "
			SELECT activity_id, activity_start_datetime, activity_title, 
			activity_end_datetime, section_id, 
			activity_synopsis, activity_location, file_id 
			FROM " . $this->db->prefix . "_activity 
			WHERE 
			section_id=" . $this->section_id . " AND "
		;
		
		if (isset($this->section_item_id)) {
		    $query .= "section_item_id=" . $this->section_item_id . " AND ";
		}
		
		if (isset($this->activity_type_id) && $this->activity_type_id > 0) {
		    $query .= "activity_type_id=" . $this->activity_type_id . " AND ";
		}
		
		if (isset($this->activity_ids)) {
			$activity_ids = "";
			foreach($this->activity_ids as $key => $i):
				$activity_ids .= $i;
				if (count($this->activity_ids) > $key+1) {
				    $activity_ids .=",";
				}
			endforeach;
			$query .= "activity_id in (" . $activity_ids . ") AND ";
		}
		
		if (isset($search)) {
			$query .= "
				(activity_title like '%" . $search . "%' or
				activity_synopsis like '%" . $search . "%') AND "
			;
		}
		
		$query .="1=1";
		
		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				$temp1['display_activity_start_datetime'] = $this->date->formatDate($temp1['activity_start_datetime']);
				$temp1['display_activity_end_datetime'] = $this->date->formatDate($temp1['activity_end_datetime']);
				
				if (isset($this->file)) {
					if ($temp1['section_id'] == 1) {
					    $this->file->path = "user";
					}
					elseif ($temp1['section_id'] == 2) {
					    $this->file->path = "group";
					}
					
					if (isset($temp1['file_id'])) {
						$this->file->file_id = $temp1['file_id'];
						$temp1['image'] = $this->file->getFileRecord();
					}
					else {
						$temp1['image']['file_title'] = "";
						$temp1['image']['file'] = $this->file->noimage;
					}
				}
				
				if (isset($search)) { //format search results
					$temp1['activity_title'] = searchTextFormat($search, $temp1['activity_title']);
					$temp1['activity_synopsis'] = searchTextFormat($search, $temp1['activity_synopsis']);
				}
				
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			
			return $temp;
		}
		else {
			$error_info = "function=getActivities class=Activity.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	} //EO getActivities
	
	
	
	// updateActivity --------------------------------------------------------------------
	// upates activity
	// tom calthrop - 2nd May 2004
	//
	function updateActivity($data, $user_id) {

		$datetime = date("Y-m-d H:i:s");
		$datetime = $this->db->DBDate($datetime);

		if (isset($data['activity_frequency']) && $data['activity_frequency'] > 0) {
			$frequency = $data['activity_frequency'];
		}
		else {
			$frequency = "null";
		}

		if (empty($_POST["no_start_datetime"]))
		    $activity_start_datetime = "'" . $_POST['start_year']."-".$_POST['start_month']."-".$_POST['start_day']." ".$_POST['start_hour'].":".$_POST['start_minute'].":00'";
		else
			$activity_start_datetime = "null";

		if (empty($_POST["no_end_datetime"]))
			$activity_end_datetime = "'" . $_POST['end_year']."-".$_POST['end_month']."-".$_POST['end_day']." ".$_POST['end_hour'].":".$_POST['end_minute'].":00'";
		else
			$activity_end_datetime = "null";


		if (isset($data['file_id'])) {
			$file_id = $data['file_id'];
		}
		else {
			$file_id = "null";
		}

		if (isset($data['group_id']) && $data['group_id'] > 0) {
			$group_id = $data['group_id'];
		}
		else {
			$group_id = "null";
		}

		if (isset($data['status_id'])) {
			$status_id = $data['status_id'];
		}
		else {
			$status_id = "null";
		}

		if (isset($data['level_id'])) {
			$level_id = $data['level_id'];
		}
		else {
			$level_id = "null";
		}

		$query = "
			UPDATE " . $this->db->prefix . "_" . $this->module . "_activity SET
			group_id=" . $group_id . ",
			activity_edit_datetime =" . $datetime . ",
			user_id_edit ='" . $user_id . "',
			activity_start_datetime=" . $activity_start_datetime . ",
			activity_end_datetime =" . $activity_end_datetime . ",
			activity_frequency =" . $frequency . ",
			activity_title='" . $data['activity_title'] . "',
			activity_description='" . $data['activity_description'] . "',
			activity_body='" . $data['activity_body'] . "',
			activity_location='" . $data['activity_location'] . "',
			file_id=" . $file_id . ",
			status_id=" . $status_id . "
			WHERE activity_id=" . $data['activity_id']
		;
		
		$result = $this->db->Execute($query);

		if (empty($result)) {
			$error_info = "function=updateActivity class=Activity.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO updateActivity
	
	
	
	// insertActivity --------------------------------------------------------------------
	// inserts a single DB row
	// tom calthrop - 11th April 2004
	//
	function insertActivity($data) {

		$datetime = date("Y-m-d H:i:s");
		$datetime = $this->db->DBDate($datetime);
		
		if (empty($data['file_id'])) {
			$data['file_id']= "null";
		}

		if (empty($data['status_id'])) {
			$data['status_id'] = "null";
		}
		
		if (empty($data['activity_frequency']) || (isset($data['activity_frequency']) && $data['activity_frequency'] < 1)) {
			$data['activity_frequency'] = "null";
		}
		
		if (empty($data['activity_type_id']) || (isset($data['activity_type_id']) && $data['activity_type_id'] < 1)) {
			$data['activity_type_id'] = "null";
		}

		if (empty($_POST["no_start_datetime"])) {
		    $activity_start_datetime = "'" . $_POST['start_year']."-".$_POST['start_month']."-".$_POST['start_day']." ".$_POST['start_hour'].":".$_POST['start_minute'].":00'";
		}
		else {
			$activity_start_datetime = "null";
		}

		if (empty($_POST["no_end_datetime"])) {
			$activity_end_datetime = "'" . $_POST['end_year']."-".$_POST['end_month']."-".$_POST['end_day']." ".$_POST['end_hour'].":".$_POST['end_minute'].":00'";
		}
		else {
			$activity_end_datetime = "null";
		}
		
		if (!empty($_POST['activity_start_day'])) {
		    $activity_start_day = $_POST['activity_start_day'];
		}
		else {
			$activity_start_day = "null"; 
		}
		
		if (!empty($_POST['activity_start_month'])) {
		    $activity_start_month = $_POST['activity_start_month'];
		}
		else {
			$activity_start_month = "null"; 
		}
		
		if (!empty($_POST['activity_end_day'])) {
		    $activity_end_day = $_POST['activity_end_day'];
		}
		else {
			$activity_end_day = "null"; 
		}
		
		if (!empty($_POST['activity_end_month'])) {
		    $activity_end_month = $_POST['activity_end_month'];
		}
		else {
			$activity_end_month = "null"; 
		}
		
		if (!empty($_POST['activity_start_weekday'])) {
		    $activity_start_weekday = $_POST['activity_start_weekday'];
		}
		else {
			$activity_start_weekday = "null"; 
		}
		
		if (!empty($_POST['activity_end_weekday'])) {
		    $activity_end_weekday = $_POST['activity_end_weekday'];
		}
		else {
			$activity_end_weekday = "null"; 
		}
		
		if($data['activity_frequency'] == $this->frequency_ids['monthly']) { 
			$activity_start_month = 0;
			$activity_end_month = 0;
			$activity_start_weekday = 0;
			$activity_end_weekday = 0;
		}
		elseif($_POST['activity_frequency'] == $this->frequency_ids['yearly']) {
			$activity_start_weekday = 0;
			$activity_end_weekday = 0;
		}
		elseif($data['activity_frequency'] == $this->frequency_ids['weekly']) {
			$activity_start_day = 0;
			$activity_end_day = 0;
			$activity_start_month = 0;
			$activity_end_month = 0;
		}
			
		$query = "
			INSERT INTO " . $this->db->prefix . "_activity (
			section_id, 
			section_item_id, 
			activity_create_datetime, 
			user_id, 
			activity_start_datetime,
			activity_end_datetime, 
			activity_frequency, 
			activity_title, 
			activity_type_id, 
			activity_synopsis,
			activity_body, 
			activity_location, 
			file_id,
			status_id,
			activity_start_day,
			activity_start_month,
			activity_end_day,
			activity_end_month,
			activity_start_weekday,
			activity_end_weekday
			) VALUES (
			" . $this->section_id . ",
			'" . $this->section_item_id . "',
			" . $datetime . ",
			" . $this->user_id . ",
			" . $activity_start_datetime . ",
			" . $activity_end_datetime . ",
			" . $data['activity_frequency'] . ",
			'" . $data['activity_title'] . "',
			" . $data['activity_type_id'] . ",
			'" . $data['activity_synopsis'] . "',
			'" . $data['activity_body'] . "',
			'" . $data['activity_location'] . "',
			" . $data['file_id'] . ",
			" . $data['status_id'] . ",
			" . $activity_start_day . ",
			" . $activity_start_month . ",
			" . $activity_end_day . ",
			" . $activity_end_month . ",
			" . $activity_start_weekday . ",
			" . $activity_end_weekday . "
			)"
		;

		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$query = "
				SELECT activity_id  
				FROM " . $this->db->prefix . "_activity 
				where
				user_id=" . $this->user_id . " AND 
				activity_create_datetime=" . $datetime 
			;
	
			$result = $this->db->SelectLimit($query, 1);
			
			if (isset($result->fields['activity_id'])) {
				$this->activity_id = $result->fields['activity_id'];
			}
			else {
				$error_info = "function=insertActivity class=Activity.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
			}
		}
		else {
			$error_info = "function=insertActivity class=Activity.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO insertActivity



	// deleteActivity --------------------------------------------------------------------
	// deletes a single DB row
	// tom calthrop - 11th April 2004
	//
	function deleteActivity($activity_id) {

		$query = "
			DELETE FROM " . $this->db->prefix . "_activity
			WHERE activity_id=" .  $activity_id
		;

		$result = $this->db->Execute($query);

		if (empty($result)) {
			$error_info = "function=deleteActivity class=Activity.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO deleteActivity

	
	
	// insertTask --------------------------------------------------------------------
	// inserts a single DB row
	// tom calthrop - 3rd May 2004
	//
	function insertTask($data) {

		$datetime = date("Y-m-d H:i:s");
		$datetime = $this->db->DBDate($datetime);

		$task_start_datetime = $_POST['start_year']."-".$_POST['start_month']."-".$_POST['start_day']." ".$_POST['start_hour'].":".$_POST['start_minute'].":00";

		$task_end_datetime = $_POST['end_year']."-".$_POST['end_month']."-".$_POST['end_day']." ".$_POST['end_hour'].":".$_POST['end_minute'].":00";
		
		if (isset($data['task_user_requirement'])) {
			$task_user_requirement = $data['task_user_requirement'];
		}
		else {
			$task_user_requirement = "0";
		}
		
		if (isset($data['task_type_id'])) {
			$task_type_id = $data['task_type_id'];
		}
		else {
			$task_type_id = "null";
		}
		
		$query = "
			INSERT INTO " . $this->db->prefix . "_activity_task (
			user_id, 
			activity_id, 
			task_title, 
			task_synopsis, 
			task_start_datetime,
			task_end_datetime, 
			task_create_datetime, 
			task_user_requirement, 
			task_type_id
			) VALUES (
			" . $this->user_id . ",
			" . $this->activity_id . ",
			'" . $data['task_title'] . "',
			'" . $data['task_synopsis'] . "',
			'" . $task_start_datetime . "',
			'" . $task_end_datetime . "',
			" . $datetime . ",
			" . $task_user_requirement . ", 
			" . $task_type_id . "
			)"
		;
		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$query = "
				SELECT task_id  
				FROM " . $this->db->prefix . "_activity_task 
				where
				user_id=" . $this->user_id . " AND 
				task_create_datetime=" . $datetime 
			;
	
			$result = $this->db->SelectLimit($query, 1);
			
			if (isset($result->fields['task_id'])) {
				$this->task_id = $result->fields['task_id'];
			}
			else {
				$error_info = "function=insertTask class=Activity.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
			}
		}
		else {
			$error_info = "function=insertTask class=Activity.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO insertTask



	// updateTask --------------------------------------------------------------------
	// updates a single DB row
	// tom calthrop - 3rd May 2004
	//
	function updateTask($data) {

		$datetime = date("Y-m-d H:i:s");
		$datetime = $this->db->DBDate($datetime);

		$task_start_datetime = $_POST['start_year']."-".$_POST['start_month']."-".$_POST['start_day']." ".$_POST['start_hour'].":".$_POST['start_minute'].":00";

		$task_end_datetime = $_POST['end_year']."-".$_POST['end_month']."-".$_POST['end_day']." ".$_POST['end_hour'].":".$_POST['end_minute'].":00";

		if (isset($data['task_user_requirement'])) {
			$task_user_requirement = $data['task_user_requirement'];
		}
		else {
			$task_user_requirement = "0";
		}
		
		if (isset($data['task_type_id'])) {
			$task_type_id = $data['task_type_id'];
		}
		else {
			$task_type_id = "null";
		}

		$query = "
			UPDATE " . $this->db->prefix . "_activity_task SET 
			task_title='" . $data['task_title'] . "',
			task_synopsis='" . $data['task_synopsis'] . "',
			task_start_datetime='" . $task_start_datetime . "',
			task_end_datetime='" . $task_end_datetime . "', 
			task_user_requirement=" . $task_user_requirement . ",
			task_type_id=" . $task_type_id . "
			WHERE task_id=" . $data['task_id']
		;

		$result = $this->db->Execute($query);

		if (empty($result)) {
			$error_info = "function=updateTask class=Activity.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO updateTask


	
	// deleteTask --------------------------------------------------------------------
	// deletes a single DB row
	// tom calthrop - 11th April 2004
	//
	function deleteTask($task_id) {

		$query = "
			DELETE FROM " . $this->db->prefix . "_activity_task
			WHERE task_id=" .  $task_id
		;

		$result = $this->db->Execute($query);

		if (empty($result)) {
			$error_info = "function=deleteTask class=Activity.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO deleteTask

	
	
	// getTaskApplicants --------------------------------------------------------------------
	// returns multiple DB rows
	// tom calthrop - 7th April 2004
	//
	function getTaskApplicants($task_id) {

		$query = "
			SELECT au.*, p.profile_nic, p.profile_hometown, p.profile_create_datetime
			FROM " . $this->db->prefix . "_activity_task_user au, " . $this->db->prefix . "_user_profile p 
			WHERE
			au.user_id=p.user_id and 
			p.profile_default=1 and 
			au.task_id=" . $task_id
			;

		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;

				$temp1['profile_create_datetime'] = $this->date->formatDate($temp1['profile_create_datetime']);
				$temp1['task_user_create_datetime'] = $this->date->formatDate($temp1['task_user_create_datetime']);

				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=getTaskApplicants class=Activity.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO getTaskApplicants

	
	
	// updateTaskApplicants --------------------------------------------------------------------
	// updates multiple DB rows
	// tom calthrop - 11th April 2004
	//
	function updateTaskApplicants($task_id, $user_arr, $task_user_status_arr)
	{
		$rownums = count ($user_arr);

		for ($i=0; $i < $rownums; $i++) {
			$query = "
				UPDATE " . $this->db->prefix . "_activity_task_user SET
				status_id=" . $task_user_status_arr[$i] . "
				WHERE
				user_id = " . $user_arr[$i] . " and
				task_id=" . $task_id
			;

			$result = $this->db->Execute($query);

			if (empty($result)) {
				$error_info = "function=updateTaskApplicants class=Activity.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
			}
		}
	}//EO updateTaskApplicants
	

	
	// getUserTask --------------------------------------------------------------------
	// updates single DB rows
	// tom calthrop - 11th April 2004
	//
	function getUserTask($task_id, $user_id) {

		$query = "
			SELECT *
			FROM " . $this->db->prefix . "_activity_task_user 
			WHERE
			user_id=" . $user_id . " and
			task_id=" . $task_id
		;
		
		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$temp = $result->fields;
			$temp['task_user_create_datetime'] = $this->date->formatDate($temp['task_user_create_datetime']);

			$result->Close();

			return $temp;
		}
		else {
			$error_info = "function=getUserTask class=Activity.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	} //EO getUserTask


	
	// updateTaskUserStatus --------------------------------------------------------------------
	// updates single DB rows
	// tom calthrop - 11th April 2004
	//
	function updateTaskUserStatus($task_id, $user_id, $status_id) {

		$datetime = date("Y-m-d H:i:s");
		$datetime = $this->db->DBDate($datetime);

		$query = "
			UPDATE " . $this->db->prefix . "_activity_task_user SET
			status_id=" . $status_id . " 
			WHERE
			user_id=" . $user_id . " AND 
			task_id=" . $task_id
		;
		
		$result = $this->db->Execute($query);

		if (empty($result))  {
			$error_info = "function=updateTaskUserStatus class=Activity.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO updateTaskUserStatus



	// insertTaskUserStatus --------------------------------------------------------------------
	// inserts multiple DB rows
	// tom calthrop - 7th April 2004
	//
	function insertTaskUserStatus($task_id, $user_id, $status_id) {

		$datetime = date("Y-m-d H:i:s");
		$datetime = $this->db->DBDate($datetime);

		$query = "
			INSERT INTO " . $this->db->prefix . "_activity_task_user
			(task_id, status_id, task_user_create_datetime, user_id) VALUES (
			" . $task_id . ",
			" . $status_id . ",
			" . $datetime . ",
			" . $user_id . "
			)"
		;
		
		$result = $this->db->Execute($query);

		if (empty($result))  {
			$error_info = "function=insertTaskUserStatus class=Activity.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO insertTaskUserStatus
	
	
	
	// getUserTasks --------------------------------------------------------------------
	// returns multiple DB rows
	// tom calthrop - 3rd January 2005
	//
	function getUserTasks() {

		$query = "
			SELECT task_id
			FROM " . $this->db->prefix . "_activity_task_user 
			WHERE
			user_id=" . $this->user_id
			;

		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=getUserTasks class=Activity.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO getUserTasks
}

?>
