<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "config/config_server.inc.php";
include "config/config_aroundme.inc.php";
include "inc/functions.inc.php";

if (isset($_REQUEST['friend'])) {
	$friend_id = $_REQUEST['friend'];
}

elseif (isset($_SESSION['s_homepage'])) {
	header("Location: " . $_SESSION['s_homepage']."?".SID);
	exit;
}
else {
	header("Location: index.php?".SID);
	exit;
}

//database setup and connect
require_once($c_node['class_dir'] . 'Adodb/adodb.inc.php');
$ADODB_CACHE_DIR = 'cache/Adodb';
$ADODB_FETCH_MODE = ADODB_FETCH_BOTH;
$db = NewADOConnection('mysql');
$db->Connect($c_node['db']['host'], $c_node['db']['user'] , $c_node['db']['pass'] , $c_node['db']['db']);
$db->prefix = $c_node['db']['prefix'];


//Date
require_once($c_node['class_dir'] . 'Date.class.php');
$date = new Date();


//setup user
require_once($c_node['class_dir'] . 'User/User.class.php');
$user = new User();
$user->relation_type = $c_node['relation_type']['approved'];
$user->total_login_stat_id = $c_node['user_statistic_type_id']['total_logins'];
$user->stat_type_id_friends = $c_node['user_statistic_type_id']['total_friends'];
$user->stat_type_id_aqaintances = $c_node['user_statistic_type_id']['total_aqaintances'];
$user->db = $db;
$user->date = $date;
$user->authUser();

$user->user_id = $_SESSION['s_user_id'];


//setup language
$template_name = $c_node['template_default_name'];
$languagePath = "language/" . $_SESSION['s_language_id'] . "/" . $template_name . "/";
$languageArrayPath = $languagePath . "/arrays/";
$languageTextPath = $languagePath . "/texts/";

require_once($languageTextPath . 'message.lang.php');


//update relation
if ($user->updateRelation($friend_id)) {

	//get friends details
	$friend_details = $user->userDetails($friend_id);
	//setup IM
	require_once($c_node['class_dir'] . 'User/IM.class.php');
	$im = new IM($_SESSION['s_user_id'], $db, '10000');
	$im->setStatus($c_node['message_status_unread'], $c_node['message_status_read']);
	$im->setBoxes($c_node['message_in_box'], $c_node['message_save_box'], $c_node['message_out_box']);


	//get text files
	$body_im_txt = readTxtFile($languageTextPath . "/im_new_friend.txt.php");
	$body_im_txt = str_replace("NAME",$friend_details['user_firstname'] , $body_im_txt);
	$body_im_txt = str_replace("FRIEND", $_SESSION['s_firstname'], $body_im_txt);
	//send invites
	$im->sendMessage($friend_id, $lang['subject_im_friendship_accepted'], $body_im_txt);

}

//redirect to my_friends.php
header("Location: sn_network.php?".SID);
exit;

$db->Close();

?>
