<?
//- Configuration --------------------------------------------------//

// You do not need to adjust much in the config if you are running a standard
// installation of 'aroundme'. See the installation file (install.txt) for
// details.
//
// Tom Calthrop - 24th April 2004 (info@barnraiser.org)
//



//- [1] - Aroundme Configuration --------------------------------------------------//
// is this node in a network? (default = standalone / networked = LDAP)
$c_node['node_mode'] = 					"standalone";

// if in a network Barnraiser will supply you a unique node ID (standalone default = 1)
$c_node['node_id'] = 					"1";

// template setup
$c_node['template_default_name'] = 		"am_default";
$c_node['template_default_id'] = 		"1";

//languages: list within the array the language ID's available to this node.
//NOTICE: You WILL NEED to check you have the language files installed before extending this
$c_node['language_default'] = 			"1"; //English, the default node language
$c_node['language_available'] = 		array(1, 2); //English only


//setup help group id's for each language. We use the ID to point to the correct group
$c_node['help_group_id'][1] =			"1"; //English default help group

//image
$c_node['max_user_space'] = 			"100";
$c_node['max_group_space'] = 			"100";
$c_node['image_max_width'] = 			"280";


//IM max size
$c_node['message_box_max_size'] = 		"10000";


//default node administrator ID //when you get a join message from this user
$c_node['default_node_admin_id'] = 		"1";


//- [7] - Database Primary Keys --------------------------------------------------//
//These are the default setting throughout the database. You should not have to touch
// these.


//bookmark levels
$c_node['level_id_local_homepage'] = 								"1";
$c_node['level_id_node_homepage'] = 								"2";

//messages settings
$c_node['message_in_box'] = 										"1";
$c_node['message_out_box'] = 										"2";
$c_node['message_save_box'] = 										"3";
$c_node['message_status_unread'] = 									"1";
$c_node['message_status_read'] = 									"2";

//user levels
$c_node['user_level_id']['barred'] = 								"0";
$c_node['user_level_id']['visitor'] = 								"1";
$c_node['user_level_id']['pending'] = 								"2";
$c_node['user_level_id']['member'] = 								"4";
$c_node['user_level_id']['moderator'] = 							"8";
$c_node['user_level_id']['group_council'] = 						"16";
$c_node['user_level_id']['group_chair'] = 							"32";
$c_node['user_level_id']['group_administrator'] = 					"64";
$c_node['user_level_id']['node_administrator'] = 					"128";

//user statistic id's
$c_node['user_statistic_type_id']['total_logins'] = 				"1";
$c_node['user_statistic_type_id']['total_friends'] = 				"2";
$c_node['user_statistic_type_id']['total_aqaintances'] = 			"3";
$c_node['user_statistic_type_id']['total_blogs'] = 					"4";
$c_node['user_statistic_type_id']['total_shouts'] = 				"5";
$c_node['user_statistic_type_id']['total_guestbooks'] = 			"6";
$c_node['user_statistic_type_id']['total_library_items'] = 			"7";
$c_node['user_statistic_type_id']['total_forum_subjects'] = 		"8";
$c_node['user_statistic_type_id']['total_forum_topics'] = 			"9";
$c_node['user_statistic_type_id']['total_forum_replies'] = 			"10";

//group statistic id's
$c_node['group_statistic_type_id']['total_members'] = 				"1";
$c_node['group_statistic_type_id']['total_forum_topics'] = 			"2";
$c_node['group_statistic_type_id']['total_forum_subjects'] = 		"3";
$c_node['group_statistic_type_id']['total_forum_replies'] = 		"4";
$c_node['group_statistic_type_id']['total_library_items'] = 		"5";

//group member statistic id's
$c_node['group_member_statistic_type_id']['total_replies'] = 		"1";
$c_node['group_member_statistic_type_id']['total_topics'] = 		"2";
$c_node['group_member_statistic_type_id']['total_subjects'] = 		"3";
$c_node['group_member_statistic_type_id']['total_library_items'] = 	"4";

//blog item publishing levels
//$c_node['blog_publish']['all'] = 									"1"; - removed in favour of $c_node['user_publish'] // tom calthrop - 1st june 2004
//$c_node['blog_publish']['friends'] = 								"2"; - removed in favour of $c_node['user_publish'] // tom calthrop - 1st june 2004

//library publishing levels
$c_node['user_publish']['all'] = 									"1";
$c_node['user_publish']['friends'] = 								"2";

//group type ID's
$c_node['group_type']['open'] = 									"1";
$c_node['group_type']['registration_required'] = 					"2";
$c_node['group_type']['closed'] = 									"3";

//group level ID's
$c_node['group_type']['section'] = 									"0";
$c_node['group_type']['group_home'] = 								"1";
$c_node['group_type']['node_home'] = 								"2";

//group status
$c_node['group_status']['active'] = 								"2";
$c_node['group_status']['pending'] = 								"1";
$c_node['group_status']['archive'] = 								"0";

//Event activity type ID's
$c_node['activity_user_status']['pending'] = 						"1";
$c_node['activity_user_status']['confirmed'] = 						"2";
$c_node['activity_user_status']['rejected'] = 						"3";
$c_node['activity_user_status']['withdrawn'] = 						"4";

//Relationship approved ID's
$c_node['relation_type']['approved'] = 								"2";
$c_node['relation_type']['approval_pending'] = 						"1";

//Event publish level ID's
$c_node['arr_event_publish_user']['me'] = 							"1";
$c_node['arr_event_publish_user']['friends'] = 						"2";

//Abuse report default level ID
$c_node['arr_abuse_status']['unallocated'] = 						"2";

?>
