<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

$core = "group";
include "inc/header.inc.php";
require_once($c_node['class_dir'] . 'Group/Forum.class.php');


//check that we are allowed here
if ($output_group_member_level['user_level_id'] < $c_node['user_level_id']['moderator']) {
    header("Location: g_group.php?group_id=" . $group_id."?".SID);
	exit;
}


//append language setup
require_once($languageArrayPath . 'arr_user_priv.lang.php');
require_once($languageArrayPath . 'arr_group_type.lang.php');
require_once($languageArrayPath . 'arr_language_name.lang.php');
require_once($languageArrayPath . 'arr_genre.lang.php');
require_once($languageArrayPath . 'arr_group_status.lang.php');

//post
if (isset($_POST['action'])) {
    $action = $_POST['action'];
}

//setup forum
$forum = new Forum($group_id);
$forum->db = $db;
$forum->user_id = $me['user_id'];
$forum->group_id = $group_id;

if (isset($_REQUEST['section_id'])) {
	$forum->section_id = $_REQUEST['section_id'];
}


//process requests
if (isset($_REQUEST['display_view_section'])) {
	$display = "view_section";
	$output_sections = $forum->sectionList();
}
elseif (isset($_POST['display_add_section'])) {
	$display = "add_section";
}
else if (isset($_REQUEST['display_edit_section'])) {
	$output_section = $forum->sectionDetails();
	$output_section['topics'] = $forum->topicCount();
	$display = "edit_section";
}
elseif (isset($action) && $action == 'add_section') {
	$insert = $forum->insertSection($data['section_title']);

	if ($insert[0][0] == "success") {
	    $success = $insert;
	}
	else {
	    $error = $insert;
	}

	$output_sections = $forum->sectionList();
	$display = "view_section";
}
elseif (isset($_POST['edit_section'])) {
	$update = $forum->updateSection($data['section_id'], $data['section_title']);

	if ($update[0][0] == "success") {
	    $success = $update;
	}
	else {
	    $error = $update;
	}

	$output_sections = $forum->sectionList();
	$display = "view_section";
}
elseif (isset($_POST['delete_section'])) {
	$delete = $forum->deleteSection($data['section_id']);

	if ($delete[0][0] == "success") {
	    $success = $delete;
	}
	else {
	    $error = $delete;
	}

	$output_sections = $forum->sectionList();
	$display = "view_section";
}
elseif (isset($_REQUEST['edit_group'])) {

	$display = "edit_group";

}
elseif (isset($_REQUEST['edit_group_rules'])) {
	$display = "edit_group_rules";

}
elseif (isset($_POST['update_group'])) {

	$data['group_title'] = htmlspecialchars($data['group_title']);
	$data['group_synopsis'] = htmlspecialchars($data['group_synopsis']);

	if (isset($data['new_group_status']) && $data['new_group_status'] > 0) {
		if (($data['new_group_status'] == $c_node['group_status']['active']) && ($data['group_status'] == $c_node['group_status']['pending'])) {

			$group->ftp = $c_node['ftp'];
			$group->user_id = $me['user_id'];
			$group->default_section_title = $lang['txt_default_section_title'];
			$group->default_library_title = $lang['txt_default_library_title'];
			$group->default_library_synopsis = $lang['txt_default_library_synopsis'];
			$group->default_library_body = $lang['txt_default_library_body'];
			$group->default_library_page_name = $lang['txt_wiki_default'];
			$group_setup = $group->setupGroup($group_id);//first tiem to active, so we need to setup the group
			$data['group_status'] = $c_node['group_status']['active'];//set group to active
		}
		elseif ($data['new_group_status'] == $c_node['group_status']['active']) {
			$data['group_status'] = $c_node['group_status']['active'];//set group to active
		}
		elseif ($data['new_group_status'] == $c_node['group_status']['archive']) {
			$data['group_status'] = $c_node['group_status']['archive'];//set group to archive
		}

	}

	$update = updateGroup($group_id, $data);

	if ($update[0][0] == "success") {
	    $success = $update;
		$output_group = $group->groupDetails();
	}
	else {
	    $error = $update;
		$display = "edit_group";
	}


}
elseif (isset($_POST['delete_group'])) {
	$group->deleteGroup($group_id);
}
elseif (isset($_POST['update_group_rules'])) {

	$data['group_rules'] = htmlspecialchars($data['group_rules']);

	$update = updateGroupRules($group_id, $data);

	if ($update[0][0] == "success") {
	    $success = $update;
		$output_group = $group->groupDetails();
	}
	else {
	    $error = $update;
		$display = "edit_group";
	}
}
elseif (isset($_REQUEST['membership_list'])) {

	$output_members = $group->getMembership($group_id);
	$display = "membership_list";

}
elseif (isset($_POST['update_membership'])) {
	$update = updateGroupMember($group_id, $data);

	if ($update[0][0] == "success") {
	    $success = $update;
	}
	else {
	    $error = $update;
	}

	$output_members = $group->getMembership($group_id);

	$display = "membership_list";

}
else {
	//display group

}


$output_user = $user->userDetails($me['user_id']);

//move to template
if (isset($output_group_member_level)) {
	$body->set('group_member_level', $output_group_member_level);
}

if (isset($output_user)) {
	$body->set('user', $output_user);
}

if (isset($output_group)) {
	$body->set('group', $output_group);
}

if (isset($display)) {
	$body->set('display', $display);
}

if (isset($output_sections)) {
	$body->set('sections', $output_sections);
}

if (isset($output_section)) {
	$body->set('section', $output_section);
}

if (isset($output_members)) {
	$body->set('members', $output_members);
}

$body->set('group_status', $c_node['group_status']);


$body->set('datedropdown', $date->dateDropdown($output_group['group_election_date'], null,null, 10, 20));

include "inc/footer.inc.php";



/*
* updateGroup
* Tom Calthrop 27th April 2004
*/
function updateGroup ($group_id, $data) {

	global $db, $me, $c_node, $error;

	$datetime = date("Y-m-d H:i:s");
	$datetime = $db->DBDate($datetime);

	if ($data['group_from_age'] <= 0) {
	    $data['group_from_age'] = "null";
	}

	if ($data['group_to_age'] <= 0) {
	    $data['group_to_age'] = "null";
	}

	if ($data['genre_id'] <= 0) {
	    $data['genre_id'] = "null";
	}

	if (isset($_POST['year'])) {
	    $group_election_date = $_POST['year']."-".$_POST['month']."-".$_POST['day'];
	}
	else {
		$group_election_date = "null";
	}

	//update group
	$query = "
		UPDATE " . $db->prefix . "_group SET
		group_title='" . $data['group_title'] . "',
		group_synopsis='" . $data['group_synopsis'] . "',
		language_id=" . $data['language_id'] . ",
		group_edit_datetime=" . $datetime . ",
		group_type=" . $data['group_type'] . ",
		group_from_age=" . $data['group_from_age'] . ",
		group_to_age=" . $data['group_to_age'] . ",
		genre_id=" . $data['genre_id'] . ",
		node_id=" . $me['node_id'] . ",
		user_id_edit=" . $me['user_id'] . ",
		group_status=" . $data['group_status'] . ",
		group_election_date='" . $group_election_date . "'
		WHERE group_id=" . $group_id
	;
	//echo $query;
	$result = $db->Execute($query);

	if (!$result) {
		$state[]  = array('error', 1, $db->ErrorMsg());
	}
	else {
		$state[]  = array('success', 2);
	}

	return $state;

} //EO updateGroup();



/*
* updateGroupRules
* Tom Calthrop 27th April 2004
*/
function updateGroupRules ($group_id, $data) {

	global $db, $me, $c_node, $error;


	//update group
	$query = "
		UPDATE " . $db->prefix . "_group SET
		group_rules='" . $data['group_rules'] . "'
		WHERE group_id=" . $group_id
	;

	$result = $db->Execute($query);

	if (!$result) {
		$state[]  = array('error', 1, $db->ErrorMsg());
	}
	else {
		$state[]  = array('success', 2);
	}

	return $state;

} //EO updateGroupRules();




/*
* updateGroupMember
* Tom Calthrop 27th April 2004
*/
function updateGroupMember ($group_id, $data) {

	global $db, $me, $c_node, $error;


	//update group
	$query = "
		UPDATE " . $db->prefix . "_group_member SET
		level_id='" . $data['level_id'] . "'
		WHERE
		group_id=" . $group_id . " and
		user_id=" . $data['user_id']
	;

	$result = $db->Execute($query);

	if (!$result) {
		$state[]  = array('error', 1, $db->ErrorMsg());
	}
	else {
		$state[]  = array('success', 2);
	}

	return $state;

} //EO updateGroupMember();

?>
