<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

$core = "group";
include "inc/header.inc.php";


//append language setup
require_once($languageTextPath . 'node_rules.lang.php');
require_once($languageArrayPath . 'arr_language_name.lang.php');
require_once($languageArrayPath . 'arr_genre.lang.php');


if (isset($_POST['create_group'])) {
	$output_group = array();
	$output_group['group_type'] = $data['group_type'];

	$display = "group_setup";
}
elseif (isset($_POST['insert_group'])) {
	$output_group = array();
	$output_group = $data;

	$group_id = insertGroup($data);

	$display = "completed";
}
else {
	$display = "group_select";
}


//move to template
if (isset($display)) {
	$body->set('display', $display);
}

if (isset($c_node['group_type'])) {
	$body->set('group_type', $c_node['group_type']);
}

if (isset($output_group)) {
	$body->set('group', $output_group);
}

if (isset($group_id)) {
	$body->set('group_id', $group_id);
}

$body->set('language_id', $me['language_id']);

include "inc/footer.inc.php";



/*
* insertGroup
* create a group and return the ID
* Tom Calthrop 15th April 2004
*/
function insertGroup ($data) {

	global $db, $me, $c_node, $im, $error, $lang, $languageTextPath;

	$datetime = date("Y-m-d H:i:s");
	$datetime = $db->DBDate($datetime);

	if (!isset($data['group_from_age']) || $data['group_from_age'] <= 0) {
	    $data['group_from_age'] = "null";
	}

	if (!isset($data['group_to_age']) || $data['group_to_age'] <= 0) {
	    $data['group_to_age'] = "null";
	}

	if (!isset($data['genre_id']) || $data['genre_id'] <= 0) {
	    $data['genre_id'] = "null";
	}

	//
	if ($data['group_type'] == $c_node['group_type']['closed']) {
	    $group_status = $c_node['group_status']['active'];
	}
	else {
	    $group_status = $c_node['group_status']['pending'];
	}

	//insert group
	$query = "
		INSERT INTO " . $db->prefix . "_group (
		group_title, group_synopsis, group_rules, language_id,
		group_create_datetime, group_type, group_from_age,
		group_to_age, genre_id, node_id, user_id, group_status
		) values (
		'" . $data['group_title'] . "',
		'" . $data['group_synopsis'] . "',
		'" . $data['group_rules'] . "',
		" . $data['language_id'] . ",
		" . $datetime . ",
		" . $data['group_type'] . ",
		" . $data['group_from_age'] . ",
		" . $data['group_to_age'] . ",
		" . $data['genre_id'] . ",
		" . $me['node_id'] . ",
		" . $me['user_id'] . ",
		" . $group_status . "
		)"
	;

	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else {
		//get the id
		$query = "
		SELECT group_id FROM " . $db->prefix . "_group WHERE
		user_id=" . $me['user_id'] . " and
		group_title='" . $data['group_title'] . "' and
		group_create_datetime=" . $datetime;

		$result = $db->Execute($query);
		if (!$result) {
			$error[]  = array('error', 1, $db->ErrorMsg());
		}
		else {
			$group_id = $result->fields['group_id'];
		}

	}

	//insert admin
	if (isset($group_id)) {
	    $query = "
			INSERT INTO " . $db->prefix . "_group_member (
			group_id, level_id, member_create_datetime, user_id, node_id
			) values (
			" . $group_id . ",
			" . $c_node['user_level_id']['group_administrator'] . ",
			" . $datetime . ",
			" . $me['user_id'] . ",
			" . $me['node_id'] . "
			)"
		;
		$result = $db->Execute($query);

		if (!$result) {
			$error[]  = array('error', 1, $db->ErrorMsg());
		}

	}

	//create image directory
	if (isset($group_id) && ($data['group_type'] == $c_node['group_type']['closed'])) {

		//setup the group
		require_once($c_node['class_dir'] . 'Group/Group.class.php');
		$group = new Group($group_id);
		$group->db= $db;
		$group->node_id = $me['node_id'];
		$group->ftp = $c_node['ftp'];
		$group->user_id = $me['user_id'];
		$group->default_library_title = $lang['txt_default_library_title'];
		$group->default_library_synopsis = $lang['txt_default_library_synopsis'];
		$group->default_library_body = $lang['txt_default_library_body'];
		$group->default_section_title = $lang['txt_default_section_title'];
		$group->default_library_page_name = $lang['txt_wiki_default'];
		$group_setup = $group->setupGroup($group_id);

	}

	//create message to sent to admin
	if (isset($group_id) && ($data['group_type'] == $c_node['group_type']['open'] || $data['group_type'] == $c_node['group_type']['registration_required'])) {

		//get text files
		$body_file_txt = readTxtFile($languageTextPath . "admin_group_create.txt.php");

		$body_file_txt = str_replace("\\\"", "\"", $body_file_txt);
		$body_file_txt = str_replace("ID_OF_GROUP", $group_id, $body_file_txt);
		$body_file_txt = str_replace("NOTE", $data['note'], $body_file_txt);


		//get node admins
		 $query = "
			SELECT user_id
			FROM " . $db->prefix . "_user
			WHERE
			level_id>=" . $c_node['user_level_id']['node_administrator']
		;
		$result = $db->Execute($query);

		if (isset($result)) {

			while (!$result->EOF) {
				//send mail to node admins
				$im->sendMessage($result->fields['user_id'], "group application", $body_file_txt);
				$result->MoveNext();
			}

			$result->Close();
		}
	}

	if (isset($group_id)) {
		return $group_id;
	}
} //EO insertGroup();

?>
