<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

$core = "my";
include "inc/header.inc.php";


//append language setup
require_once($languageArrayPath . 'arr_activity_user_status.lang.php');
require_once($languageArrayPath . 'arr_user_online_status.lang.php');
require_once($languageArrayPath . 'arr_user_relation.lang.php');


//get Library Items
$output_publish_library = getLibraryItems($user_id);

//get Forum subjects
$output_publish_forum = getSubjects($user_id);

//get Blog Items
$output_blogs = getBlogs($user_id);

//get Shouts
$output_shouts = getShouts($user_id);

//get poll participation
$output_poll_participation = getPollParticipation($user_id);

//move to template
if (isset($output_publish_library)) {
    $body->set('publish_library', $output_publish_library);
}

if (isset($output_blogs)) {
    $body->set('blogs', $output_blogs);
}

if (isset($output_publish_forum)) {
    $body->set('publish_forum', $output_publish_forum);
}

if (isset($output_shouts)) {
    $body->set('publish_shouts', $output_shouts);
}

if (isset($output_user)) {
    $body->set('user', $output_user);
}

if (isset($output_relationship)) {
    $body->set('relationship', $output_relationship);
}

if (isset($output_poll_participation)) {
    $body->set('poll_participation', $output_poll_participation);
}



$template_pageLink = $lang['txt_publishing'];
include "inc/footer.inc.php";


/*
* getLibraryItems
* Tom Calthrop 7th April 2004
*/
function getLibraryItems ($user_id) {

	global $db, $me, $image;

	$query = "
		SELECT l.library_title, l.library_synopsis, l.library_id,
		l.library_total_views, l.group_id, library_image_id
		FROM " . $db->prefix . "_group_library l
		where
		l.user_id=" . $user_id . "
		order by l.library_create_datetime desc"
	;

	$result = $db->SelectLimit($query, 5); //returns last 5 rows

	if (!$result) {
		print $db->ErrorMsg();
	}
	else if ($result) {

		$temp = array();

		while (!$result->EOF) {
			$temp1 = $result->fields;
			if ($temp1['library_image_id']) {
			    $temp1['image'] = $image->getImage($temp1['library_image_id'], 't2', 'group');
			}

			array_push($temp, $temp1);

			$result->MoveNext();
		}

		$result->Close();

		return $temp;
	}
}//EO getLibraryItems();


/*
* getSubjects
* Tom Calthrop 7th April 2004
*/
function getSubjects ($user_id) {

	global $db, $me;

	$query = "
		SELECT s.subject_id, s.subject_title, s.subject_body, se.group_id, t.topic_id
		FROM " . $db->prefix . "_forum_subject s
		LEFT JOIN " . $db->prefix . "_forum_topic t ON s.topic_id=t.topic_id
		LEFT JOIN " . $db->prefix . "_forum_section se ON t.section_id=se.section_id
		where
		s.user_id=" . $user_id . "
		order by s.subject_create_datetime desc"
	;

	$result = $db->SelectLimit($query, 5); //returns last 5 rows

	if (!$result) {
		print $db->ErrorMsg();
	}
	else if ($result) {

		$temp = array();

		while (!$result->EOF) {

			$temp1 = $result->fields;

			if ($result->fields['subject_id']) {
			    $query = "
					SELECT count(r.reply_id) as total_replies
					FROM " . $db->prefix . "_forum_reply r
					where
					r.subject_id=" . $result->fields['subject_id']
					;

				$result1 = $db->Execute($query);
				if (!$result1) {
					print $db->ErrorMsg();
				}
				else {
					$temp1['total_replies'] = $result1->fields['total_replies'];
				}
			}
			array_push($temp, $temp1);
			$result->MoveNext();
		}

		$result->Close();

		return $temp;
	}
}//EO getSubjects();


/*
* getBlogItems
* Tom Calthrop 7th April 2004
*/
function getBlogs ($user_id) {

	global $db, $date;

	$query = "
		SELECT b.blog_title, b.blog_synopsis, b.blog_create_datetime,
		b.blog_total_views, b.blog_id
		FROM " . $db->prefix . "_blog b
		where
		b.user_id=" . $user_id . "
		order by b.blog_create_datetime desc"
	;
	
	$result = $db->SelectLimit($query, 5); //returns last 5 rows

	if (!$result) {
		print $db->ErrorMsg();
	}
	else if ($result) {

		$temp = array();

		while (!$result->EOF) {

			$temp1 = $result->fields;

			$temp1['blog_create_datetime'] = $date->formatDate($temp1['blog_create_datetime']);

			array_push($temp, $temp1);
			$result->MoveNext();
		}

		$result->Close();

		return $temp;
	}
}//EO getBlogItems();


/*
* getShouts
* Tom Calthrop 7th April 2004
*/
function getShouts ($user_id) {

	global $db, $date;

	$query = "
		SELECT s.*
		FROM " . $db->prefix . "_shoutbox s
		WHERE
		s.user_id=" . $user_id . "
		order by s.shoutbox_create_datetime desc"
	;

	$result = $db->SelectLimit($query, 15); //returns last 15 rows

	if (!$result) {
		print $db->ErrorMsg();
	}
	else {

		$temp = array();

		while (!$result->EOF) {
			$temp1 = $result->fields;

			$temp1['shoutbox_create_datetime'] = $date->formatDate($temp1['shoutbox_create_datetime']);

			array_push($temp, $temp1);
			$result->MoveNext();
		}

		$result->Close();

		return $temp;
	}
}//EO getShouts();




/*
* getPollParticipation
* Tom Calthrop 14th May 2004
*/
function getPollParticipation ($user_id) {

	global $db, $date;

	$query = "
		SELECT p.poll_question, pa.answer_create_datetime, o.option_body
		FROM " . $db->prefix . "_poll p, " . $db->prefix . "_poll_option o, " . $db->prefix . "_poll_answer pa
		WHERE
		p.poll_id=o.poll_id and
		o.option_id=pa.option_id and
		pa.user_id=" . $user_id . " and
		pa.current_answer=1 and
		p.poll_anon is null
		order by pa.answer_create_datetime desc"
	;
	
	$result = $db->SelectLimit($query, 15); //returns last 25 rows

	if (!$result) {
		print $db->ErrorMsg();
	}
	else {

		$temp = array();

		while (!$result->EOF) {
			$temp1 = $result->fields;

			$temp1['answer_create_datetime'] = $date->formatDate($temp1['answer_create_datetime']);

			array_push($temp, $temp1);
			$result->MoveNext();
		}

		$result->Close();

		return $temp;
	}
}//EO getPollParticipation();

?>
