<?php
class Text_Wiki_Render_Xhtml_Shockwaveflash extends Text_Wiki_Render {

    var $conf = array(
        'base' => '/',
        'css'  => null,
        'css_link' => null
    );
    
    
    /**
    * 
    * Renders a token into text matching the requested format.
    * 
    * @access public
    * 
    * @param array $options The "options" portion of the token (second
    * element).
    * 
    * @return string The text rendered from the token options.
    * 
    */
    
    function token($options)
    {
        // note the image source
        $src = $options['src'];
          
        // is the source a local file or URL?
        if (strpos($src, '://') === false) {
            // the source refers to a local file.
            // add the URL base to it.
            $src = $this->getConf('base', '/') . $src;
        }
        
        // stephane@metacites.net
        // is the image clickable? 
        if (isset($options['attr']['link'])) {
            // yes, the image is clickable.
            // are we linked to a URL or a wiki page?
            if (strpos($options['attr']['link'], '://')) {
                // it's a URL
                $href = $options['attr']['link'];
            } else {
                // it's a WikiPage; assume it exists.
                /** @todo This needs to honor sprintf wikilinks (pmjones) */
                /** @todo This needs to honor interwiki (pmjones) */
                /** @todo This needs to honor freelinks (pmjones) */
                $href = $this->wiki->getRenderConf('xhtml', 'wikilink', 'view_url') .
                    $options['attr']['link'];
            }
        } else {
            // image is not clickable.
            $href = null;
        }
		
        // unset so it won't show up as an attribute
        unset($options['attr']['link']);
        
        
		if (empty($options['attr']['width'])) {
		    $options['attr']['width'] = "100%";
		}
		
		if (empty($options['attr']['height'])) {
		    $options['attr']['height'] = "100%";
		}
		
        // start the HTML output
        $output = '<img src="' . htmlspecialchars($src) . '"';
        
		$output = '
		<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" 
		codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=7,0,0,0" 
		 width="' . $options['attr']['width'] . '" height="' . $options['attr']['height'] . '">
		<param name="allowScriptAccess" value="sameDomain" />
		<param name="movie" value="' . htmlspecialchars($src) . '" />
		<param name="quality" value="high" />
		<param name="bgcolor" value="#ffffff" />
		<embed src="' . htmlspecialchars($src) . '"  width="' . $options['attr']['width'] . '" height="' . $options['attr']['height'] . '" 
		quality="high" allowScriptAccess="sameDomain" 
		type="application/x-shockwave-flash" pluginspage="http://www.macromedia.com/go/getflashplayer" />
		';
		
        
        // was the image clickable?
        if ($href) {
            // yes, add the href and return
            $href = htmlspecialchars($href);
            $output = "<a href=\"$href\">$output</a>";
        }
        return $output;
    }
}
?>