<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------



class Group {
	// CLASS FUNCTIONS
	// Group
	// getGroup
	// getMembers
	// getGroupMembership
	// getGroups
	// getMyGroups
	// updateGroup
	// getCountMembers
	// updateMembership
	// insertMembership
	// deleteMembership
	// updateGroupRules
	// getMyGroupProfiles
	
	
	
	// Group --------------------------------------------------------------------
	// the constuctor
	// tom calthrop - 6th December 2004
	//
	function Group($db, $date, $file = null) {
		$this->db = $db;
		$this->date = $date;
		
		if (isset($file)) {
			$file->path = "group";
		    $this->file = $file;
		}
	}//EO Group


	
	// getGroup --------------------------------------------------------------------
	// returns a single group record
	// tom calthrop - 21st Feb 2004
	//
	function getGroup() {
		$query = "
			SELECT g.*
			FROM " . $this->db->prefix . "_group g
			where
			g.group_id=" . $this->group_id
		;
		
		$result = $this->db->Execute($query);
	
		if (isset($result->fields['group_id'])) {
			$temp = $result->fields;
			$temp['display_group_create_datetime'] = $this->date->formatDate($temp['group_create_datetime']);
			$temp['display_group_election_date'] = $this->date->formatDate($temp['group_election_date']);
			$temp['display_group_rules'] = nl2br($temp['group_rules']);
			$temp['display_group_synopsis'] = nl2br($temp['group_synopsis']);
			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=getGroup class=Group.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO getGroup

	
	
	// getMembers --------------------------------------------------------------------
	// returns the members of a group
	// tom calthrop - 21st Feb 2004
	//
	function getMembers() {

		$query = "
			SELECT u.user_id, p.profile_nic, u.user_hometown, u.user_create_datetime,
			u.active_time, gm.status_id, gm.role_id, gm.membership_create_datetime, 
			gm.membership_number 
			FROM " . $this->db->prefix . "_group_membership gm
			LEFT JOIN " . $this->db->prefix . "_user u ON gm.user_id=u.user_id 
			LEFT JOIN " . $this->db->prefix . "_user_profile p ON gm.profile_id=p.profile_id
			WHERE
			gm.group_id=" . $this->group_id . " and "
		;
		
		if (isset($this->status_id)) {
			$query .= "gm.status_id=" . $this->status_id . " and ";
		}
		
		if (isset($this->role_id)) {
			$query .= "gm.role_id=" . $this->role_id . " and ";
		}
		
		if (isset($this->role_ids)) {
			$mem_ids = "";
			foreach($this->role_ids as $key => $i):
				$mem_ids .= $i;
				if (count($this->role_ids) > $key+1) {
				    $mem_ids .=",";
				}
			endforeach;
			$query .= "gm.role_id in (" . $mem_ids . ") and ";
		}

		$query .= "1=1 order by p.profile_nic";
		
		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;

				$temp1['membership_create_datetime'] = $this->date->formatDate($temp1['membership_create_datetime']);
				$temp1['user_create_datetime'] = $this->date->formatDate($temp1['user_create_datetime']);

				array_push($temp, $temp1);

				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=getMembers class=Group.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	} //EO getMembers;
	
	
	
	// getGroupMembership --------------------------------------------------------------------
	// Get membership access information
	// tom calthrop - 21st Feb 2004
	//
	function getGroupMembership() {
		$query = "
			SELECT gm.status_id, gm.role_id, agr.role_name, gm.user_id, gm.profile_id, 
			gm.membership_create_datetime, gm.membership_number, u.active_time 
			FROM " . $this->db->prefix . "_group_membership gm 
			LEFT JOIN " . $this->db->prefix . "_acs_group_role agr ON gm.role_id=agr.role_id 
			LEFT JOIN " . $this->db->prefix . "_user u ON gm.user_id=u.user_id 
			where
			gm.group_id=" . $this->group_id . " and
			gm.user_id=" . $this->user_id
		;
		
		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
			$temp = $result->fields;
			$temp['membership_create_datetime'] = $this->date->formatDate($temp['membership_create_datetime'],1);
			
			return $temp;
			
		}
	}//EO getGroupMembership



	// getGroups --------------------------------------------------------------------
	// returns multiple rows of groups
	// tom calthrop - 21st Feb 2004
	//
	function getGroups($search = null) {
		
		$query = "
			SELECT g.group_id, g.group_title, g.group_synopsis, g.genre_id,
			g.file_id, g.group_from_age, g.group_to_age, g.group_create_datetime 
			FROM " . $this->db->prefix . "_group g 
			WHERE 
			group_registration_type!=" . $this->registration_types['closed'] . " and 
			g.group_visibility=" . $this->group_visibility
		;
		
		if (isset($search)) {
		    $query .= " 
				and 
				(g.group_title like '%" . $search . "%' or
				g.group_synopsis like '%" . $search . "%')"
			;
		}
		
		if (isset($this->genre_id) && $this->genre_id > 0) {
			$query .= " and g.genre_id=" . $this->genre_id;
		}

		if (isset($search)) {
			$query .= " order by g.group_title";
		} else {
			$query .= " order by g.group_create_datetime desc";
		}
		
		if (isset($this->limit)) {
			$result = $this->db->SelectLimit($query, $this->limit);
		} else {
			$result = $this->db->Execute($query);
		}
		//echo $query . "<br><br>";
			
		if (isset($result->fields)) {

			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				
				if (isset($this->file)) {
					if (isset($temp1['file_id'])) {
						$this->file->file_id = $temp1['file_id'];
						$temp1['image'] = $this->file->getFileRecord();
					}
					else {
						$temp1['image']['file_title'] = "";
						$temp1['image']['file'] = $this->file->noimage;
					}
				}
				
				//format search results
				if (isset($search)) {
					$temp1['group_synopsis'] = searchTextFormat($search, $temp1['group_synopsis']);
					$temp1['group_title'] = searchTextFormat($search, $temp1['group_title']);
				}
				
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=getGroups class=Group.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO getGroups;

	
	
	// getMyGroups --------------------------------------------------------------------
	// returns multiple rows of groups that I have membership of
	// tom calthrop - 21st Feb 2004
	//
	function getMyGroups() {
		$query = "
			SELECT g.group_id, g.group_title, g.group_synopsis, g.genre_id,
			g.file_id, g.group_from_age, g.group_to_age, g.group_create_datetime 
			FROM " . $this->db->prefix . "_group_membership gm
			RIGHT JOIN " . $this->db->prefix . "_group g on g.group_id=gm.group_id
			WHERE
			gm.user_id =" . $this->user_id . " 
			order by g.group_title"
		;
		
		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
	
			$temp = array();
	
			while (!$result->EOF) {
				$temp1 = $result->fields;
					
				if (isset($this->file)) {
					if (isset($temp1['file_id'])) {
						$this->file->file_id = $temp1['file_id'];
						$temp1['image'] = $this->file->getFileRecord();
					}
					else {
						$temp1['image']['file_title'] = "";
						$temp1['image']['file'] = $this->file->noimage;
					}
				}
	
				array_push($temp, $temp1);
				$result->MoveNext();
			}
			$result->Close();
			return $temp;
			
		}
		else {
			$error_info = "function=getMyGroups class=Group.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO getMyGroups
	
	
	
	// updateGroup --------------------------------------------------------------------
	// get the bookmarks for the group
	// tom calthrop - 6th December 2004
	//
	function updateGroup($data) {
	
		if ($data['group_from_age'] <= 0) {
		    $data['group_from_age'] = "null";
		}
	
		if ($data['group_to_age'] <= 0) {
		    $data['group_to_age'] = "null";
		}
		
		if ($data['genre_id'] <= 0) {
		    $data['genre_id'] = "null";
		}
	
		//update group
		$query = "
			UPDATE " . $this->db->prefix . "_group SET
			group_title='" . $data['group_title'] . "',
			group_synopsis='" . $data['group_synopsis'] . "',
			group_home_synopsis='" . $data['group_home_synopsis'] . "',
			language_id=" . $data['language_id'] . ",
			group_registration_type=" . $data['group_registration_type'] . ",
			group_from_age=" . $data['group_from_age'] . ",
			group_to_age=" . $data['group_to_age'] . ",
			genre_id=" . $data['genre_id'] . " 
			WHERE group_id=" . $this->group_id
		;
		
		$result = $this->db->Execute($query);
	
		if (empty($result)) {
			$error_info = "function=updateGroup class=Group.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	
	} //EO updateGroup();

	
	
	// getCountMembers --------------------------------------------------------------------
	// returns the count of group members of a role
	// tom calthrop - 21st Feb 2004
	//
	function getCountMembers() {

		$query = "
			SELECT count(user_id) as total 
			FROM " . $this->db->prefix . "_group_membership 
			WHERE
			group_id=" . $this->group_id . " and "
		;
		
		if (isset($this->role_id)) {
			$query .= "role_id=" . $this->role_id .  " and ";
		}

		if (isset($this->member_status_id)) {
			$query .= "status_id=" . $this->member_status_id .  " and ";
		}
		
		$query .= "1=1";
		
		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
			$temp = $result->fields;
			$result->Close();
			return $temp['total'];
		}
		else {
			$error_info = "function=getCountMembers class=Group.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	} //EO getCountMembers
	
	
	
	// updateMembership --------------------------------------------------------------------
	// update group member from g_member_profile.php
	// tom calthrop - 7th December 2004
	//
	function updateMembership($data) {
		
		if (empty($data['role_id'])) {
		    $data['role_id'] = "null";
		}
		
		if (empty($data['status_id'])) {
		    $data['status_id'] = "null";
		}
		
		$query = "
			UPDATE " . $this->db->prefix . "_group_membership SET 
			role_id=" . $data['role_id'] . ", 
			status_id=" . $data['status_id'] . ", 
			membership_number='" . $data['membership_number'] . "', 
			profile_id='" . $data['profile_id'] . "' 
			WHERE
			group_id=" . $this->group_id . " and 
			user_id=" . $this->user_id
		;
		
		$result = $this->db->Execute($query);
			
		if (empty($result)) {
			$error_info = "function=updateMembership class=Group.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	} //EO updateMembership
	
	
	
	// insertMembership --------------------------------------------------------------------
	// insert group membership
	// tom calthrop - 20th December 2004
	//
	function insertMembership($profile_id, $role_id) {
	
		$datetime = date("Y-m-d H:i:s");
		$datetime = $this->db->DBDate($datetime);
		
		if (empty($profile_id)) {
		    $profile_id = "null";
		}
		
		$query = "
			INSERT INTO " . $this->db->prefix . "_group_membership (
			group_id, 
			status_id, 
			role_id, 
			membership_create_datetime, 
			user_id, 
			profile_id, 
			node_id
			) VALUES ( 
			" . $this->group_id . ", 
			" . $this->member_status_id . ", 
			" . $role_id . ", 
			" . $datetime . ", 
			" . $this->user_id . ", 
			" . $profile_id . ", 
			" . $this->node_id . "
			)"
		;
		
		$result = $this->db->Execute($query);
			
		if (empty($result)) {
			$error_info = "function=insertMembership class=Group.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO insertMembership
	
	
	
	// deleteMembership --------------------------------------------------------------------
	// delete group member from g_member_profile.php
	// tom calthrop - 7th December 2004
	//
	function deleteMembership() {
		
		$query = "
			DELETE FROM " . $this->db->prefix . "_group_membership  
			WHERE
			group_id=" . $this->group_id . " and 
			user_id=" . $this->user_id
		;
		
		$result = $this->db->Execute($query);
			
		if (empty($result)) {
			$error_info = "function=deleteMembership class=Group.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	} //EO deleteMembership
	
	
	
	// updateGroupRules --------------------------------------------------------------------
	// get the rules for the group
	// tom calthrop - 6th December 2004
	//
	function updateGroupRules($data) {
	
		if (empty($data['group_rules'])) {
		    $data['group_rules'] = "null";
		}
	
		//update group
		$query = "
			UPDATE " . $this->db->prefix . "_group SET
			group_rules='" . $data['group_rules'] . "' 
			WHERE group_id=" . $this->group_id
		;
		
		$result = $this->db->Execute($query);
	
		if (empty($result)) {
			$error_info = "function=updateGroupRules class=Group.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	
	} //EO updateGroupRules();

	
	
	// getMyGroupProfiles --------------------------------------------------------------------
	// returns group profiles that I have used in my membership
	// tom calthrop - 29th December 2004
	//
	function getMyGroupProfiles($profile_id = null) {
		$query = "
			SELECT g.group_id, g.group_title, gm.profile_id, p.profile_nic, p.profile_name 
			FROM " . $this->db->prefix . "_group_membership gm
			RIGHT JOIN " . $this->db->prefix . "_group g on g.group_id=gm.group_id 
			LEFT JOIN " . $this->db->prefix . "_user_profile p ON gm.profile_id=p.profile_id
			WHERE
			gm.user_id =" . $this->user_id . " AND "
		;
		
		if (isset($profile_id)) {
		    $query .= "gm.profile_id =" . $profile_id . " AND ";
		}
		
		$query .= "1=1 order by g.group_title";
		
		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
	
			$temp = array();
	
			while (!$result->EOF) {
				$temp1 = $result->fields;
	
				array_push($temp, $temp1);
				$result->MoveNext();
			}
			$result->Close();
			return $temp;
			
		}
		else {
			$error_info = "function=getMyGroupProfiles class=Group.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO getMyGroupProfiles
}

?>
