<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------



class Library {
	// CLASS FUNCTIONS
	// Library
	// getLibraryItems
	// getPages
	// getPageName
	// getPageID
	// getPageDefault
	// getHistory
	// getContents
	// insertLibrary
	// getLibraryItemCount



	// Library --------------------------------------------------------------------
	// the constuctor
	// tom calthrop - 18th May 2004
	//
	function Library($db, $section_id, $date, $file = null) {
		$this->db = $db;
		$this->section_id = $section_id;
		$this->date = $date;

		if (isset($file)) {
		    $this->file = $file;
		}
	}//EO Library



	// getPages --------------------------------------------------------------------
	// used to list the page_names held in this library
	// tom calthrop - 18th May 2004
	//
	function getPages () {

	    $query = "
			SELECT DISTINCT library_page_name
			FROM " . $this->db->prefix . "_library
			WHERE
			section_id=" . $this->section_id . " and
			section_item_id=" . $this->section_item_id . "
			order by library_page_name"
		;


		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields['library_page_name'];
				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=getPages class=Library.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO getPages();



	// getLibraryItems --------------------------------------------------------------------
	// get the library items for given ids
	// tom calthrop - 10th December 2004
	//
	function getLibraryItems($search = null) {

	    $query = "
			SELECT library_id, library_page_name, library_title, library_synopsis,
			file_id, section_item_id, library_allow_comments, library_create_datetime,
			section_id
			FROM " . $this->db->prefix . "_library
			WHERE "
		;

		if (isset($this->section_id)) {
		    $query .= "section_id=" . $this->section_id . " AND ";
		}

		if (isset($this->section_item_id)) {
			$query .= "section_item_id=" . $this->section_item_id . " and ";
		}

		if (isset($this->level_id)) {
			$query .= "level_id=" . $this->level_id . " and ";
		}

		if (isset($this->degree_id)) {
			$query .= "degree_id>=" . $this->degree_id . " and ";
		}

		if (isset($this->user_id)) {
			$query .= "user_id=" . $this->user_id . " and ";
		}

		if (isset($this->library_item_ids)) {
			$library_item_ids = "";
			foreach($this->library_item_ids as $key => $i):
				$library_item_ids .= $i;
				if (count($this->library_item_ids) > $key+1) {
				    $library_item_ids .=",";
				}
			endforeach;
			$query .="library_id in (" . $library_item_ids . ") and ";
		}

		if (isset($search)) {
			$query .= "
				(
				library_title like '%" . $search . "%' or
				library_synopsis like '%" . $search . "%' or
				library_body like '%" . $search . "%'
				) and "
			;
		}

		$query .= "1=1 order by library_page_name";

		if (isset($this->limit)) {
			$result = $this->db->SelectLimit($query, $this->limit);
		} else {
			$result = $this->db->Execute($query);
		}

		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;

				if (isset($this->file)) {
					if ($temp1['section_id'] == 1) {
					    $this->file->path = "user";
					}
					elseif ($temp1['section_id'] == 2) {
					    $this->file->path = "group";
					}

					if (isset($temp1['file_id'])) {
						$this->file->file_id = $temp1['file_id'];
						$temp1['image'] = $this->file->getFileRecord();
					}
					else {
						$temp1['image']['file_title'] = "";
						$temp1['image']['file'] = $this->file->noimage;
					}
				}

				$temp1['library_create_datetime'] = $this->date->formatDate($temp1['library_create_datetime'], 1);

				//format search results
				if (isset($search)) {
					$temp1['library_synopsis'] = searchTextFormat($search, $temp1['library_synopsis']);
					$temp1['library_title'] = searchTextFormat($search, $temp1['library_title']);
				}

				array_push($temp, $temp1);
				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=getLibraryItems class=Library.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO getLibraryItems



	// getPageName --------------------------------------------------------------------
	// will get the newest page for $library_page_name
	// tom calthrop - 18th May 2004
	//
	function getPageName($library_page_name) {
		$query = "
			SELECT *
			FROM " . $this->db->prefix . "_library
			WHERE
			section_id=" . $this->section_id . " and
			section_item_id=" . $this->section_item_id . " and
			library_page_name='" . $library_page_name . "'
			order by library_create_datetime desc"
		;

		$result = $this->db->SelectLimit($query, 1);

		if (isset($result->fields)) {
			$temp = $result->fields;
			//$temp['display_library_create_datetime'] = $this->date->formatDate($temp['library_create_datetime'], 1);
			return $temp;
		}
		else {
			$error_info = "function=getPageName class=Library.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}

	}//EO getPageName



	// getPageID --------------------------------------------------------------------
	// will get the newest page for $library_page_name
	// tom calthrop - 18th May 2004
	//
	function getPageID($library_id=null) {

		if (empty($library_id)) {
		    $library_id = $this->library_id;
		}

		$query = "
			SELECT *
			FROM " . $this->db->prefix . "_library
			WHERE
			library_id=" . $library_id;

		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$temp = $result->fields;
			return $temp;
		}
		else {
			$error_info = "function=getPageID class=Library.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}

	}//EO getPageID



	// getPageDefault --------------------------------------------------------------------
	// will get the default page for the library
	// tom calthrop - 18th May 2004
	//
	function getPageDefault() {
		$query = "
			SELECT *
			FROM " . $this->db->prefix . "_library
			WHERE
			section_id=" . $this->section_id . " and
			section_item_id=" . $this->section_item_id . " and
			library_default > 0 AND "
		;

		if (isset($this->level_id)) {
			$query .= "level_id=" . $this->level_id . " and ";
		}

		if (isset($this->degree_id)) {
			$query .= "(degree_id>=" . $this->degree_id . " or degree_id is null) and ";
		}

		$query .= "1=1 order by library_create_datetime limit 1";

		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$temp = $result->fields;
			return $temp;
		}
		else {
			$error_info = "function=getPageDefault class=Library.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}

	}//EO getPageDefault



	// getHistory --------------------------------------------------------------------
	// used to list the pages in the library item history
	// tom calthrop - 18th May 2004
	//
	function getHistory($history_library_id) {

		//we retrieve the pagename
		$temp = $this->getPageID($history_library_id);
		$pagename = $temp['library_page_name'];

		if (!empty($pagename)) {
			$query = "
				SELECT l.library_id, l.library_title, l.library_create_datetime, l.user_id,
				p.profile_nic
				FROM " . $this->db->prefix . "_library l
				LEFT JOIN " . $this->db->prefix . "_user_profile p ON l.user_id=p.user_id
				WHERE
				p.profile_default=1 AND
				section_id=" . $this->section_id . " and
				section_item_id=" . $this->section_item_id . " and
				l.library_page_name='" . $pagename . "' AND "
			;

			if (isset($this->level_id)) {
				$query .= "level_id=" . $this->level_id . " and ";
			}

			if (isset($this->degree_id)) {
				$query .= "degree_id>=" . $this->degree_id . " and ";
			}

			$query .= "1=1 order by l.library_create_datetime desc";

			$result = $this->db->Execute($query);

			if (isset($result->fields)) {
				$temp = array();

				while (!$result->EOF) {
					$temp1 = $result->fields;
					$temp1['display_library_create_datetime'] = $this->date->formatDate($temp1['library_create_datetime'], 1);
					array_push($temp, $temp1);
					$result->MoveNext();
				}

				$result->Close();
				return $temp;
			}
			else {
				$error_info = "function=getHistory class=Library.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
			}
		}
	}//EO getHistory



	// getContents --------------------------------------------------------------------
	// used to list the library contents
	// tom calthrop - 18th May 2004
	//
	function getContents() {
		//first we need to get the newest library_page_name id for each library_page_name
		$query = "
			SELECT library_page_name, library_id, library_create_datetime
			FROM " . $this->db->prefix . "_library
			WHERE
			section_id=" . $this->section_id . " and
			section_item_id=" . $this->section_item_id . " AND "
		;

		if (isset($this->level_id)) {
			$query .= "level_id=" . $this->level_id . " and ";
		}

		if (isset($this->degree_id)) {
			$query .= "degree_id>=" . $this->degree_id . " and ";
		}

		$query .= "1=1 order by library_page_name, library_create_datetime desc";

		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$ids = 0;
			$old_library_page_name = "";

			while (!$result->EOF) {

				if ($old_library_page_name <> $result->fields['library_page_name']) {
				    $ids .= "," . $result->fields['library_id'];
					$old_library_page_name = $result->fields['library_page_name'];
				}
				$result->MoveNext();
			}

			$result->Close();

			//now we get the contents for the selected ids
			if (!empty($ids)) {
				$query = "
					SELECT l.library_id, l.library_title, l.library_create_datetime, l.user_id,
					p.profile_nic, l.library_default, l.library_synopsis, l.level_id,
					l.library_default
					FROM " . $this->db->prefix . "_library l
					LEFT JOIN " . $this->db->prefix . "_user_profile p ON l.user_id=p.user_id
					WHERE
					p.profile_default=1 AND
					l.section_id=" . $this->section_id . " and
					l.section_item_id=" . $this->section_item_id . " and "
				;

				if (isset($this->level_id)) {
					$query .= "level_id=" . $this->level_id . " and ";
				}

				if (isset($this->degree_id)) {
					$query .= "degree_id>=" . $this->degree_id . " and ";
				}

				$query .= "
					l.library_id in (" . $ids . ")
					order by l.library_default, l.library_title"
				;

				$result = $this->db->Execute($query);

				if (isset($result->fields)) {
					$temp = array();

					while (!$result->EOF) {
						$temp1 = $result->fields;
						$temp1['display_library_create_datetime'] = $this->date->formatDate($temp1['library_create_datetime'], 1);

						array_push($temp, $temp1);
						$result->MoveNext();
					}

					$result->Close();
					return $temp;
				}
				else {
					$error_info = "function=getContents class=Library.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
					$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
				}
			}
		}
		else {
			$error_info = "function=getContents class=Library.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}


	}//EO getContents



	// insertLibrary --------------------------------------------------------------------
	// This function is only used for group libraries (no user library search query required)
	// tom calthrop - 18th May 2004
	//
	function insertLibrary($data) {

		if(empty($data['library_title'])) {
			$GLOBALS['am_error_log'][] = array(11, null, null);
		}

		if(empty($data['library_body'])) {
			$GLOBALS['am_error_log'][] = array(12, null, null);
		}

		if(empty($data['library_synopsis'])) {
			$GLOBALS['am_error_log'][] = array(13, null, null);
		}

		if (empty($GLOBALS['am_error_log'])) {

			$datetime = date("Y-m-d H:i:s");
			$datetime = $this->db->DBDate($datetime);

			if (!isset($data['file_id']) || $data['file_id'] < 1) {
			    $data['file_id'] = "null";
			}

			if (!isset($data['level_id']) || $data['level_id'] < 1) {
			    $data['level_id'] = "null";
			}

			if (empty($data['library_allow_comments'])) {
			    $data['library_allow_comments'] = "null";
			}

			if (empty($data['degree_id'])) {
			    $data['degree_id'] = "null";
			}

			if (isset($data['library_default']) && $data['library_default'] > 0) {
			    //we clear out all old default pages
				$query = "
					UPDATE " . $this->db->prefix . "_library SET
					library_default = null
					WHERE
					section_id=" . $this->section_id . " AND
					section_item_id=" . $this->section_item_id
				;

				$result = $this->db->Execute($query);

			}
			else {
				$data['library_default'] = "null";
			}


			//stops sql errors when backslashes are removed - \"
			$data['library_title'] = str_replace("'", "\'", $data['library_title']);
			$data['library_synopsis'] = str_replace("'", "\'", $data['library_synopsis']);
			$data['library_body'] = str_replace("'", "\'", $data['library_body']);
			
			$query = "
				INSERT INTO " . $this->db->prefix . "_library (
				section_id,
				section_item_id,
				library_title,
				library_synopsis,
				library_body,
				file_id,
				library_page_name,
				user_id,
				level_id,
				degree_id,
				library_create_datetime,
				library_allow_comments,
				library_default
				) VALUES (
				'" . $this->section_id . "',
				'" . $this->section_item_id . "',
				'" . $data['library_title'] . "',
				'" . $data['library_synopsis'] . "',
				'" . $data['library_body'] . "',
				" . $data['file_id'] . ",
				'" . $data['library_page_name'] . "',
				" . $this->user_id . ",
				" . $data['level_id'] . ",
				" . $data['degree_id'] . ",
				" . $datetime . ",
				" . $data['library_allow_comments'] . ",
				" . $data['library_default'] . "
				)"
			;

			$result = $this->db->Execute($query);

			if (isset($result->fields)) {
				$query = "
					SELECT library_id
					FROM " . $this->db->prefix . "_library
					WHERE
					section_id=" . $this->section_id . " AND
					section_item_id=" . $this->section_item_id . " AND
					library_create_datetime=" . $datetime
				;

				$result = $this->db->SelectLimit($query, 1);

				if (isset($result->fields['library_id'])) {
					$this->library_id = $result->fields['library_id'];
				}
				else {
					$error_info = "function=insertLibrary class=Library.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
					$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
				}
			}
			else {
				$error_info = "function=insertLibrary class=Library.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
			}
		}
	} //EO insertLibrary




	// getLibraryItemCount --------------------------------------------------------------------
	// will get the coutn of unique page names
	// tom calthrop - 27th December 2004
	//
	function getLibraryItemCount() {
		$query = "
			SELECT DISTINCT library_page_name as total
			FROM " . $this->db->prefix . "_library
			WHERE
			section_id=" . $this->section_id . " and
			section_item_id=" . $this->section_item_id
		;

		$result = $this->db->Execute($query);

		if (isset($result->fields['total'])) {
			return $result->fields['total'];
		}
		else {
			$error_info = "function=getLibraryItemCount class=Library.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}

	}//EO getLibraryItemCount


}
?>
