<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header.inc.php";
$menu_section = "group"; //sets menu in default template


//append language setup
require_once($languageArrayPath . 'arr_group.lang.php');


if (isset($_REQUEST['user_id'])) {
	$user_id = $_REQUEST['user_id'];
}
else {
	$user_id = $me['user_id'];
}


//check received vars
if (isset($_REQUEST['group_id'])) {
	$group_id = $_REQUEST['group_id'];
}
elseif ($page_name[0] != "g_groups" && $page_name[0] != "g_group_create") {
	header("Location: g_groups.php?" . SID);
	exit;
}


//setup file
require_once($c_node['dir']['class_path'] . 'File.class.php');
$file = new File($db, $c_acs['arr_section']['group'], $c_node['file'], $c_node['dir']);
$file->path = "group";


	
//get group details
require_once($c_node['dir']['class_path'] . 'Group.class.php');
$group = new Group($db, $date, $file);
$group->user_id = $me['user_id'];
$group->registration_types = $c_node['group']['registration_type'];


if (isset($group_id)) {
	$file->section_item_id = $group_id;
	$group->group_id = $group_id;
	$output_group = $group->getGroup();
	
	if (empty($output_group['group_id'])) {
		header("Location: g_groups.php?" . SID);
		exit;
	}
	
	
	//is the group status active
	if ($page_name[0] != "g_apply" && ($output_group['status_id'] != $c_node['group']['status']['active'])) {
		header("Location: g_apply.php?group_id=" . $group_id . "&" . SID);
		exit;
	}
	
	$output_group['member'] = $group->getGroupMembership();
	
	if ($page_name[0] != "g_apply" && (empty($output_group['member']['status_id']) || $output_group['member']['status_id'] != $c_node['group']['member_status']['active'])) {
		header("Location: g_apply.php?group_id=" . $group_id . "&" . SID);
		exit;
	}
	
	//setup acs
	$group_acs = new Acs(null, $db, $c_acs['arr_section']['group']);
	$group_acs->group_id = $group_id;
	
	if (isset($output_group['member']['role_id'])) {
	    $group_acs->role_id = $output_group['member']['role_id'];
	}
}

?>
