<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_my.inc.php";
$menu_section = "message";

require_once($c_node['dir']['class_path'] . 'Wiki/Wiki.php');


// Setting statistics
$im->setStatistics();
$output_message_statistics = $im->getStatistics();


//setup Wiki
$wiki =& new Text_Wiki();
$wiki->disableRule('freelink');
$wiki->disableRule('wikilink');
$wiki->setRenderConf('xhtml', 'image', 'base', $c_node['dir']['asset_path'] . 'user/');



// Handling the message choices
if (!isset($_REQUEST['message_id'])) {
	header("Location: msg_list.php?". $_SERVER["QUERY_STRING"] . "&" . SID);
	exit;
}
else {
	if (isset($_POST['delete_messages'])) {
		$im->deleteMessages(array($_POST['message_id']));
		header("Location: msg_list.php?". $_SERVER["QUERY_STRING"] . "&" . SID);
		exit;
	}
	elseif (isset($_REQUEST['reply'])) {
		header("Location: msg_compose.php?reply=1&message_id=" . $_REQUEST['message_id'] . "&" . SID);
		exit;
	}
	else
	{

		$message = new Message($db, $_REQUEST['message_id']); // create message

		// Getting the status from "query_string"....
		if (isset($_REQUEST['set_unread_messages'])) {
			$status = $c_node['messaging']['message_status_unread'];
		}
		else {
			$status = $c_node['messaging']['message_status_read'];
		}
		$message->user_id = $user_id;

		$message->setStatus($status);                    // set status of the message
		$message->setBoxes($c_node['messaging']['message_in_box'], $c_node['messaging']['message_save_box'], $c_node['messaging']['message_out_box']);
		$output_message = $message->getMessage();        // get message

		$output_message['message_body'] = $wiki->transform($output_message['message_body'], 'Xhtml');
		
		//setup file
		$file->noimage = $c_node['file']['image']['thumb'][1]['noimage'];
		$file->thumb = $c_node['file']['image']['thumb'][1]['name'];
		
		//setup file
		if (isset($output_message['file_id'])) {
			$file->file_id = $output_message['file_id'];
			$output_message['image'] = $file->getFileRecord();
		}
		elseif (isset($output_profile)) {
			$output_message['image']['file_title'] = "";
			$output_message['image']['file'] = $file->noimage;
		}
		
		//if the messge type = 2 then we rebuid the social network as a friend has joined you
		if (isset($output_message['message_type']) && $output_message['message_type'] == 2) {
		    //setup social network
			require_once($c_node['dir']['class_path'] . 'SocialNetwork.class.php');
			$sn = new Socialnetwork($me['user_id'], $db, $c_node['node']['node_id'], $c_node['sn']['max_degree']);
			$sn->relation_type_ids = $c_node['user']['relation_type'];
			$sn->status_ids = $c_node['user']['status'];
			$_SESSION['s_social_network'] = $sn->createNetwork();
			$sn->updateSnStatistics();
		}
		
	}
}

//move to template
if (isset($output_message)) {
    $body->set('message', $output_message);
}

if(isset($output_message["message_box"])) {
	$body->set('message_box', $message->getMessageBox($output_message["message_box"]) );
}




$body->set('message_statistics', $output_message_statistics);
$body->set('message_status_read', $c_node['messaging']['message_status_read']);
$body->set('message_status_unread', $c_node['messaging']['message_status_unread']);

$template_pageLink = "message";
include "inc/footer.inc.php";

?>
