<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

/*
formatFileOutput
formats the html for a file
style = thumbnail image or link
tom calthrop
6th December 2004
*/
function formatFileOutput($arr_file, $style = null) {

	global $template_path, $c_node;

	if ($arr_file['file_suffix'] == "jpg" || $arr_file['file_suffix'] == "gif" || $arr_file['file_suffix'] == "png") {
		echo "<img src=\"get_file.php?file="  . $arr_file['file'] . "\" border=\"0\" class=\"picture\">";

	}
	elseif ($arr_file['file_suffix'] == "pdf") {
		echo "<img src=\"" . $template_path . "img/file_pdf.png\" border=\"0\">";
	}
	elseif ($arr_file['file_suffix'] == "txt") {
		echo "<img src=\"" . $template_path . "img/file_txt.png\" border=\"0\">";
	}
}


/*
* Trim
* tom calthrop
* 10th Jan 2004
*/
function dots($num, $string) {
	if (strlen($string) > $num) {
		$string = substr_replace($string, '...', $num);
	}
	return $string;
}


/*
* Read file from hard disk and return
* tom calthrop
* 22nd April 2004
*/
function readTxtFile($source) {

	$handle = fopen($source, "rb");
	$output = "";
	do {
	   $data = fread($handle, 8192);
	   if (strlen($data) == 0) {
	       break;
	   }
	   $output .= $data;
	} while (true);

	fclose($handle);

	$output = addslashes($output);

	return $output;
}




/*
* searchTextFormat
* takes a search string, highlights it in the supplied txt
* and strips unwanted data
*
* tom calthrop
* 10th April 2004
*/
function searchTextFormat($search, $txt) {

	//remove all html
	$pattern = array ("'<script[^>]*?>.*?</script>'si",  // Strip out javascript
		"'<[\/\!]*?[^<>]*?>'si",          // Strip out HTML tags
       	"'([\r\n])[\s]+'",                // Strip out white space
       	"'&(quot|#34);'i"                // Replace HTML entities
	);

	$replace = array ("",
       	"",
       	"\\1",
		"\""
	);

	$txt = preg_replace($pattern, $replace, $txt);

	//show 20 chars before first highlighted word
	$search_start_pos = (strlen($txt) - strlen(stristr($txt,$search))-20);

	if ($search_start_pos > 20) {
		$txt = substr($txt,$search_start_pos);
		$txt = "..." . $txt;
	}

	//reduce string length to 150 char
	if (strlen($txt) > 150) {
		$txt = substr($txt,0, 160);
		$txt = $txt . "...";
	}

	//make the search word red
	$txt = preg_replace("/($search)/i","<span class='txt_search_highlight'>\\0</span>",$txt);

	return $txt;
}



/*
* compare
* general function for usort (used in SocialNetwork.class.php
* 8th January 2005
*/
function compare($a, $b) {

	if($a["degree"]==$b["degree"])
		return 0;
	elseif($a["degree"]<$b["degree"])
		return -1;
	else
		return 1;
}



/*
* writeLogFile
* writes output to a text file
*
* tom calthrop
* 14th June 2005
*/
function writeLogFile($content) {
	
	$content = "\n" . date("Y-m-d H:i:s") . "\t " . $content;
	
	$path = "log/";
	$filename = "am_" . date('Y_m_d') . ".txt";
	
	//open or make the file
	if(!$handle = fopen($path . $filename, 'a')) {
			$handle = fopen($path . $filename, 'x');
	}
	// Write to file.
	@fwrite($handle, $content);
	//close file
	@fclose($handle);
}

?>
