<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------
?>

<div class="col_main">
	<div class="box">
		<div class="box_top">
			<?php
			if (isset($newsletter)) {
				echo $this->date->formatDate($newsletter['message_create_datetime'], 1);
			}
			else {
				echo $lang['hdr_newsletters'];
			}
			?>
			<br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				if (isset($newsletter)) {
				?>
				<p class="txt_item_title">
					<?php echo $newsletter['message_subject'];?><br />
				</p>
				
				<p>
				<?php echo $newsletter['message_body'];?><br />
				</p>
				<?php
				}
				elseif (isset($newsletters)) { //list view
				?>
				
				<table width="100%" cellpadding="4" cellspacing="0" border="0">
					<?php
					$display_items = trimArray($newsletters);
					foreach($display_items as $key => $i):
					?>
					<tr>
						<td>
							<a href="nlt_view.php?message_id=<?php echo $i['message_id'];?>"><?php echo $i['message_subject'];?></a><br />
						</td>
						<td>
							<?php echo $i['message_status'];?><br />
						</td
					</tr>
					<?php
					endforeach;
					?>
				</table>
				<?php
				echo createArrayList($newsletters);
				?>
				<?php
				}
				else  { //error - no newsletters
					echo $lang['err_no_newsletters'] . "<br />";
				}?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>

<div class="col_side">
	<?php
	if (isset($group)) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_group'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<p>
					<?php echo $lang['txt_group_link'];?>: <a href="grp_view.php?group_id=<?php echo $group['group_id'];?>"><?php echo $group['group_title'];?></a><br />
				</p>
				
				<p>
					<?php echo $lang['txt_membership_status'];?>: <?php echo $group['member']['role_name'];?><br />
				</p>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
	
	<form action="nlt_view.php" method="post" name="frm_view" id="id_frm_view">
	<input type="hidden" name="message_id" value="<?php if(isset($newsletter['message_id'])) { echo $newsletter['message_id'];}?>" />
	<input type="hidden" name="group_id" value="<?php if(isset($group['group_id'])) { echo $group['group_id'];}?>" />
				
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_options'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				if (isset($group)) {
				?>
				<p>
					<b><?php echo $lang['txt_group_options'];?></b><br />
				</p>
				
				<p>
					<select name="group_options" class="options_select">
						<option selected="selected"> </option>
						<option value="grp_view"><?php echo $lang['txt_option_group'];?></option>
						<option value="grp_structure"><?php echo $lang['txt_option_structure'];?></option>
						<option value="grp_membership"><?php echo $lang['txt_option_membership'];?></option>
						<?php
						if ($this->group_acs->checkPermission($resource_ids['group']['administration'], $privilege_ids['allow_newsletter'])) { //resourece_id, Priv_id
						?>
						<option> </option>
						<option value="item_add"><?php echo $lang['txt_option_group_add'];?></option>
						<?php }?>
					</select>
					<input type="image" src="<?php echo $templatePath;?>img/go.png" value="option_action" class="go" /><br />
				</p>
				<?php }?>
				
				<p>
					<b><?php echo $lang['txt_my_options'];?></b><br />
				</p>
				
				<select name="options" class="options_select">
					<?php
					if (isset($newsletter)) {
					?>
					<option value="list" selected="selected"><?php echo $lang['txt_option_list'];?></option>
					<option value="item_edit"><?php echo $lang['txt_option_edit'];?></option>
					<option> </option>
					<?php }?>
					<option value="item_add"><?php echo $lang['txt_option_add'];?></option>
				</select>
				<input type="image" src="<?php echo $templatePath;?>img/go.png" name="option_action" value="1" class="go" /><br />
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	</form>
</div>
