<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "structure";
include "inc/header.inc.php";

if (!$user_acs->checkPermission($c_acs['arr_acs']['resource']['node']['administration'], $c_acs['arr_acs']['privilege']['allow_newsletter'])) { //resourece_id, Priv_id
	header("Location: " . $_SESSION['user_homepage'] . "?" . strip_tags(SID));
	exit;
}


//SETUP NEWSLETTER -------------------------------------------------------------
require_once('class/Newsletter.class.php');
$nl = new Newsletter($db, $c_node['newsletter']);
$nl->user_status_ids = $c_node['user']['status'];


if (isset($_REQUEST['group_id'])) {
	include_once ('inc/header_group.inc.php');
	require_once($languagePath . 'grp_common.lang.php');
	$nl->group_id = $_REQUEST['group_id'];
}


//SETUP WIKI -------------------------------------------------------------
require_once('class/Wiki/Wiki.php');
$wiki =& new Text_Wiki();
$wiki->disableRule('wikilink');

if (isset($frmdata['group_options'])) {
	if ($frmdata['group_options'] == "grp_view") {
		header("Location: grp_view.php?group_id=". $frmdata['group_id'] . "&" . strip_tags(SID));
		exit;
	}
	elseif ($frmdata['group_options'] == "grp_structure") {
		header("Location: grp_structure.php?group_id=". $frmdata['group_id'] . "&" . strip_tags(SID));
		exit;
	}
	elseif ($frmdata['group_options'] == "grp_membership") {
		header("Location: grp_membership.php?group_id=". $frmdata['group_id'] . "&" . strip_tags(SID));
		exit;
	}
	elseif ($frmdata['group_options'] == "item_add") {
		header("Location: nlt_edit.php?group_id=". $frmdata['group_id'] . "&" . strip_tags(SID));
		exit;
	}
}
elseif (isset($frmdata['options'])) {
	if ($frmdata['options'] == "list") {
		$output_newsletters = $nl->selNewsletters();
	}
	elseif ($frmdata['options'] == "item_edit") {
		//edit this item
		header("Location: nlt_edit.php?message_id=" . $frmdata['message_id'] . "&".SID);
		exit;
	}
	elseif ($frmdata['options'] == "item_add") {
		//add an item
		header("Location: nlt_edit.php?".SID);
		exit;
	}
}
elseif (!empty($_REQUEST['message_id'])) {
	$output_newsletter = $nl->selNewsletter($_REQUEST['message_id']);
	//wikify body
	$wiki_image_base = "get_file.php?file=";
	
	$wiki->setRenderConf('xhtml', 'image', 'base', $wiki_image_base);
	$output_newsletter['message_body'] = $wiki->transform($output_newsletter['message_body'], 'Xhtml');
	
}
else {
	$output_newsletters = $nl->selNewsletters();
}


//move to template
if (!empty($output_newsletter)) {
	$body->set('newsletter', $output_newsletter);
}

if (!empty($output_newsletters)) {
	$body->set('newsletters', $output_newsletters);
}

if (!empty($output_group)) {
	$body->set('group', $output_group);
}

include "inc/footer.inc.php";

?>
