<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//

// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------



class Newsletter {
	// CLASS FUNCTIONS
	// Newsletter
	// sendNewsletter
	// insertNewsletter
	// selNewsletter
	// selNewsletters
	
	
	
	// Newsletter ----------------------------------------------------------
	// the constuctor
	// tom calthrop - 8th June 2005
	//
	function Newsletter($db, $config_nlt=null) {
		$this->db = $db;
		$this->config_nlt = $config_nlt;
	}//EO Comment
	
	
	
	// insertNewsletter ----------------------------------------------------
	// inserts record into newsletter table
	// tom calthrop - 22nd May 2004
	//
	function insertNewsletter($data) {
		
		if (empty($data['item_id'])) {
			$data['item_id'] = "null";
		}
		
		if (empty($data['group_id'])) {
			$data['group_id'] = "null";
		}
		
		if (isset($_SESSION['s_user_id'])) {
			$user_id = $_SESSION['s_user_id'];
		}
		else {
			$user_id = "null";
		}
		
		if (isset($data['to_role_id']) && $data['to_role_id'] > 0) {
			$role_id = $data['to_role_id'];
		}
		else {
			$role_id = "null";
		}
		
		$rec = array();
		$rec['from_user_id'] = $user_id;
		$rec['to_type_id'] = $data['to_type_id'];
		$rec['message_subject'] = $data['subject'];
		$rec['message_body'] = $data['message'];
		$rec['message_create_datetime'] = time();
		$rec['item_id'] = $data['item_id'];
		$rec['group_id'] = $data['group_id'];
		$rec['role_id'] = $role_id;
		$rec['language_id'] = $data['language_id'];
		$rec['start_user_id'] = 0;
		$rec['message_status'] = 0;
		
		$table = $this->db->prefix . "_newsletter";
		
		$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
			$this->message_id = $this->db->Insert_ID();
		}
		else {
			$error_info = "function=insertNewsletter class=Newsletter.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, $error_info);
		}
	} // EO insertNewsletter
	
	
	// selNewsletter ----------------------------------------------------
	// selects a newsletter
	// tom calthrop - 22nd Oct 2005
	//
	function selNewsletter($newsletter_id) {
		
		$query = "
			SELECT * 
			FROM " . $this->db->prefix . "_newsletter 
			WHERE
			message_id=" . $newsletter_id
		;
		
		$result = $this->db->SelectLimit($query, 1); //returns last 1 rows
		
		if (isset($result->fields)) {
			$temp = $result->fields;
			
			$result->Close();

			return $temp;
		}
		else {
			$error_info = "function=selNewsletter class=Newsletter.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	} //EO selNewsletter()
	
	
	
	// selNewsletters ----------------------------------------------------
	// selects all newsletters
	// tom calthrop - 22nd Oct 2005
	//
	function selNewsletters() {
		
		$query = "
			SELECT * 
			FROM " . $this->db->prefix . "_newsletter"
		;
		
		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
			$temp = array();
			
			while (!$result->EOF) {
				
				$temp1 = $result->fields;

				array_push($temp, $temp1);

				$result->MoveNext();
			}
	
			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=selNewsletters class=Newsletter.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	} //EO selNewsletters()
	
}
?>
