<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------



class Tag {
	// CLASS FUNCTIONS
	// Tag
	// selTags
	// insertTags
	// deleteItemTags
	// deleteTags
	
	
	
	// Tag --------------------------------------------------------------------
	// the constuctor
	// tom calthrop - 23rd July 2005
	//
	function Tag($db, $rsp_item_type_id) {
		$this->db = $db;
		$this->rsp_item_type_id = $rsp_item_type_id;
	}//EO Tag

	
	
	// selTags --------------------------------------------------------------------
	// returns tag array
	// tom calthrop - 23rd July 2005
	//
	function selTags($inc_user=null, $network=null) {
		
		if (isset($inc_user)) {
			$query = "
				SELECT t.tag_body, t.user_id 
				FROM " . $this->db->prefix . "_tag t "
			;
		}
		else {
			$query = "
				SELECT DISTINCT t.tag_body 
				FROM " . $this->db->prefix . "_tag t "
			;
		}
		
		$query .= "WHERE ";
		
		if (isset($network)) {
			// we select all tags except for network which only returns my tags
			$query .= "t.rsp_item_type_id!=" . $this->rsp_item_type_id . " OR (t.rsp_item_type_id=" . $this->rsp_item_type_id . " AND user_id=" . $this->user_id . ") AND ";
		}
		else {
			if (isset($this->user_id)) {
				$query .= "t.user_id=" . $this->user_id . " AND ";
			}
			
			if (isset($this->group_id)) {
				$query .= "t.group_id=" . $this->group_id . " AND ";
			}
			
			if (isset($this->rsp_item_type_id)) {
				$query .= "t.rsp_item_type_id=" . $this->rsp_item_type_id . " AND ";
			}
			
			if (isset($this->item_id)) {
				$query .= "t.item_id=" . $this->item_id . " and ";
			}
			
			if (isset($this->item_name)) {
				$query .= "t.item_name like " . $this->db->qstr("%" . $this->item_name . "%", get_magic_quotes_gpc()) . " and ";
			}
		}
		
		if (isset($this->level_id)) {
			$query .= "t.level_id=" . $this->level_id . " and ";
		}
		else {
			$query .= "t.level_id is null and ";
		}
		
		$query .= "1=1 ";
		
		$query .= "order by t.tag_body";
		//echo $query;
		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				array_push($temp, $temp1);
				$result->MoveNext();
			}
			
			return $temp;
			
		}
		else {
			$error_info = "function=selTags class=Tag.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
		}
	}//EO selTags
	
	
	
	// insertTags --------------------------------------------------------------------
	// inserts tags
	// tom calthrop - 23rd July 2005
	//
	function insertTags($data) {
		
		$ins_arr = explode(',', $data['tags']);
		
		$ins_arr = array_unique($ins_arr); //remove duplicates
		
		$rownums = count($ins_arr);

		for ($i=0; $i < $rownums; $i++) {
			
			$tag = trim($ins_arr[$i]);
			
			if (!empty($tag)) {
				
				$rec = array();
				$rec['tag_body'] = $tag;
				$rec['user_id'] = $this->user_id;
				$rec['rsp_item_type_id'] = $this->rsp_item_type_id;
				
				if (isset($data['item_id'])) {
					$rec['item_id'] = $data['item_id'];
				}
				
				if (isset($data['group_id'])) {
					$rec['group_id'] = $data['group_id'];
				}
				
				if (isset($data['item_name'])) {
					$rec['item_name'] = $data['item_name'];
				}
				
				if (isset($this->level_id)) {
					$rec['level_id'] = $this->level_id;
				}
				
				$table = $this->db->prefix . "_tag";
				
				$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
				//echo $query;
				$result = $this->db->Execute($query);
			
				if (empty($result)) {
					$error_info = "function=insertTags class=Tag.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
					$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
				}
			}
		}
	}//EO insertTags
	
	
	// deleteItemTags -----------------------------------------------------------
	// deletes tags- we delete tags against a particular item
	// tom calthrop - 23rd July 2005
	//
	function deleteItemTags($data=null) {
		
		if (isset($data['item_id']) || isset($data['item_name'])) {
			$query = "
				DELETE FROM " . $this->db->prefix . "_tag 
				WHERE
				rsp_item_type_id=" . $this->rsp_item_type_id . " AND "
			;
			
			if (isset($data['item_id'])) {
				$query .= "item_id=" . $data['item_id'] . " AND ";
			}
			
			if (isset($data['group_id'])) {
				$query .= "group_id=" . $data['group_id'] . " AND ";
			}
			
			if (isset($data['item_name'])) {
				$query .= "item_name=" . $this->db->qstr($data['item_name'], get_magic_quotes_gpc()) . " AND ";
			}
			
			$query .= "user_id=" . $this->user_id;
			$result = $this->db->Execute($query);
			
			if (empty($result)) {
				$error_info = "function=deleteItemTags class=Tag.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
			}
		}
	} //EO deleteItemTags



	// deleteTags --------------------------------------------------------------------
	// deletes a  bookmark
	// tom calthrop - 3rd December 2005
	//
	function deleteTags($del_arr = null) {
		if (isset($del_arr)) {
			$rownums = count($del_arr);

			for ($i=0; $i < $rownums; $i++) {
				$query = "
					DELETE FROM " . $this->db->prefix . "_tag 
					WHERE "
				;
				
				if (isset($this->user_id)) {
					$query .= "user_id=" . $this->user_id . " AND ";
				}
				
				if (isset($data['group_id'])) {
					$query .= "group_id=" . $data['group_id'] . " AND ";
				}
				
				if (isset($this->level_id)) {
					$query .= "level_id=" . $this->level_id . " AND ";
				}
				else {
					$query .= "level_id is null AND ";
				}
				
				$query .= "tag_body=" . $this->db->qstr($del_arr[$i], get_magic_quotes_gpc());
				$result = $this->db->Execute($query);
				
				if (empty($result)) {
					$error_info = "function=deleteTags class=Tag.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
					$GLOBALS['am_error_log'][] = array(1, 1, $error_info);
				}
			}
		}
	} //EO deleteTags
}
?>
