<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

include "inc/header.inc.php";

if (!empty($_POST['group_id'])) { // page under group section
    //setup group
	$group_id = $_REQUEST['group_id'];
	include "inc/header_group.inc.php";
	require_once($languagePath . 'grp_common.lang.php');
}

// SETUP LANGUAGE --------------------------------------------------------
require_once($languagePath . 'common.lang.php');


// SETUP TAGS
require_once('class/Tag.class.php');
$tag = new Tag($db, null);
if (isset($group_id)) {
	$tag->group_id = $group_id;
	$output_group_tags = $tag->selTags();
}
elseif (isset($me['user_id'])) {
	$tag->user_id = $me['user_id'];
	$tag->rsp_item_type_id = $c_node['rsp']['item_type']['network'];
	$output_item_tags = $tag->selTags(1, 1);
}

// setup images
$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][3]['name'];


if ((isset($frmdata['search_text']) && strlen(trim($frmdata['search_text'])) >= 3) || !empty($_REQUEST['tag'])) {
	
	if (isset($frmdata['search_text'])) {
		$search_text = trim($frmdata['search_text']);
	}
	else {
		$search_text = null;
	}
	
	unset($tag->user_id);
	
	
	// GROUP SEARCH --------------------------------------------------
	if (!isset($group_id) && (isset($search_text) || isset($_REQUEST['tag']))) {
		require_once($languageArrayPath . 'arr_group.lang.php');
		require_once('class/Group.class.php');
		$group = new Group($db, $file);
		$group->registration_types = $c_node['group']['registration_type'];
		$group->group_visibility = 1;
		
		if (isset($search_text)) {
			$output_groups = $group->getGroups($search_text);
		}
		else {
			$group->item_types = $c_node['rsp']['item_type'];
			$output_groups = $group->getGroups(null, $_REQUEST['tag']);
		}
		
		//get the tags for each item
		if (!empty($output_groups)) {
			$tag->rsp_item_type_id = $c_node['rsp']['item_type']['group'];
			foreach ($output_groups as $key => $i):
				$tag->item_id = $i['group_id'];
				$output_groups[$key]['tags'] = $tag->selTags();
			endforeach;
		}
	
	}
	
	
	//get blogs -----------------------------------------------------
	require_once('class/Blog.class.php');
	$blog = new Blog($db, null, null);
	$blog->rsp_level_id = $c_node['rsp']['rsp_level']['node'];
	$blog->rsp_status_id = $c_node['rsp']['status']['live'];
	$blog->item_types = $c_node['rsp']['item_type'];
	$blog->me = $me;
	
	if (!empty($_REQUEST['tag'])) {
		$blog->tag = $_REQUEST['tag'];
	}
	
	$blog->rsp_item_type_id = $c_node['rsp']['item_type']['blog'];
	
	$output_blogs = $blog->selBlogs($search_text);
	
	//get the tags for each item
	if (!empty($output_blogs)) {
		$tag->rsp_item_type_id = $c_node['rsp']['item_type']['blog'];
		foreach ($output_blogs as $key => $i):
			$tag->item_id = $i['blog_id'];
			$output_blogs[$key]['tags'] = $tag->selTags();
		endforeach;
	}
	
	
	//get library items -----------------------------------------------------
	require_once('class/Library.class.php');
	$library = new Library($db, null, null);
	$library->rsp_level_id = $c_node['rsp']['rsp_level']['node'];
	$library->rsp_status_id = $c_node['rsp']['status']['live'];
	$library->item_types = $c_node['rsp']['item_type'];
	$library->me = $me;
	
	if (!empty($_REQUEST['tag'])) {
		$library->tag = $_REQUEST['tag'];
	}
	
	$library->rsp_item_type_id = $c_node['rsp']['item_type']['library'];
	
	$output_library_items = $library->selLibraryItems($search_text);
	
	//get the tags for each item
	if (!empty($output_library_items)) {
		$tag->rsp_item_type_id = $c_node['rsp']['item_type']['library'];
		foreach ($output_library_items as $key => $i):
			$tag->item_id = $i['library_id'];
			$output_library_items[$key]['tags'] = $tag->selTags();
		endforeach;
	}
	
	
	//get polls  -----------------------------------------------------
	require_once('class/Poll.class.php');
	$poll = new Poll($db, null);
	$poll->order_by = "p.poll_start_datetime desc";
	$poll->rsp_level_id = $c_node['rsp']['rsp_level']['node'];
	$poll->rsp_status_id = $c_node['rsp']['status']['live'];
	$poll->item_types = $c_node['rsp']['item_type'];
	$poll->me = $me;
	
	if (!empty($_REQUEST['tag'])) {
		$poll->tag = $_REQUEST['tag'];
	}
	
	$poll->rsp_item_type_id = $c_node['rsp']['item_type']['poll'];
	
	$output_polls = $poll->selPolls($search_text);
	
	//get the tags for each item
	if (!empty($output_polls)) {
		$tag->rsp_item_type_id = $c_node['rsp']['item_type']['poll'];
		foreach ($output_polls as $key => $i):
			$tag->item_id = $i['poll_id'];
			$output_polls[$key]['tags'] = $tag->selTags();
		endforeach;
	}
	
	
	//get quizzes -----------------------------------------------------
	require_once('class/Quiz.class.php');
	$quiz = new Quiz($db, null, null);
	$quiz->rsp_level_id = $c_node['rsp']['rsp_level']['node'];
	$quiz->rsp_status_id = $c_node['rsp']['status']['live'];
	$quiz->item_types = $c_node['rsp']['item_type'];
	$quiz->me = $me;
	
	if (!empty($_REQUEST['tag'])) {
		$quiz->tag = $_REQUEST['tag'];
	}
	
	$quiz->rsp_item_type_id = $c_node['rsp']['item_type']['quiz'];
	
	$output_quizzes = $quiz->selQuizzes($search_text);
	
	//get the tags for each item
	if (!empty($output_quizzes)) {
		$tag->rsp_item_type_id = $c_node['rsp']['item_type']['quiz'];
		foreach ($output_quizzes as $key => $i):
			$tag->item_id = $i['quiz_id'];
			$output_quizzes[$key]['tags'] = $tag->selTags();
		endforeach;
	}
	
	
	//get subjects  -----------------------------------------------------
	require_once('class/Forum.class.php');
	$forum = new Forum($db, null, null);
	$forum->rsp_level_id = $c_node['rsp']['rsp_level']['node'];
	$forum->rsp_status_id = $c_node['rsp']['status']['live'];
	$forum->item_types = $c_node['rsp']['item_type'];
	$forum->me = $me;
	
	if (!empty($_REQUEST['tag'])) {
		$forum->tag = $_REQUEST['tag'];
	}
	
	$forum->rsp_item_type_id = $c_node['rsp']['item_type']['forum'];
	
	$output_subjects = $forum->selSubjects($search_text);
	
	//get the tags for each item
	if (!empty($output_subjects)) {
		$tag->rsp_item_type_id = $c_node['rsp']['item_type']['forum'];
		foreach ($output_subjects as $key => $i):
			$tag->item_id = $i['subject_id'];
			$output_subjects[$key]['tags'] = $tag->selTags();
		endforeach;
	}
	
	
	// ACTIVITY SEARCH --------------------------------------------------
	require_once('class/Schedule.class.php');
	require_once($languageArrayPath . 'arr_schedule.lang.php');
	$schedule = new Schedule($db, $c_node['rsp']['item_type']['schedule'], $date, $file);
	$schedule->rsp_level_id = $c_node['rsp']['rsp_level']['node'];
	$schedule->rsp_status_id = $c_node['rsp']['status']['live'];
	$schedule->item_types = $c_node['rsp']['item_type'];
	$schedule->me = $me;
	$schedule->schedule_config = $c_node['schedule'];
	
	if (!empty($_REQUEST['tag'])) {
		$schedule->tag = $_REQUEST['tag'];
	}
	
	$schedule->rsp_item_type_id = $c_node['rsp']['item_type']['schedule'];
	
	$schedule->schedule_type_id = $c_node['schedule']['type']['event'];
	$output_activities = $schedule->selScheduleItems($search_text);;
	$schedule->schedule_type_id = $c_node['schedule']['type']['task'];
	$output_tasks = $schedule->selScheduleItems($search_text);
	
	//get the tags for each item
	if (!empty($output_activities)) {
		$tag->rsp_item_type_id = $c_node['rsp']['item_type']['schedule'];
		foreach ($output_activities as $key => $i):
			$tag->item_id = $i['schedule_id'];
			$output_activities[$key]['tags'] = $tag->selTags();
		endforeach;
	}
	
	if (!empty($output_tasks)) {
		$tag->rsp_item_type_id = $c_node['rsp']['item_type']['schedule'];
		foreach ($output_tasks as $key => $i):
			$tag->item_id = $i['schedule_id'];
			$output_tasks[$key]['tags'] = $tag->selTags();
		endforeach;
	}
	
	
	// USERS --------------------------------------------------------------
	if (!empty($_REQUEST['tag'])) {
		//setup file
		$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
		$file->thumb = $c_node['file']['image']['thumb'][3]['name'];
		$user->file = $file;
		
		$tag->user_id = $me['user_id'];
		$tag->rsp_item_type_id = $c_node['rsp']['item_type']['network'];
		$output_item_tags = $tag->selTags(null, 1);

		$user->user_id = $me['user_id'];
		$user->item_types = $c_node['rsp']['item_type'];
		$output_users = $user->selUsers($_REQUEST['tag']);
	}
	
}
elseif (isset($data['search_text']) && strlen(trim($data['search_text'])) < 3) {
	$GLOBALS['am_error_log'][] = array(41, null, null);
}
else {
	//ERROR NO SEARCH TEXT
}


// FIND RELATIONS ---------------------------------------------------------
if (!empty($output_users)) {
	
	require_once($languageArrayPath . 'arr_user.lang.php');
	require_once($languagePath . 'sn_list.lang.php');
	//setup social network
	require_once('class/SocialNetwork.class.php');
	$sn = new Socialnetwork($me['user_id'], $db);
	$sn->relation_type_ids = $c_node['user']['relation_type'];
	$sn->status_ids = $c_node['user']['status'];
	
	$output_relation_of_users = $sn->selRelations($me['user_id'], 1);
	$first_degree_network_total = 0;

	if (isset($me['relations'])) {
		$temp = $me['relations'];
	}
	
	
	$output_blocked = $sn->getBlockedUsers();
	
	foreach($output_users as $key => $i):
		//I AM A RELATION TO USER
		$total_friends = array();
		if (!empty($output_relation_of_users)) {
			foreach($output_relation_of_users as $keyr => $r):
				if ($i['user_id'] == $r['user_id']) {
					$output_users[$key]['am_relation_to_them'] = $r;
					unset ($output_relation_of_users[$keyr]);
					
					// can we show network?
					if (!empty($r['relation_show_network'])) {
						$total_friends = $sn->selRelations($i['user_id']);
					}
				}
			endforeach;
		}
		$output_users[$key]['sn_total'] = count($total_friends);
		
		
		// RELATIONS TO ME
		if (!empty($temp)) {
			foreach($temp as $keyr => $r):
				if ($i['user_id'] == $r['user_id_relation']) {
					$output_users[$key]['relation_to'] = $r;
					unset ($temp[$keyr]);
				}
			endforeach;
		}
		
		
		// BLOCKED BY ME
		if (!empty($output_blocked)) {
			foreach($output_blocked as $keyb => $b):
				if ($i['user_id'] == $b['user_id_blocked']) {
					$output_users[$key]['blocked'] = 1;
					unset ($temp[$keyb]);
				}
			endforeach;
		}
		
		
		$tag->item_id = $i['user_id'];
		$output_users[$key]['tags'] = $tag->selTags();
		
	endforeach;
}



//move to template
if (!empty($_REQUEST['tag'])) {
	$body->set('tag', $_REQUEST['tag']);
}
elseif (!empty($search_text)) {
	$body->set('tag', $search_text);
}

if (!empty($output_my_tags)) {
	$body->set('my_tags', $output_my_tags);
}

if (!empty($output_item_tags)) {
	$body->set('item_tags', $output_item_tags);
}

if (!empty($output_subjects)) {
    $body->set('subjects', $output_subjects);
}

if (!empty($output_activities)) {
	$body->set('activities', $output_activities);
}

if (!empty($output_groups)) {
    $body->set('groups', $output_groups);
}

if (!empty($output_tasks)) {
	$body->set('tasks', $output_tasks);
}

if (!empty($output_blogs)) {
    $body->set('blogs', $output_blogs);
}

if (!empty($output_library_items)) {
    $body->set('library_items', $output_library_items);
}

if (!empty($output_polls)) {
    $body->set('polls', $output_polls);
}

if (!empty($output_quizzes)) {
    $body->set('quizzes', $output_quizzes);
}

if (!empty($output_users)) {
    $body->set('users', $output_users);
}

if (!empty($search_text)) {
    $body->set('search_text', $search_text);
	$lang['txt_search_results'] = str_replace("SYS_KEYWORD_SEARCHTXT", "\"" . $search_text . "\"", $lang['txt_search_results']);
}

include "inc/footer.inc.php";

?>
