<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------
?>


<div class="col_main">
	<?php
	if (isset($subject)) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $this->date->formatDate($subject['subject_create_datetime'], 1);?><br />
		</div>
			
		<div class="box_mid">
			<div class="content">
				<div class="metadata_top">
					<b><?php echo $lang['txt_item_options'];?></b> -&#62; 
					<?php
					if (isset($me['user_id']) && $me['user_id'] > 0) {
					?>
					
					<?php
					if ($me['user_id'] == $subject['user_id']) {
					?>
					<a href="frm_edit.php?subject_id=<?php echo $subject['subject_id'];?>"><?php echo $lang['href_edit'];?></a>
					,&nbsp;
					<?php }?>
					
					<?php
					if (isset($me['user_id']) && $me['user_id'] > 0) {
					?>
					<?php
					if (isset($subject['bookmark']['watch'])) {
					?>
					<a href="frm_view.php?subject_id=<?php echo $subject['subject_id'];?>&amp;bookmark=del_mark"><?php echo $lang['href_unwatch_this'];?></a>
					<?php
					}
					else {
					?>
					<a href="frm_view.php?subject_id=<?php echo $subject['subject_id'];?>&amp;bookmark=ins_mark"><?php echo $lang['href_watch_this'];?></a>
					<?php }?>
					
					<?php
					if ($me['user_id'] != $subject['user_id']) {
					?>
					,&nbsp;
					<?php
					if (isset($subject['bookmark']['recommend'])) {
					?>
					<a href="frm_view.php?subject_id=<?php echo $subject['subject_id'];?>&amp;bookmark=del_tip"><?php echo $lang['href_unrecommend_this'];?></a>
					<?php
					}
					else {
					?>
					<a href="frm_view.php?subject_id=<?php echo $subject['subject_id'];?>&amp;bookmark=ins_tip"><?php echo $lang['href_recommend_this'];?></a>
					<?php }}?>
					
					<?php
					if (!isset($subject['bookmark']['watch']) && isset($batch_enabled) && $batch_enabled == true) {
					?>
					,&nbsp;
					<a href="frm_view.php?subject_id=<?php echo $subject['subject_id'];?>&amp;bookmark=ins_mark&amp;notify=1"><?php echo $lang['href_watch_this_notify'];?></a>
					<?php }?>
					<?php }?>
					<br />
				</div>
				<?php }?>
				
				<p class="txt_item_title">
					<?php echo $subject['subject_title'];?><br />
				</p>
				
				<p>
					<?php echo $subject['display_subject_body'];?><br />
				</p>
			
				<div class="metadata">
					<?php
					if (isset($author)) {
						if (isset($group)) {
							$profile_url = "grp_membership.php?group_id=" . $group['group_id'] . "&amp;user_id=" . $author['user_id'];
						}
						else {
							$profile_url = "sn_profile.php?user_id=" . $author['user_id'];
						}
					?>
						<p>
							<b><?php echo $lang['txt_author'];?></b> -&#62; 
							<?php echo $lang['txt_profile_nic'];?>: 
							<a href="<?php echo $profile_url;?>"><?php echo $author['profile_nic'];?></a>, 
							<?php echo $lang['txt_profile_session_status'];?>: 
							<?php
							if ($author['online_status'] == 1) {
								echo "<b>" . $lang['arr_user_online_status'][1] . "</b>";
							}
							else {
									echo $lang['arr_user_online_status'][$author['online_status']];
							}
							?>, 
							<?php echo $lang['txt_hometown'];?>: 
							<?php echo $author['profile_hometown'];?>, 
							<?php echo $lang['txt_joined'];?>: 
							<?php echo $this->date->formatDate($author['profile_create_datetime']);?>
							<?php
							if (isset($group)) {
							?>
							&nbsp;<?php echo $lang['txt_group_link'];?>: <a href="grp_view.php?group_id=<?php echo $group['group_id'];?>"><?php echo $group['group_title'];?></a>
							<?php }?>
							<br />
						</p>
						
						<p>
							<b><?php echo $lang['hdr_topic'];?></b> -&#62; 
							<a href="frm_view.php?topic_id=<?php echo $subject['topic_id'];?>"><?php echo $topic['topic_title'];?></a><br />
							<?php
							if (isset($topic_roles)) {
							?>
							<p>
								<b><?php echo $lang['hdr_permissions'];?></b>:
									<?php echo $lang['txt_topic_role_add'];?>: 
									<?php
									foreach($topic_roles as $key => $tr):
										echo $lang['arr_acs']['role'][$tr['role_id']];
										if ($key+1 < count($topic_roles)) {
											echo ", ";
										}
									endforeach;
									?>
									<br />
							<?php }?>
						</p>
					
						<p>
							<b><?php echo $lang['hdr_subject'];?></b> -&#62; 
							<?php
							if (isset($subject['subject_sticky'])) {
							?>
							<?php echo $lang['txt_sticky'];?>, 
							<?php }?>
							
							<?php
							if (isset($subject['subject_locked'])) {
							?>
							<?php echo $lang['txt_locked'];?>, 
							<?php }?>
							
							<?php
							if (isset($subject['subject_hidden'])) {
							?>
							<?php echo $lang['txt_hidden'];?>,
							<?php }?>
							<?php
							if (!empty($subject['bookmark'])) {
								echo $lang['txt_bookmarks'] . ": ";
								
								if (!empty($subject['bookmark']['watch'])) {
									echo $lang['txt_marked'];
								}
								
								if (!empty($subject['bookmark']['watch']) && !empty($subject['bookmark']['recommend'])) {
									echo "&nbsp;&amp;&nbsp;";
								}
								
								if (!empty($subject['bookmark']['recommend'])) {
									echo $lang['txt_tipped'];
								}
								echo ", ";
							}
							?>
							<?php
							if ($subject['subject_create_datetime'] != $subject['subject_edit_datetime'] && !empty($subject['subject_edit_datetime'])) {
								echo $lang['txt_last_edited'] . ": ";
								echo $this->date->formatDate($subject['subject_edit_datetime'], 1) . ", ";
							}
							?>
							<?php echo $lang['txt_published_to'];?>: 
							<?php
							if (isset($subject['rsp'])) {
								foreach($subject['rsp'] as $key => $i):
									if (!empty($i['degree_id']) && $i['level_id'] == $rspconfig['rsp_level']['node']) {
									echo $lang['rsp']['rsp_level_degree'][$i['degree_id']];
								}
								else {
									echo trim($lang['rsp']['rsp_level'][$i['level_id']]);
								}
								echo " (" .$lang['rsp']['status'][$i['status_id']];
								
								if (!empty($i['rsp_featured'])) {
									echo " &amp; " .  $lang['txt_featured'];
								}
								
								echo ")";
								if ($key+1 < count($subject['rsp'])) {
									echo ", ";
								}
								endforeach;
							}
							?>
							<br />
						</p>
					<?php }?>
				</div>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<?php 
	}
	elseif (!empty($subjects) || !empty($topic)) {
	?>
	<div class="box">
		<div class="box_top">
			<?php
			if (!empty($topic)) {
				echo $lang['hdr_topic'];
			}
			elseif (isset($display) && $display == "latest") {
				echo $lang['hdr_latest_subjects'];
			}
			else {
				echo $lang['hdr_subjects'];
			}
			?>
			<br />
		</div>
	
		<div class="box_mid">
			<div class="content">
				<?php
				if (isset($lang['txt_intro'])) {
				?>
				<p>
					<?php echo $lang['txt_intro'];?><br />
				</p>
				<?php }?>
				
				<?php
				if (!empty($topic)) {
				?>
				<p class="txt_item_title">
					<b><?php echo $topic['topic_title'];?></b><br />
				</p>
				
				<p>
					<?php echo $topic['topic_synopsis'];?><br />
				</p>
				<?php }?>
					
				<?php
				if (!empty($subjects)) {
				?>
				<table width="100%" cellpadding="4" cellspacing="0" border="0">
					<?php
					foreach($subjects as $key => $i):
					?>
					<tr>
						<td colspan="2">
							<table width="100%" cellpadding="0" cellspacing="0" border="0">
								<tr>
									<td>
										<table width="100%" cellpadding="4" cellspacing="2" border="0">
											<tr>
												
												<td width="28" valign="top" align="center">
													<a href="frm_view.php?subject_id=<?php echo $i['subject_id'];?>" title="<?php echo $i['subject_title'];?>"><img src="get_file.php?file=<?php echo $i['image']['file'];?>" border="0" class="picture" title="<?php echo $i['image']['file_title'];?>"></a><br />
												</td>
												<td valign="top">
													<?php echo $this->date->formatDate($i['subject_create_datetime']);?><br />
													<a href="frm_view.php?subject_id=<?php echo $i['subject_id'];?>" title="<?php echo $i['subject_title'];?>"><?php echo $i['subject_title'];?></a><br />
													<?php echo dots(140,$i['subject_synopsis']);?><br />
												</td>
												<td valign="top" width="30%">
													<br />
													<?php echo $lang['txt_comment_total'];?>: <?php echo $i['comment_total'];?><br />
													<?php if (!empty($i['last_comment']['comment_create_datetime'])) { echo $lang['txt_last_comment'] . ": " . $this->date->formatDate($i['last_comment']['comment_create_datetime'],1) . "<br />";}?>
													
													<?php
													if (isset($i['movement']['lastview_datetime'])) {
														echo $lang['txt_watching'] . ": " . $lang['txt_lastview'] . " " . $this->date->formatDate($i['movement']['lastview_datetime'], 1) . "<br />";
														echo "(" . $lang['txt_movement'] . " ". $i['movement']['movement'] . ")";
													}
													?>
													
													<?php
													if (isset($i['subject_sticky'])) {
														echo $lang['txt_sticky'] . ", ";
													}
													
													if (isset($i['subject_locked'])) {
														echo $lang['txt_locked'] . ", ";
													}
													
													if (isset($i['subject_hidden'])) {
														echo $lang['txt_hidden'];
													}
													?>
													<br />
												</td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
						</td>
					</tr>
					<?php
					endforeach;
					?>
				</table>
				<?php
				}
				else {
				?>
				<p>
					<?php echo $lang['err_no_subjects'];?><br />
				</p>
				<?php }?>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php
	}
	elseif (isset($my_group_subjects)) { //list view sorted by group
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_my_group_subjects'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php echo $lang['txt_intro_group'];?><br />
				
				<?php
				if (!empty($my_group_subjects)) {
				?>
				
				<table border="0" cellspacing="0" cellpadding="4" width="100%">
					<?php
					foreach($my_group_subjects as $key => $g):
					if (!empty($g['subjects'])) {
					?>
					<tr>
						<td colspan="2">
							<b><?php echo $g['group_title'];?></b><br />
						</td>
						<td align="right" nowrap="nowrap">
							<a href="frm_view.php?group_id=<?php echo $g['group_id'];?>"><?php echo $lang['href_group_subject'];?></a><br />
						</td>
					</tr>
					<?php
					foreach($g['subjects'] as $key => $i):
					?>
					<tr>
						<td width="1" rowspan="2">
							<a href="frm_view.php?subject_id=<?php echo $i['subject_id'];?>"><img src="get_file.php?file=<?php echo $i['image']['file'];?>" border="0" alt="<?php echo $i['image']['file_title'];?>" /></a><br />
						</td>
						<td valign="top">
							<a href="frm_view.php?subject_id=<?php echo $i['subject_id'];?>"><?php echo $this->date->formatDate($i['subject_create_datetime'], 1);?></a><br />
							<?php echo $i['subject_title'];?><br />
						</td>
						<td valign="top" align="right">
							<?php echo $lang['href_comments'];?>&nbsp;(<?php if (!empty($i['comment_total'])) { echo $i['comment_total'];} else { echo "0";}?>)
							<br />
						</td>
					</tr>
					<tr>
						<td colspan="2">
							<?php echo $lang['txt_tag'];?>: 

							<?php
							$tags = "";
							if (isset($i['tags'])) {
								foreach ($i['tags'] as $keyt => $t):
									$tags .= $t['tag_body'];
									
									if (count($i['tags']) > $keyt+1) {
										$tags .= ", ";
									}
								endforeach;
								
								if (isset($tag)) {
									$tags = searchTextFormat($tag, $tags);
								}
								echo $tags;
							}
							?>
						</td>
					</tr>
					<?php
					endforeach;
					?>
					<tr>
						<td colspan="3">
							<hr />
							<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="10" alt="" /><br />
						</td>
					</tr>
					<?php
					}
					else {
						$group_no_subject_list[] = $g;
					}
					endforeach;
					?>
					
				</table>
				<?php }?>
				
				<?php
				if (!empty($group_no_subject_list)) {
				?>
				
				<p>
					<?php echo $lang['txt_outro_group'];?><br />
				</p>
				
				<table border="0" cellspacing="0" cellpadding="4" width="100%">
					<?php
					foreach($group_no_subject_list as $key => $g):
					?>
					<tr>
						<td>
							<b><?php echo $g['group_title'];?></b><br />
						</td>
						<td align="right">
							<a href="frm_view.php?group_id=<?php echo $g['group_id'];?>"><?php echo $lang['href_group_subject'];?></a><br />
						</td>
					</tr>
				<?php
				endforeach;
				?>
				</table>
				<?php }?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<?php
	}
	elseif (isset($my_network_subjects)) { //list view sorted by group
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_my_network_subjects'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<p>
					<?php echo $lang['txt_intro_network'];?><br />
				</p>
				
				<?php
				if (!empty($my_network_subjects)) {
				?>
				
				<table border="0" cellspacing="0" cellpadding="4" width="100%">
					<?php
					foreach($my_network_subjects as $key => $g):
					if (!empty($g['subjects'])) {
					?>
					<tr>
						<td valign="top" width="32">
							<a href="sn_profile.php?user_id=<?php echo $g['user_id'];?>"><img src="get_file.php?file=<?php echo $g['image']['file'];?>" border="0" class="picture" alt="<?php echo $g['image']['file_title'];?>" /></a><br />
						</td>
						<td>
							<?php
							if (!empty($g['am_relation_to_them']['relation_show_true_self'])) {
							?>
								<b><a href="sn_profile.php?user_id=<?php echo $g['user_id'];?>"><?php echo $g['user_firstname']. " " . $g['user_surname'];?></a></b>,
								
								
								<?php echo $this->date->formatDate($g['user_create_datetime']);?>,
								<?php echo $g['user_hometown'];?>,
							<?php
							}
							else {
							?>
							
								<a href="sn_profile.php?user_id=<?php echo $g['user_id'];?>"><b><?php echo $g['profile_nic'];?></b></a>,
								
								
								<?php echo $this->date->formatDate($g['user_create_datetime']);?>,
								<?php echo $g['profile_hometown'];?>,
							<?php }?>
							
							<?php
							if ($g['online_status'] == 1) {
								echo "<b>" . $lang['arr_user_online_status'][1] . "</b><br />";
							}
							else {
									echo $lang['arr_user_online_status'][$g['online_status']] . "<br />";
							}
							?>
						</td>
						<td align="right">
							<a href="frm_view.php?user_id=<?php echo $g['user_id'];?>"><?php echo $lang['href_network_subject'];?></a><br />
						</td>
					</tr>
					<?php
					foreach($g['subjects'] as $key => $i):
					?>
					<tr>
						<td width="32" rowspan="2">
							<a href="frm_view.php?subject_id=<?php echo $i['subject_id'];?>"><img src="get_file.php?file=<?php echo $i['image']['file'];?>" border="0" alt="<?php echo $i['image']['file_title'];?>" /></a><br />
						</td>
						<td valign="top" nowrap="nowrap">
							<a href="frm_view.php?subject_id=<?php echo $i['subject_id'];?>"><?php echo $this->date->formatDate($i['subject_create_datetime'], 1);?></a><br />
							<?php echo $i['subject_title'];?><br />
						</td>
						<td valign="top">
							<?php echo $lang['href_comments'];?>&nbsp;(<?php if (!empty($i['comment_total'])) { echo $i['comment_total'];} else { echo "0";}?>)
							<br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_tag'];?>: 

							<?php
							$tags = "";
							if (isset($i['tags'])) {
								foreach ($i['tags'] as $keyt => $t):
									$tags .= $t['tag_body'];
									
									if (count($i['tags']) > $keyt+1) {
										$tags .= ", ";
									}
								endforeach;
								
								if (isset($tag)) {
									$tags = searchTextFormat($tag, $tags);
								}
								echo $tags;
							}
							?>
						</td>
						<td>
							<br />
						</td>
					</tr>
					<?php
					endforeach;
					?>
					<tr>
						<td colspan="4">
							<hr />
							<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="10" alt="" /><br />
						</td>
					</tr>
					<?php
					}
					else {
						$network_no_subject_list[] = $g;
					}
					endforeach;
					?>
				</table>
				<?php }?>
				
				<?php
				if (!empty($network_no_subject_list)) {
				?>
				
				<p>
					<?php echo $lang['txt_outro_network'];?><br />
				</p>
				
				<table border="0" cellspacing="0" cellpadding="4" width="100%">
					<?php
					foreach($network_no_subject_list as $key => $g):
					?>
					<tr>
						<td colspan="2">
							<?php
							if (!empty($g['am_relation_to_them']['relation_show_true_self'])) {
							?>
								<b><a href="sn_profile.php?user_id=<?php echo $g['user_id'];?>"><?php echo $g['user_firstname']. " " . $g['user_surname'];?></a></b>,
								
								
								<?php echo $g['user_create_datetime'];?>,
								<?php echo $g['user_hometown'];?>,
							<?php
							}
							else {
							?>
							
								<a href="sn_profile.php?user_id=<?php echo $g['user_id'];?>"><b><?php echo $g['profile_nic'];?></b></a>,
								
								
								<?php echo $g['user_create_datetime'];?>,
								<?php echo $g['profile_hometown'];?>,
							<?php }?>
							
							<?php
							if ($g['online_status'] == 1) {
								echo "<b>" . $lang['arr_user_online_status'][1] . "</b><br />";
							}
							else {
									echo $lang['arr_user_online_status'][$g['online_status']] . "<br />";
							}
							?>
						</td>
						<td align="right" colspan="2">
							<a href="frm_view.php?user_id=<?php echo $g['user_id'];?>"><?php echo $lang['href_network_subject'];?></a><br />
						</td>
					</tr>
				<?php
				endforeach;
				?>
				</table>
				<?php }?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<?php
	}
	elseif (isset($recommended_subjects)) { //list view sorted by group
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_subjects'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				if (isset($lang['txt_intro'])) {
					echo "<p>" . $lang['txt_intro'] . "<br /></p>";
				}
				?>
				
				<?php
				if (!empty($recommended_subjects)) {
				?>
				<table border="0" cellspacing="0" cellpadding="4" width="100%">
					<?php
					foreach($recommended_subjects as $key => $g):
					if (!empty($g['subjects'])) {
					?>
					<tr>
						<td valign="top" width="32">
							<a href="sn_profile.php?user_id=<?php echo $g['user_id'];?>"><img src="get_file.php?file=<?php echo $g['image']['file'];?>" border="0" class="picture" alt="<?php echo $g['image']['file_title'];?>" /></a><br />
						</td>
						<td>
							<?php
							if (!empty($g['am_relation_to_them']['relation_show_true_self'])) {
							?>
								<b><a href="sn_profile.php?user_id=<?php echo $g['user_id'];?>"><?php echo $g['user_firstname']. " " . $g['user_surname'];?></a></b>,
								
								
								<?php echo $this->date->formatDate($g['user_create_datetime']);?>,
								<?php echo $g['user_hometown'];?>,
							<?php
							}
							else {
							?>
							
								<a href="sn_profile.php?user_id=<?php echo $g['user_id'];?>"><b><?php echo $g['profile_nic'];?></b></a>,
								
								
								<?php echo $this->date->formatDate($g['user_create_datetime']);?>,
								<?php echo $g['profile_hometown'];?>,
							<?php }?>
							
							<?php
							if ($g['online_status'] == 1) {
								echo "<b>" . $lang['arr_user_online_status'][1] . "</b><br />";
							}
							else {
									echo $lang['arr_user_online_status'][$g['online_status']] . "<br />";
							}
							?>
						</td>
						<td align="right">
							<a href="frm_view.php?user_id=<?php echo $g['user_id'];?>"><?php echo $lang['href_network_subject'];?></a><br />
						</td>
					</tr>
					<?php
					foreach($g['subjects'] as $key => $i):
					?>
					<tr>
						<td width="32" rowspan="2">
							<a href="frm_view.php?subject_id=<?php echo $i['subject_id'];?>"><img src="get_file.php?file=<?php echo $i['image']['file'];?>" border="0" alt="<?php echo $i['image']['file_title'];?>" /></a><br />
						</td>
						<td valign="top" nowrap="nowrap">
							<a href="frm_view.php?subject_id=<?php echo $i['subject_id'];?>"><?php echo $this->date->formatDate($i['subject_create_datetime'], 1);?></a><br />
							<?php echo $i['subject_title'];?><br />
						</td>
						<td valign="top">
							<?php echo $lang['href_comments'];?>&nbsp;(<?php if (!empty($i['comment_total'])) { echo $i['comment_total'];} else { echo "0";}?>)
							<br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_tag'];?>: 

							<?php
							$tags = "";
							if (isset($i['tags'])) {
								foreach ($i['tags'] as $keyt => $t):
									$tags .= $t['tag_body'];
									
									if (count($i['tags']) > $keyt+1) {
										$tags .= ", ";
									}
								endforeach;
								
								if (isset($tag)) {
									$tags = searchTextFormat($tag, $tags);
								}
								echo $tags;
							}
							?>
						</td>
						<td>
							<br />
						</td>
					</tr>
					<?php
					endforeach;
					?>
					<tr>
						<td colspan="4">
							<hr />
							<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="10" alt="" /><br />
						</td>
					</tr>
					<?php
					}
					endforeach;
					?>
				</table>
				<?php }?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<?php
	}
	else  { //error - no subjects
	?>
	<div class="box">		
		<div class="box_top">
			<?php echo $lang['hdr_subjects'];?><br />
		</div>
			
		<div class="box_mid">
			<div class="content">
				<?php echo $lang['err_no_subjects'];?><br />
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
	
	<?php
	if (!empty($subjects)) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_latest_comments'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<table width="100%" cellpadding="4" cellspacing="0" border="0">
				<?php
				if (isset($comments)) {
				foreach($comments as $key => $i):
				?>
				
			    <tr>
					<td valign="top">
						<b><a href="frm_view.php?subject_id=<?php echo $i['item_id'];?>"><?php echo $this->date->formatDate($i['comment_create_datetime'], 1);?></a></b><br />
						<?php echo dots(260, $i['comment_body']);?><br />
					</td>
					<td valign="top" width="30%">
						<a href="sn_profile.php?user_id=<?php echo $i['user_id'];?>"><?php echo $i['profile_nic'];?></a><br />
						<?php echo $lang['txt_joined'];?>: <?php echo $this->date->formatDate($i['profile_create_datetime'], 1);?><br />
						<?php echo $lang['txt_hometown'];?>: <?php echo $i['profile_hometown'];?><br />
					</td>
				</tr>
				<?php
				endforeach;
				} else {
				?>
				<tr>
					<td colspan="2">
						<?php echo $lang['err_no_comments'];?><br />
					</td>
				</tr>
				<?php }?>
				</table>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
	
	
	<?php
	if (isset($subject)) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_comments'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				//comments
				if (empty($subject['subject_locked'])) {
						$unlocked = 1;
					}
					
					$hidden_form = array(
						"subject_id" => $subject['subject_id']
					);
					
				
				if (isset($_REQUEST['user_id'])) {
					$hidden_form['user_id'] = $_REQUEST['user_id'];
				}
				
				if (isset($group['group_id'])) {
					$hidden_form['group_id'] = $group['group_id'];
				}
				
				if (isset($subject['user_id'])) {
					$hidden_form['item_user_id'] = $subject['user_id'];
				}
				
				$comment_url = "frm_view.php?subject_id=" . $subject['subject_id'];
				
				include $templatePath . "comment.inc.tpl.php";
				?><br />
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
</div>

<div class="col_side">
	<?php
	if (isset($subjects) && isset ($profile)) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_subject_author'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<p>
					<b><?php echo $profile['profile_nic'];?></b><br />
				</p>
				
				<img src="get_file.php?file=<?php echo $profile['image']['file'];?>" border="0" alt="<?php echo $profile['image']['file_title'];?>" /><br />
				
				<table border="0" cellspacing="0" cellpadding="2" width="100%">
					<tr>
						<td>
							<?php echo $lang['txt_profile_session_status'];?><br />
						</td>
						<td>
							<?php
							if ($profile['online_status'] == 1) {
								echo "<b>" . $lang['arr_user_online_status'][1] . "</b><br />";
							}
							else {
									echo $lang['arr_user_online_status'][$profile['online_status']] . "<br />";
							}
							?>
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_hometown'];?><br />
						</td>
						<td>
							<?php echo $profile['profile_hometown'];?><br />
						</td>
					</tr>
					<tr>
						<td valign="top">
							<?php echo $lang['txt_joined'];?><br />
						</td>
						<td>
							<?php echo $this->date->formatDate($profile['profile_create_datetime']);?><br />
						</td>
					</tr>
				</table>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
	
	<?php
	if (isset($subjects) && isset ($group)) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_group_author'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<p>
					<b><?php echo $group['group_title'];?></b><br />
				</p>
				
				<?php
				if (isset($group['image']['file_id'])) {
				?>
				<img src="get_file.php?file=<?php echo $group['image']['file'];?>" border="0" alt="<?php echo $group['image']['file_title'];?>" /><br />
				<?php }?>
				
				<table border="0" cellspacing="0" cellpadding="2" width="100%">
					<tr>
						<td>
							<?php echo $lang['txt_membership_status'];?><br />
						</td>
						<td>
							<?php echo $group['member']['role_name'];?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_group_language'];?><br />
						</td>
						<td>
							<?php
							if (isset($lang['arr_lang_name'][$group['language_id']])) {
								echo $lang['arr_lang_name'][$group['language_id']];
							}
							?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_group_type'];?><br />
						</td>
						<td>
							<?php 
							if (isset($group['group_registration_type'])) {
								echo $lang['arr_registration_type'][$group['group_registration_type']];
							}
							else {
								echo $lang['txt_hidden'];
							}
							
							?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_rec_age'];?><br />
						</td>
						<td>
							<?
							if ($group['group_from_age'] && $group['group_to_age']) {
								echo $group['group_from_age'] . "/" . $group['group_to_age'];
							}
							else if ($group['group_from_age'] && !$group['group_to_age']) {
								echo $lang['txt_age_from'] . " " . $group['group_from_age'];
							}
							else if (!$group['group_from_age'] && $group['group_to_age']) {
								echo $lang['txt_age_upto'] . " " . $group['group_to_age'];
							}
							else {
								echo $lang['txt_age_all'];
							}
							?>
							<br />
						</td>
					</tr>
				</table>
				
				<?php
				if (!empty($group['member']['role_visitor'])) {
				?>
				<p align="right">
					<b><a href="grp_membership.php?group_id=<?php echo $group['group_id'];?>"><?php echo $lang['href_join'];?></a></b><br />
				</p>
				<?php }?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
	
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_options'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<p>
					<b><?php echo $lang['txt_view'];?></b><br />
				</p>
				
				<?php
				if (isset($view) && $view == "node") {
				?>
				<?php echo $lang['href_view_node'];?><br />
				<?php
				}
				else {
				?>
				<a href="frm_view.php?view=node"><?php echo $lang['href_view_node'];?></a><br />
				<?php }?>
				
				<?php
				if (isset($me['user_id'])) {
				?>
				
				<?php
				if (isset($view) && $view == "my_network") {
				?>
				<?php echo $lang['href_view_network'];?><br />
				<?php
				}
				else {
				?>
				<a href="frm_view.php?view=my_network"><?php echo $lang['href_view_network'];?></a><br />
				<?php }?>
				
				<?php
				if (isset($view) && $view == "my_groups") {
				?>
				<?php echo $lang['href_view_my_groups'];?><br />
				<?php
				}
				else {
				?>
				<a href="frm_view.php?view=my_groups"><?php echo $lang['href_view_my_groups'];?></a><br />
				<?php }?>
				
				<?php
				if (isset($view) && $view == "my_subjects") {
				?>
				<?php echo $lang['href_my_subjects'];?><br />
				<?php
				}
				else {
				?>
				<a href="frm_view.php?view=my_subjects"><?php echo $lang['href_my_subjects'];?></a><br />
				<?php }?>
				
				<?php
				if (isset($view) && $view == "marked_subjects") {
				?>
				<?php echo $lang['href_marked'];?><br />
				<?php
				}
				else {
				?>
				<a href="frm_view.php?view=marked_subjects"><?php echo $lang['href_marked'];?></a><br />
				<?php }?>
				
				<?php
				if (isset($view) && $view == "tipped_subjects") {
				?>
				<?php echo $lang['href_tipped'];?><br />
				<?php
				}
				else {
				?>
				<a href="frm_view.php?view=tipped_subjects"><?php echo $lang['href_tipped'];?></a><br />
				<?php }?>
				
				<?php }?>
				<?php
				if (isset($subject)) {
				if (isset($group)) {
				?>
				<a href="frm_view.php?group_id=<?php echo $group['group_id'];?>"><?php echo $lang['href_list_subjects'];?></a><br />
				<?php
				}
				else {
				?>
				<a href="frm_view.php?user_id=<?php echo $subject['user_id'];?>"><?php echo $lang['href_list_subjects'];?></a><br />
				<?php }}?>
				
				
				<p>
					<b><?php echo $lang['txt_options'];?></b><br />
				</p>
				
				<?php
				if (isset($group) && $this->group_acs->checkPermission($resource_ids['group']['forum'], $privilege_ids['add_item'])) { //resourece_id, Priv_id
					if (isset($topic)) {
						$url = "frm_edit.php?add_subject=1&amp;group_id=" . $group['group_id'] . "&amp;topic_id=" . $topic['topic_id'];
					}
					else {
						$url = "frm_edit.php?add_subject=1&amp;group_id=" . $group['group_id'];
					}
					?>
					<a href="<?php echo $url;?>"><?php echo $lang['href_group_add_subject'];?></a><br />
				<?php
				}
				elseif (isset($topic) && !empty($topic['add_subject'])) {
				?>
				<a href="frm_edit.php?add_subject=1&amp;topic_id=<?php echo $topic['topic_id'];?>"><?php echo $lang['href_add_subject_topic'];?></a><br />
				<?php
				}
				elseif ($this->user_acs->checkPermission($resource_ids['node']['forum'], $privilege_ids['add_item'])) { //resourece_id, Priv_id
				?>
				<a href="frm_edit.php?add_subject=1"><?php echo $lang['href_add_subject'];?></a><br />
				<?php }?>
				
				<?php
				if (isset($group) && $this->group_acs->checkPermission($resource_ids['group']['forum'], $privilege_ids['allow_edit'])) { //resource_id, Priv_id
				?>
				<a href="frm_edit.php?group_id=<?php echo $group['group_id'];?>&amp;add_topic=1"><?php echo $lang['href_edit_group_topics'];?></a><br />
				<?php
				}
				elseif ($this->user_acs->checkPermission($resource_ids['node']['forum'], $privilege_ids['allow_edit'])) { //resource_id, Priv_id
				?>
				<a href="frm_edit.php?add_topic=1"><?php echo $lang['href_edit_topics'];?></a><br />
				<?php }?>
				
				<?php
				if (isset($subject)) {
				?>
				<p>
					<b><?php echo $lang['hdr_tag'];?></b><br />
				</p>
				
				<p>
					<?php
					$tags = "";
					if (isset($item_tags)) {
						foreach ($item_tags as $key => $i):
							$tags .= "<a href='search.php?tag=" . $i['tag_body']. "'>" . $i['tag_body'] . "</a>";
							
							if (isset($me['user_id']) && $i['user_id'] == $me['user_id']) {
								$tags .= "*";
							}
							
							if (count($item_tags) > $key+1) {
								$tags .= ", ";
							}
						endforeach;
						echo $tags;
					}
					?>
				</p>
				
				<?php
				if ($this->user_acs->checkPermission($resource_ids['node']['forum'], $privilege_ids['allow_tagging'])) { //resourece_id, Priv_id
				$tags = "";
				if (isset($my_tags)) {
					foreach ($my_tags as $key => $i):
						$tags .= $i['tag_body'];
						if (count($my_tags) > $key+1) {
							$tags .= ", ";
						}
					endforeach;
				}
				?>
				
				<form action="frm_view.php" method="post" name="frm_view" id="id_frm_view">
				<input type="hidden" name="subject_id" value="<?php if(isset($subject['subject_id'])) { echo $subject['subject_id'];}?>" />
				<input type="hidden" name="topic_id" value="<?php if(isset($topic['topic_id'])) { echo $topic['topic_id'];}?>" />
				<input type="hidden" name="group_id" value="<?php if(isset($group['group_id'])) { echo $group['group_id'];}?>" />
				
				<p>
					<input width="30" name="tags" value="<?php echo $tags;?>" />
					<input type="image" src="<?php echo $templatePath;?>img/go.png" name="update_tag" value="1" class="go" /><br />
				</p>
				
				<?php }?>
				<?php }?>
				
				</form>
				
				<p>
					<b><?php echo $lang['hdr_search'];?></b><br />
				</p>
				
				<form action="search.php" method="post" name="search" id="id_search">
				<input type="hidden" name="search_type" value="forum" />
				
				<p>
					<input type="text" name="search_text" size="20" value="<?php if (isset($search_text)) { echo $search_text;};?>" />
					<input type="image" src="<?php echo $templatePath;?>img/go.png" value="search" class="go" /><br />
				</p>
				
				</form>
			</div>
		</div>
	</div>
	
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	
	<?php
	if (isset($sidebar_topics)) {
	?>
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_topics'];?><br />
		</div>
			
		<div class="box_mid">
			<div class="content">
				<?php
				foreach($sidebar_topics as $key => $i):
				?>
				<p>
					<?php
					if (isset($topic) && $topic['topic_id'] == $i['topic_id']) {
					?>
					<?php echo $i['topic_title'];?></a><br />
					<?php
					}
					else {
					?>
					<a href="frm_view.php?topic_id=<?php echo $i['topic_id'];?>"><?php echo $i['topic_title'];?></a><br />
					<?php }?>
				</p>
				<?php
				endforeach;
				?>
				
				
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
	<?php }?>
</div>
