<?php

// This file is part of AROUNDMe
//  
// Copyright (C) 2003, 2006 Barnraiser
// http://www.barnraiser.org/
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.

$aroundme_schema                          = array();
$aroundme_schema['table_prefix']          = "am";
$aroundme_schema['table_options']         = array('mysql' => 'TYPE=INNODB');

// Table structure for table am_announce
$aroundme_schema['table'][0]['name']      = "_announce";
$aroundme_schema['table'][0]['structure'] = "
	announce_id I NOTNULL AUTO KEY,
	announce_title C(100) DEFAULT NULL,
	announce_body TEXT,
	user_id I DEFAULT NULL,
	language_id I DEFAULT NULL,
	announce_create_datetime T NOTNULL,
	announce_edit_datetime T DEFAULT NULL
";


// Table structure for table am_announce_role
$aroundme_schema['table'][0]['name']      = "_announce_role";
$aroundme_schema['table'][0]['structure'] = "
	announce_id I NOTNULL AUTO KEY,
	role_id I(3) DEFAULT NULL
";


// Table structure for table am_bookmark
$aroundme_schema['table'][1]['name']      = "_bookmark";
$aroundme_schema['table'][1]['structure'] = "
	module_id I NOTNULL,
	item_id I NOTNULL,
	inner_item_id I DEFAULT NULL,
	bookmark_type I,
	user_id I NOTNULL,
	bookmark_lastview_datetime T DEFAULT NULL,
	bookmark_alarm_datetime T DEFAULT NULL,
	bookmark_notify I,
	bookmark_batch_request I

";


// Table structure for table am_comment
$aroundme_schema['table'][2]['name']      = "_comment";
$aroundme_schema['table'][2]['structure'] = "
	comment_id I NOTNULL AUTO KEY,
	module_id I NOTNULL,
	item_id I NOTNULL,
	inner_item_id I DEFAULT NULL,
	comment_parent_id I DEFAULT NULL,
	comment_body TEXT,
	comment_create_datetime T NOTNULL,
	user_id I NOTNULL,
	item_user_id I DEFAULT NULL,
	inner_item_revision I DEFAULT NULL
";


// Table structure for table am_contact
$aroundme_schema['table'][3]['name']      = "_contact";
$aroundme_schema['table'][3]['structure'] = "
	contact_id I NOTNULL AUTO KEY,
	contact_url C(255) DEFAULT NULL,
	contact_source TEXT,
	contact_message TEXT,
	reportee_user_id I DEFAULT NULL,
	reportee_email C(50) DEFAULT NULL,
	assigned_user_id I DEFAULT NULL,
	contact_report_type I DEFAULT NULL,
	reportee_language_id I(3) DEFAULT NULL,
	report_datetime datetime T NULL,
	report_status_id I DEFAULT NULL

";


// Table structure for table am_file
$aroundme_schema['table'][4]['name']      = "_file";
$aroundme_schema['table'][4]['structure'] = "
	file_id I NOTNULL AUTO KEY,
	module_id I(3) DEFAULT NULL,
	file_type C(20) DEFAULT NULL,
	file_size I DEFAULT NULL,
	file_save_name C(255) DEFAULT NULL,
	file_md5_name C(255) DEFAULT NULL,
	file_stamp C(40) DEFAULT NULL,
	file_user_id I DEFAULT NULL,
	file_create_datetime T DEFAULT NULL,
	item_id I DEFAULT NULL
";


// Table structure for table am_file_allocation
$aroundme_schema['table'][5]['name']      = "_file_allocation";
$aroundme_schema['table'][5]['structure'] = "
	module_id I NOTNULL,
	item_id I DEFAULT NULL,
	item_type I DEFAULT NULL,
	file_allocation I NOTNULL
";


// Table structure for table am_mem_type_access
$aroundme_schema['table'][10]['name']      = "_mem_type_access";
$aroundme_schema['table'][10]['structure'] = "
	module_id I DEFAULT NULL,
	item_id I DEFAULT NULL,
	membership_type_id I(3) DEFAULT NULL
";


// Table structure for table am_participation
$aroundme_schema['table'][6]['name']      = "_participation";
$aroundme_schema['table'][6]['structure'] = "
	module_id I NOTNULL,
	item_id I NOTNULL,
	user_id I NOTNULL,
	status_id I(2) NOTNULL,
	identity_id I NOTNULL,
	participation_permission I DEFAULT NULL,
	participation_create_datetime T DEFAULT NULL,
	role_id I(1) DEFAULT NULL,
	invitee_user_id I DEFAULT NULL
";


// Table structure for table am_rate
$aroundme_schema['table'][7]['name']      = "_rate";
$aroundme_schema['table'][7]['structure'] = "
	module_id I NOTNULL,
	item_id I NOTNULL,
	inner_item_id I DEFAULT NULL,
	rate_type I(1) DEFAULT NULL,
	rate_value I(1) NOTNULL,
	user_id I NOTNULL
";


// Table structure for table am_relation
$aroundme_schema['table'][8]['name']      = "_relation";
$aroundme_schema['table'][8]['structure'] = "
	module_id I NOTNULL,
	item_id I NOTNULL,
	identity_id I NOTNULL,
	identity_id_relation I NOTNULL,
	relation_create_datetime T DEFAULT NULL,
	relation_portable I(1) DEFAULT NULL,
	user_id I DEFAULT NULL
";


// Table structure for table am_role_permission
$aroundme_schema['table'][9]['name']      = "_role_permission";
$aroundme_schema['table'][9]['structure'] = "
	role_id I(3) DEFAULT NULL,
	role_core_permission I DEFAULT NULL,
	role_mod_permission I DEFAULT NULL
";


// Table structure for table am_statistic
$aroundme_schema['table'][10]['name']      = "_statistic";
$aroundme_schema['table'][10]['structure'] = "
	module_id I DEFAULT NULL,
	item_id I DEFAULT NULL,
	statistic_type_id I(3) DEFAULT NULL,
	total I DEFAULT NULL
";


// Table structure for table am_tag
$aroundme_schema['table'][11]['name']      = "_tag";
$aroundme_schema['table'][11]['structure'] = "
	tag_id I NOTNULL AUTO KEY,
	module_id I(3) DEFAULT NULL,
	item_id I DEFAULT NULL,
	inner_item_id I DEFAULT NULL,
	tag_body C(50) DEFAULT NULL,
	user_id I DEFAULT NULL,
	level_id I(1) DEFAULT NULL
";


// Table structure for table am_template
$aroundme_schema['table'][12]['name']      = "_template";
$aroundme_schema['table'][12]['structure'] = "
	template_id I AUTO NOTNULL KEY,
	template_title C(255) DEFAULT NULL
";


// Table structure for table am_user
$aroundme_schema['table'][13]['name']      = "_user";
$aroundme_schema['table'][13]['structure'] = "
	user_id I NOTNULL AUTO KEY,
	user_core_permission I DEFAULT NULL,
	user_mod_permission I DEFAULT NULL,
	user_firstname C(100) DEFAULT NULL,
	user_surname C(100) DEFAULT NULL,
	user_email C(100) NOT NULL DEFAULT '',
	user_email_new C(100) DEFAULT NULL,
	user_dob date DEFAULT NULL,
	user_unix_name C(20) DEFAULT NULL,
	role_id I(3) DEFAULT NULL,
	membership_type_id I(3) DEFAULT NULL,
	language_id I(3) DEFAULT NULL,
	template_id I(3) DEFAULT NULL,
	location_id I DEFAULT NULL,
	user_homepage C(50) DEFAULT NULL,
	status_id I(3) DEFAULT NULL,
	invitee_user_id I DEFAULT NULL,
	invitee_identity_id I DEFAULT NULL,
	user_password C(32) NOTNULL DEFAULT '',
	user_feed_password C(6) DEFAULT NULL,
	user_create_datetime T DEFAULT NULL,
	active_time timestamp NOTNULL DEFAULT 0
";


// Table structure for table am_user_blocked
$aroundme_schema['table'][14]['name']      = "_user_blocked";
$aroundme_schema['table'][14]['structure'] = "
	user_id I DEFAULT NULL,
	user_id_blocked I DEFAULT NULL,
	block_datetime T DEFAULT NULL,
	block_description C(200) DEFAULT NULL,
	identity_id I NOTNULL
";


// Table structure for table am_user_identity
$aroundme_schema['table'][15]['name']      = "_user_identity";
$aroundme_schema['table'][15]['structure'] = "
	identity_id I NOTNULL AUTO KEY,
	user_id I DEFAULT NULL,
	identity_name C(50) DEFAULT NULL,
	identity_type I(1) DEFAULT NULL,
	identity_signature C(200) DEFAULT NULL,
	identity_gender I(1) DEFAULT NULL,
	identity_nic C(50) DEFAULT NULL,
	identity_metadata C(250) DEFAULT NULL,
	identity_allow_msg I(1) DEFAULT NULL,
	identity_allow_export I(1) DEFAULT NULL,
	identity_create_datetime T DEFAULT NULL,
	identity_edit_datetime T DEFAULT NULL,
	file_id I DEFAULT NULL,
	identity_search I(1) DEFAULT NULL
";


// Table structure for table am_user_identity_custom
$aroundme_schema['table'][16]['name']      = "_user_identity_custom";
$aroundme_schema['table'][16]['structure'] = "
	user_id I NOT NULL DEFAULT 0,
	identity_id I DEFAULT NULL,
	custom_item_id I(3) NOT NULL DEFAULT 0,
	custom_item_body C(50) NOT NULL DEFAULT ''
";


// Table structure for table am_user_invite
$aroundme_schema['table'][17]['name']      = "_user_invite";
$aroundme_schema['table'][17]['structure'] = "
	invited_email C(100) DEFAULT NULL,
	user_id I DEFAULT NULL,
	module_id I DEFAULT NULL,
	item_id I DEFAULT NULL,
	invite_create_datetime T DEFAULT NULL,
	invite_url C(200) DEFAULT NULL,
	identity_id I NOTNULL,
	default_status_id DEFAULT NULL
";


// Table structure for table am_user_language
$aroundme_schema['table'][18]['name']      = "_user_language";
$aroundme_schema['table'][18]['structure'] = "
	user_id I DEFAULT NULL,
	language_id int(3) DEFAULT NULL
";


// Table structure for table am_user_location
$aroundme_schema['table'][19]['name']      = "_user_location";
$aroundme_schema['table'][19]['structure'] = "
	location_id I(3) NOTNULL AUTO KEY,
	language_id I(3) DEFAULT NULL,
	location_name C(50) DEFAULT NULL
";


// Table structure for table am_user_message
$aroundme_schema['table'][20]['name']      = "_user_message";
$aroundme_schema['table'][20]['structure'] = "
	message_id I NOTNULL AUTO KEY,
	from_identity_id I DEFAULT NULL,
	to_identity_id I DEFAULT NULL,
	owner_user_id I DEFAULT NULL,
	message_status I(3) DEFAULT NULL,
	message_box I(3) DEFAULT NULL,
	message_subject C(50) DEFAULT NULL,
	message_body TEXT,
	message_create_datetime T DEFAULT NULL,
	message_priority I(1) DEFAULT NULL,
	message_response I(1) DEFAULT NULL
";

// Table structure for table am_user_preference
$aroundme_schema['table'][21]['name']      = "_user_preference";
$aroundme_schema['table'][21]['structure'] = "
	user_id I DEFAULT NULL,
	user_preference_id I(3) DEFAULT NULL,
	user_preference_value I(3) DEFAULT NULL
";


// Table structure for table am_user_session
$aroundme_schema['table'][22]['name']      = "_user_session";
$aroundme_schema['table'][22]['structure'] = "
	session_id I NOTNULL AUTO KEY,
	user_id I DEFAULT NULL,
	session_md5 C(32) DEFAULT NULL,
	session_lastused timestamp,
	session_firstused timestamp,
	session_ip C(15) DEFAULT NULL
";


// Table structure for table am_user_testimonial
$aroundme_schema['table'][23]['name']      = "_user_testimonial";
$aroundme_schema['table'][23]['structure'] = "
	testifier_identity_id I DEFAULT NULL,
	identity_id I DEFAULT NULL,
	testimonial_body C(255) DEFAULT NULL,
	testimonial_create_datetime T DEFAULT NULL,
	testimonial_id I NOT NULL AUTO KEY
";


// INSERT DEFAULTS -----------------------------------------

// INSERT INTO am_template VALUES (1, 'barnraiser_01');

// END OF SQL

?>