<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


// we receive a module id (mid) and item_id (iid) from which we include a
// file in the modules directory. From there we obtain the items we want
// then we format them for a feed.

include "components/core/config/aroundme_core.config.php";


// SETUP DATABASE --------------------------------------------------------
require_once('components/core/class/Adodb/adodb.inc.php');
$ADODB_CACHE_DIR = 'cache/Adodb';
$ADODB_FETCH_MODE = ADODB_FETCH_BOTH;
$ADODB_COUNTRECS = false;
$db = NewADOConnection($core_config['db']['driver']);
if (!$db->Connect($core_config['db']['host'], $core_config['db']['user'] , $core_config['db']['pass'] , $core_config['db']['db'])) {
	header("Location: components/core/error.php?error=1");
	exit;
}
$db->prefix = $core_config['db']['prefix'];


// ASERTAIN MODULE ------------------------------------------------------
if (isset($core_config['module'][$_REQUEST['mid']])) {
	// is the module_id valid
	$module_id = $_REQUEST['mid'];
}

if (isset($module_id)) {
	$suffix = $core_config['module'][$module_id]['prefix'];
	
	if (is_file("components/" . $suffix . "/inc/" . $suffix . "_feed.function.php")) {
		include_once("components/" . $suffix . "/inc/" . $suffix . "_feed.function.php");
	}
	
	$function_name = "moduleFeed_" . $suffix;
			
	if (function_exists($function_name)) {
		$source_feed = $function_name($_REQUEST['iid']);
	}
}


//SETUP RSS FEED
include('components/core/class/FeedCreator.class.php');
$rss = new UniversalFeedCreator();
$rss->useCached();
$rss->link = $_SERVER['HTTP_HOST'];
$rss->syndicationURL = $_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'];

//url
$url = "http://" . $_SERVER['HTTP_HOST'];
$url .= dirname ($_SERVER['PHP_SELF']);
$url .= "/";


//OUTPUT RSS ---------------------------------------------------------------
if (!empty($source_feed)) {
	foreach($source_feed as $key => $i):
		$item = new FeedItem();
		$item->title = $i['item_title'];
		$item->link = $url . $i['item_url'];
		$item->description = $i['item_synopsis'];
		$item->date = $db->UnixDate($i['item_create_datetime']);
		$item->source = $_SERVER['HTTP_HOST']."/";
		$item->author = $i['item_author'];
		
		$rss->addItem($item);
	endforeach;
}


	
// TIDY UP --------------------------------------------------
$db->Close();

$rss->saveFeed($core_config['rss']['output'], "cache/feed.xml");

?>