<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

// By Sebastian Öblom, last updated 21th December 2006.

ini_set('error_reporting', E_ALL);
ob_start();
session_start();
include "language.inc.php";

$tmp = dirname(__FILE__);
$tmp = explode('/', $tmp);

define ('DIR_NAME', $tmp[count($tmp) - 3] . "/");
unset($tmp);

?>
<!DOCTYPE html
PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">

<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="Content-Language" content="eng" />

<title>AROUNDMe -Install</title>
<style type="text/css">

#layout	{
	position:absolute; top:0px; left:0px; width:740px; 
	padding:10px;
	margin-left: 20px;
	margin-top: 20px;
	border: 1px solid #DCDCDC;
}

#menu {
	list-style-type: none;
	padding: 0px;
	margin: 0px;
	left: 600px;
	top: 130px;
	position: absolute;
}

#menu li {
	padding: 5px;
	margin: 0px;
	list-style-type: none;
	padding-right: 15px;
	font-weight: bold;
	color: #333;
}

#menu .active {
	color: #F494B2;
}

.content {
	min-height: 300px;
	font-size: 70%;
	margin-top: 30px;
	width: 550px;
}

a {
	text-decoration: none;
	color: #F36692;
}

input[type="text"] {
	width: 350px;
	border: 1px solid #DCDCDC;
}

textarea {
	width: 550px;
	border: 1px solid #DCDCDC;
	height: 250px;
}

input[type="submit"], input[type="button"] {
	font-size: 90%;
	font-family:Verdana,Arial,Helvetica,Geneva,sans-serif;
}

body{
	font-family:Verdana,Arial,Helvetica,Geneva,sans-serif;
	font-size: 101%; 
	color: #333333; 
	text-decoration: none;
	background-color:#FFF;
}

.message {
	background-color: #F8F8F8;
	border: 1px solid #F494B2;
	padding: 15px;
	width: 500px;
}

<?php

?>

</style>
</head>
<body>
	<div id="layout">
		<img src="../../aroundme/components/core/template/barnraiser_01/img/aroundme.png" /><br />
		<div style="padding-top: 10px; padding-right: 5px;">
			<ul id="menu">
				<li<?php if (isset($_REQUEST['step']) && $_REQUEST['step'] == 1) echo " class='active'"; ?>>step 1</li>
				<li<?php if (isset($_REQUEST['step']) && $_REQUEST['step'] == 2) echo " class='active'"; ?>>step 2</li>
				<li<?php if (isset($_REQUEST['step']) && $_REQUEST['step'] == 3) echo " class='active'"; ?>>step 3</li>
				<li<?php if (isset($_REQUEST['step']) && $_REQUEST['step'] == 4) echo " class='active'"; ?>>step 4</li>
				<li<?php if (isset($_REQUEST['step']) && $_REQUEST['step'] == 5) echo " class='active'"; ?>>step 5</li>
				<li<?php if (isset($_REQUEST['step']) && $_REQUEST['step'] == 6) echo " class='active'"; ?>>step 6</li>			
				<li<?php if (isset($_REQUEST['step']) && $_REQUEST['step'] == 7) echo " class='active'"; ?>>step 7</li>			
				<li<?php if (isset($_REQUEST['step']) && $_REQUEST['step'] == 8) echo " class='active'"; ?>>step 8</li>					
			</ul>
			<br />
			<br />
			<div class="content">
			
<?php

function am_ftp_check($arr) {
	GLOBAL $lang;
	$conn = false;	
	$state = true;
		
	if (isset($arr['frm_ftp_servername'])) {
		$conn = @ftp_connect($arr['frm_ftp_servername']);
	}
	else {
		echo $lang['error_fail_connect_server'];
		return false;
	}
		
	if ($conn && isset($arr['frm_ftp_username']) && isset($arr['frm_ftp_password'])) {
		$result = @ftp_login($conn, $arr['frm_ftp_username'], $arr['frm_ftp_password']);
	}
	else {
		echo $lang['error_fail_login_server'];
		return false;
	}
		
	if ((!$conn) || (!$result)) {
		echo $lang['error_fail_login_server'];
		return false;
   	} 
   	else {
    	$_SESSION['ftp_server']   = $arr['frm_ftp_servername'];
    	$_SESSION['ftp_username'] = $arr['frm_ftp_username'];
    	$_SESSION['ftp_password'] = $arr['frm_ftp_password'];
    	
    	$list = ftp_nlist($conn, '.');
    	

    	$dir = "/" . $list[0] . "/" . DIR_NAME; 
    	
    	$dirs = array();
    	$dirs[] = $dir;
    	$dirs[] = $dir . "aroundme/batch/";
    	$dirs[] = $dir . "aroundme/components/core/language/1/barnraiser_01/common.lang.php";
    	$dirs[] = $dir . "aroundme/components/core/config/aroundme_core.config.php";
    	
    	if (function_exists('ftp_chmod')) {
    		foreach($dirs as $d) {
    			if (!ftp_chmod($conn, 0777, $d)) {
    				echo $lang['error_fail_permission'] . $d;
	 				ftp_close($conn);
	 				return false;
    			}
    		}
    	}
    	else {
    		foreach($dirs as $d) {
    			if (!ftp_site($conn, 'CHMOD 0777 ' . $d)) {
    				echo $lang['error_fail_permission'] . $d;
	 				ftp_close($conn);
	 				return false;
    			}
    		}
    	}
  		
  		$file = dirname(dirname(dirname($_SERVER['SCRIPT_FILENAME'])."..")."..")."/aroundme/components/core/config/aroundme_core.config.php";
   		if(!copy($file, $file.".".date('Y-m-d'))) {
   			echo $lang['error_fail_create_backup'].$file;
   			ftp_close($conn);
   			return false;
   		}

   	}
  	ftp_close($conn);
   	return true;
}


	function write_config($what, $where) {
		GLOBAL $lang;		
		$file = file(dirname(dirname(dirname($_SERVER['SCRIPT_FILENAME'])."..")."..")."/aroundme/components/core/config/aroundme_core.config.php");
		$f = fopen(dirname(dirname(dirname($_SERVER['SCRIPT_FILENAME'])."..")."..")."/aroundme/components/core/config/aroundme_core.config.php","w");
		
		foreach($file as $line)
     		if (strstr($line,$where)) {
           		fputs($f,"$".$where."= '".$what."';\n");
			}
			else {
				fputs($f, $line);
			}
		fclose($f);
	}

	function am_database_check($arr) {
		GLOBAL $lang;
		
		require_once ('../../aroundme/components/core/class/Adodb/adodb.inc.php');
		
		$db = @NewADOConnection($arr['frm_database_driver']);
		
		if (isset($arr['frm_database_host']) && isset($arr['frm_database_user']) && isset($arr['frm_database_password'])) {			
			if(!@$db->Connect($arr['frm_database_host'], $arr['frm_database_user'], $arr['frm_database_password'])) {
				echo $lang['error_fail_connect_database'];
				return false;
			}
		}
		else {
			echo $lang['error_fail_connect_database'];
			return false;
		}			
		
		if (!$db || !$db->isConnected()) {
			echo $lang['error_fail_connect_database'];
			return false;
		}
		else {
			write_config($arr['frm_database_driver'], "core_config['db']['driver']");
			write_config($arr['frm_database_host'], "core_config['db']['host']");
			write_config($arr['frm_database_user'], "core_config['db']['user']");
			write_config($arr['frm_database_password'], "core_config['db']['pass']");
			$_SESSION['database_driver'] = $arr['frm_database_driver'];
			$_SESSION['database_host'] = $arr['frm_database_host'];
			$_SESSION['database_user'] = $arr['frm_database_user'];
			$_SESSION['database_password'] = isset($arr['frm_database_password']) ? $arr['frm_database_password'] : "";
			$db->Close();
			return true;
		}
		$db->Close();
		
		return false;
	}

	function createDatabase($arr) {
	
		GLOBAL $lang;	
		require_once ('../../aroundme/components/core/class/Adodb/adodb.inc.php');
		$db = NewADOConnection($_SESSION['database_driver']);
		if(!$db->Connect($_SESSION['database_host'], $_SESSION['database_user'], $_SESSION['database_password'])) {
			echo $lang['error_fail_connect_database'];
			return false;
		}
		
		if (isset($arr['frm_database_database_new']) && !empty($arr['frm_database_database_new'])) {
			$query = "CREATE DATABASE " . $arr['frm_database_database_new'];
			$result = $db->Execute($query);
	
			if (!$result) {
				echo $lang['error_fail_create_database'] . $arr['frm_database_database_new'];
				return false;
			}
		}
		
		if (isset($arr['frm_database_database_new']) && $arr['frm_database_database_new'] != '') {
			$_SESSION['database_database'] = $arr['frm_database_database_new'];
		}
		else {
			$_SESSION['database_database'] = $arr['frm_database_database'];
		}
		$db->Close();
		
		if(!$db->Connect($_SESSION['database_host'], $_SESSION['database_user'], $_SESSION['database_password'], $_SESSION['database_database'])) {
			echo $lang['error_fail_connect_database'];
			return false;
		}
		else {
			
			write_config($_SESSION['database_database'], "core_config['db']['db']");
			include "aroundme.sql.php";
			if ($arr['frm_database_table_prefix'] != '') {
				$table_prefix  = $arr['frm_database_table_prefix'];
				write_config($arr['frm_database_table_prefix'], "core_config['db']['prefix']");					
			}
			else {
				$table_prefix  = $aroundme_schema['table_prefix'];
				write_config($aroundme_schema['table_prefix'], "core_config['db']['prefix']");
			}	
	
			if (!isset($arr['frm_send_2'])) {
  				$dict = NewDataDictionary($db);
  				$table_options = $aroundme_schema['table_options'];
  				foreach($aroundme_schema['table'] as $t) {
  					$sqlarray = $dict->CreateTableSQL($table_prefix . $t['name'], $t['structure'], $table_options);
					if($dict->ExecuteSQLArray($sqlarray) != 2) {
						$db->Close();
						echo $lang['error_fail_create_database'];
						return false;
					}
  				}
  			}
		}
		$db->Close();
		return true;
	}
	
	function selDatabases() {
		require_once ('../../aroundme/components/core/class/Adodb/adodb.inc.php');
		$db = NewADOConnection($_SESSION['database_driver']);
		
		if(!$db->Connect($_SESSION['database_host'], $_SESSION['database_user'], $_SESSION['database_password'])) {
			echo $lang['error_fail_connect_database'];
			return false;
		}

		$query = "SHOW databases";		
		$result = $db->Execute($query);
	
		while(!$result->EOF) {
			if (isset($_POST['frm_database_database']) && $_POST['frm_database_database'] == $result->fields[0]) {
				echo "<option value='".$result->fields[0]."' selected='selected'>".$result->fields[0]."</option>\n";
			}
			else {
				echo "<option value='".$result->fields[0]."'>".$result->fields[0]."</option>\n";	
			}
			$result->moveNext();
		}
		$result->Close();
		$db->Close();
	}
	
	function am_check_email($arr) {
		GLOBAL $lang;
		if (!is_numeric($arr['frm_email_port'])) {
			echo "port is not numeric";
			return false;
		}
		if (1==2) { // check if valid email-address here
			return false;
		}
		
		
		include "../../aroundme/components/core/class/Mail/class.phpmailer.php";
		
		$mail = new PHPMailer(array('host' => $arr['frm_email_host'], 
									'port' => $arr['frm_email_port'], 
									'mailer' => $arr['frm_email_mailer'], 
									'default_address' => $arr['frm_email_default'],
									'from_name' => $arr['frm_email_from_name'],
									'wordwrap' => 80));
		
		$mail->Subject = $lang['txt_mail_check_subject'];
		$mail->Body = $lang['txt_mail_check_body'];
		$mail->AddAddress($arr['frm_email_my']);
		
		if (!$mail->Send()) {
			echo $lang['txt_error_send_email'];
			return false;
		}
		
		$_SESSION['email_host'] = $arr['frm_email_host'];
		$_SESSION['email_port'] = $arr['frm_email_port'];
		$_SESSION['email_mailer'] = $arr['frm_email_mailer'];
		$_SESSION['email_default_address'] = $arr['frm_email_default'];
		$_SESSION['email_from_name'] = $arr['frm_email_from_name'];
		$_SESSION['email_wordwrap'] = 80;
		return true;
	}
	
	function am_email_save($arr) {
		write_config($arr['frm_email_host'], "core_config['mail']['host']");
		write_config($arr['frm_email_port'], "core_config['mail']['port']");
		write_config($arr['frm_email_mailer'], "core_config['mail']['mailer']");
		write_config($arr['frm_email_default'], "core_config['mail']['default_address']");
		write_config($arr['frm_email_from_name'], "core_config['mail']['from_name']");
		write_config($arr['frm_email_no_reply'], "core_config['mail']['no_reply_address']");
	}


?>