<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


// MAIN INCLUDES ------------------------------------------------------------------
include ("components/core/config/core.config.php");


// SESSION HANDLER -------------------------------------------------------
// sets up all session and global vars 
session_name($core_config['node']['php_session_name']);
session_start();

$_SESSION['language_code'] = $core_config['language']['pack'][$core_config['language']['default_pack_id']];

$script_name = "about";


// SETUP LANGUAGE ------------------------------------------
$lang = array();
$language_path_core = "components/core/language/" . $_SESSION['language_code'] . "/";
include_once($language_path_core . 'common.lang.php');
include_once($language_path_core . 'about.lang.php');

$template_path_core = "components/core/template/";

require_once('components/core/class/Template.class.php');
$tpl = new Template();
$body = new Template();

if (isset($_REQUEST['v']) && $_REQUEST['v'] == "policy") {
	$body->set('display', "policy");
}
elseif (isset($_REQUEST['v']) && $_REQUEST['v'] == "create_webspace" && $core_config['am']['webspace_creation_type'] === 1 || $core_config['am']['webspace_creation_type'] === 2) {
	$body->set('display', "create_webspace");
}
elseif (isset($_REQUEST['v']) && $_REQUEST['v'] == "service") {
	$body->set('display', "service");
}
elseif (isset($_REQUEST['v']) && $_REQUEST['v'] == "software") {
	$body->set('display', "software");
}



$tpl->set('lang', $lang);
$body->set('lang', $lang);
$tpl->set('template_path_core', $template_path_core);
$body->set('template_path_core', $template_path_core);
$body->set('core_config', $core_config);
$tpl->set('core_config', $core_config);
$tpl->set('script_name', $script_name);



$template_file = "about.tpl.php";
$tpl->set('content', $body->fetch("components/core/template/about.tpl.php"));

echo $tpl->fetch("components/core/template/wrapper.tpl.php");

?>