<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


class Webspace {

	// the constructor
	// Tom Calthrop, 26th March 2007
	//
	function Webspace($db) {
		$this->db = $db;
	} //EO Webpage



	// selWebSpace
	// Tom Calthrop, 26th March 2007
	// // selects the webspace and current page
	function selWebSpace () {

		$query = "
			SELECT ws.webspace_id, ws.language_code, ws.webspace_description,
			ws.webspace_keywords, ws.default_webpage_id, ws.webspace_css,
			ws.webspace_create_datetime, ws.webspace_title, ws.webspace_locked,
			wp.webpage_id, wp.webpage_title, wp.webpage_body, wp.webpage_name,
			owner_connection_id, default_permission, ws.status_id 
			FROM " . $this->db->prefix . "_webspace ws, " . $this->db->prefix . "_webpage wp 
			WHERE
			ws.webspace_id=wp.webspace_id AND "
		;

		if (isset($this->webpage_name)) {
			$query .= "wp.webpage_name=" . $this->db->qstr($this->webpage_name) . " AND ws.webspace_id=" . $this->webspace_id . " AND ";
		}
		elseif (isset($this->webpage_id)) {
			$query .= "wp.webpage_id=" . $this->webpage_id . " AND ";
		}
		elseif (isset($this->webspace_id)) {
			 $query .= "ws.webspace_id=" . $this->webspace_id . " AND ws.default_webpage_id=wp.webpage_id AND ";
		}
		elseif (isset($this->webspace_unix_name)) {
			 $query .= "ws.webspace_unix_name=" . $this->db->qstr($this->webspace_unix_name) . " AND ws.default_webpage_id=wp.webpage_id AND ";
		}

		$query .= "1=1";
		
		$result = $this->db->Execute($query);
		
		if (isset($result[0])) {
			$this->webspace_id = $result[0]['webspace_id'];
			
			return $result[0];
		}
	} // EO selWebSpace



	// selBlocks
	// Tom Calthrop, 26th March 2007
	// // selects the webspace blocks
	function selBlocks () {

		$query = "
			SELECT webblock_tag, webblock_body
			FROM " . $this->db->prefix . "_webblock 
			WHERE
			webspace_id=" . $this->webspace_id
		;
		
		$result = $this->db->Execute($query);
		
		if (isset($result)) {
			return $result;
		}
	}


	// selWebPages
	// Tom Calthrop, 26th March 2007
	// // selects the webpages for a webspace
	function selWebPages ($webpage_name = null) {

		$query = "
			SELECT DISTINCT webpage_name
			FROM " . $this->db->prefix . "_webpage
			WHERE
			webspace_id=" . $this->webspace_id
		;

		if (isset($webpage_name)) {
			$query .= " AND webpage_name=" . $this->db->qstr($webpage_name);
		}

		$result = $this->db->Execute($query);
		
		if (isset($result)) {
			$pages = array();

			foreach ($result as $key => $i):
				array_push($pages, $i['webpage_name']);
			endforeach;
				
			return $pages;
		}
	} // EO selWebPages
}


?>