<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// -----------------------------------------------------------------------
?>

<div class="plugin_blog_item">
	<?php
	if(isset($_SESSION['connection_permission']) && checkPermission('blog', 'add_blog', $_SESSION['connection_permission']) || isset($_SESSION['connection_permission']) && checkPermission('blog', 'blog_maintain', $_SESSION['connection_permission'])) {
	?>
	<div class="plugin_blog_metadata_top">
		<?php
		if(isset($_SESSION['connection_permission']) && checkPermission('blog', 'add_blog', $_SESSION['connection_permission'])) {
		?>
		<a href="index.php?ws=<?php echo $webspace['webspace_id'];?>&amp;wp=<?php echo $webspace['webpage_id'];?>&amp;t=edit_blog&amp;c=blog"><?php echo $lang['href_add_blog'];?></a>
		
		<?php }?>

		<?php
		if(isset($_SESSION['connection_permission']) && checkPermission('blog', 'blog_maintain', $_SESSION['connection_permission'])) {
		?>
		&nbsp;&#124;&nbsp;
		
		<a href="index.php?ws=<?php echo $webspace['webspace_id'];?>&amp;wp=<?php echo $webspace['webpage_id'];?>&amp;t=maintain_blog&amp;c=blog"><?php echo $lang['href_maintain_blog'];?></a>
		<?php }?>
	</div>
	<?php }?>

	
	<?php
	if (isset($blog)) {
	?>
	<h1><?php echo ucfirst($blog['blog_title']);?></h1>
		
	<p>
		<?php echo $blog['blog_body'];?><br />
	</p>
	
	<div class="plugin_blog_metadata">
		<?php echo am_strftime($blog['blog_create_datetime']);?>

		<?php
		if (!empty($blog['blog_edit_datetime'])) {
		?>
		&nbsp;(<?php echo $lang['txt_last_edited']; ?>: <?php echo am_strftime($blog['blog_edit_datetime'],1);?>)&nbsp;&#124;&nbsp;
		<?php }?>

		<a href="#tag_box_content" onclick="javascript:getTags('blog', <?php echo $blog['blog_id'];?>, <?php echo $webspace['webpage_id'];?>);"><?php echo $lang['txt_tags']; ?></a>

		&nbsp;&#124;&nbsp;

		<?php
		if (isset($_SESSION['connection_id']) && $_SESSION['connection_id'] == $blog['connection_id']) {
		?>
		<a href="index.php?ws=<?php echo $webspace['webspace_id'];?>&amp;t=edit_blog&amp;c=blog&amp;wp=<?php echo $webspace['webpage_id'];?>&amp;blog_id=<?php echo $blog['blog_id'];?>"><?php echo $lang['href_edit'];?></a>

		&nbsp;&#124;&nbsp;
		<?php }?>

		<a href="<?php echo $blog['connection_openid'];?>"><?php echo $blog['connection_nickname']?></a><br />
	</div>
	<?php
	}
	else {
	?>
	<p>
		<?php echo $lang['err_no_blog'];?><br />
	</p>
	<?php }?>

	<?php
	if (isset($blog)) {
		$plugin_name = "blog";
		$tag_item_id = $blog['blog_id'];
		include($template_path_core . "inc/tags.inc.php");
	}
	?>
</div>