<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// -----------------------------------------------------------------------

if (isset($_SESSION['connection_id'])) {
	require_once($language_path . 'file.lang.php');
	
	
	if (isset($_POST['submit_file_upload'])) {
		
		if (isset($_FILES['frm_file']) && !empty($_FILES['frm_file']['tmp_name'])) {
			
			if (isset($_POST['file_width']) && !empty($_POST['file_width'])) { // user has specified a width
			
				if (is_numeric($_POST['file_width']) && $_POST['file_width'] > 0) {
					$file_width = $_POST['file_width'];
				}
				else {
					$GLOBALS['am_error_log'][] = array('width_not_numeric');
				}
			}
		}
		else {
			$GLOBALS['am_error_log'][] = array('file_not_set');
		}
		
		if (empty($GLOBALS['am_error_log'])) {
			
			// find out thie mime-type
			if (function_exists('finfo_open')) {
				$resource = finfo_open(FILEINFO_MIME);
				$mime_type = finfo_file($resource, $_FILES['frm_file']['tmp_name']);
				finfo_colse($resource);
			}
			elseif (function_exists('mime_content_type')) {
				$mime_type = mime_content_type($_FILES['frm_file']['tmp_name']);
			}
			else {
				$mime_type = $_FILES['frm_file']['type'];
			}
			
			
			// Do some mapping of mime-types
			if (!empty($core_config['file']['browser_path'])) {
				foreach($core_config['file']['browser_path'] as $i):
					if ($i['from'] == $mime_type) {
						$mime_type = $i['to'];
					}
				endforeach;
			}
			
			
			// Is the mime-type allowed?
			if (!validateMimeType($core_config['file']['mime'], $mime_type)) {
				$GLOBALS['am_error_log'][] = array('not_valid_mime');
			}
			
			// Do we have enough space to upload the file?
			$query = "
				SELECT webspace_allocation
				FROM " . $db->prefix . "_webspace
				WHERE webspace_id=" . $_REQUEST['ws']
			;
			
			$result = $db->Execute($query);
			
			if (isset($result[0]) && isset($result[0]['webspace_allocation'])) {
				$file_allocation = $result[0]['webspace_allocation'];
				unset($result);
				
				$query = "
					SELECT SUM(f.file_size) AS allocation_used
					FROM " . $db->prefix . "_file f
					WHERE f.webspace_id=" . $_REQUEST['ws']
				;
				
				$result = $db->Execute($query);
				
				if (isset($result[0])) {
					$file_allocation_used = $result[0]['allocation_used'];
					unset($result);
					
					if ($file_allocation_used + round($_FILES['frm_file']['size']/1000) > $file_allocation) {
						$GLOBALS['am_error_log'][] = array('not_enough_space');
					}
				}
				else {
					$GLOBALS['am_error_log'][] = array('not_enough_space');
				}
			}
			else { 
				$GLOBALS['am_error_log'][] = array('not_enough_space');
			}
			
			// move the file
			if (empty($GLOBALS['am_error_log'])) {
				
				$destination = $core_config['file']['dir'];
				
				if (!is_dir($destination . "files/")) {
					mkdir($destination . "files/");
				}
			
				if (!is_dir($destination . "thumbs/")) {
					mkdir($destination . "thumbs/");
				}
				
				$stamp = microtime();
				$md5_name = md5($stamp); // we name the file to this
				
				if (@move_uploaded_file($_FILES['frm_file']['tmp_name'], $destination . "files/" . $md5_name)) {
					
					if ($mime_type == "image/gif" || $mime_type == "image/jpeg" || $mime_type == "image/png") {
						
						$image_size = getimagesize($destination . "files/" . $md5_name);
						
						if ($image_size[0] >= $image_size[1]) { // width > height
							// scale the image to new height
							$height = $core_config['file']['thumbnail']['height'];
							$width = $image_size[0] * ($height / $image_size[1]);
	
							// we create a thumbnail
							$type            = explode('/', $mime_type);
							$imagecreatefrom = 'imagecreatefrom' . $type[1];
							$image           = 'image' . $type[1];
    			
							$new_image   = $imagecreatefrom($destination . "files/" . $md5_name);
							$blank_image = ImageCreateTrueColor($width, $height);
							$col         = imagecolorallocate($blank_image, 255, 255, 255);
							imagefilledrectangle($blank_image, 0, 0, $width, $height, $col);
							$newimage    = ImageCopyResampled($blank_image, $new_image, 0, 0, 0, 0, $width, $height, $image_size[0], $image_size[1]);
							$image($blank_image, $destination . "thumbs/" . $md5_name . "_t");
							$new_image = $imagecreatefrom($destination . "thumbs/" . $md5_name . "_t");
							$blank_image = ImageCreateTrueColor($core_config['file']['thumbnail']['width'], $core_config['file']['thumbnail']['height']);
							$col         = imagecolorallocate($blank_image, 255, 255, 255);
							imagefilledrectangle($blank_image, 0, 0, $core_config['file']['thumbnail']['width'], $core_config['file']['thumbnail']['height'], $col);
							$newimage    = imagecopy($blank_image, $new_image, 0, 0, ($width - $core_config['file']['thumbnail']['width']) / 2, 0, $core_config['file']['thumbnail']['width'], $core_config['file']['thumbnail']['height']);
							@unlink($destination . "thumbs/" . $md5_name . "_t");
							$image($blank_image, $destination . "thumbs/" . $md5_name . "_t");
						}
						else {
							// scale the image to new width
							$width = $core_config['file']['thumbnail']['width'];
							$height = $image_size[1] * ($width / $image_size[0]);
							
							// we create a thumbnail
							$type            = explode('/', $mime_type);
							$imagecreatefrom = 'imagecreatefrom' . $type[1];
							$image           = 'image' . $type[1];
    			
							$new_image   = $imagecreatefrom($destination . "files/" . $md5_name);
							$blank_image = ImageCreateTrueColor($width, $height);
							$col         = imagecolorallocate($blank_image, 255, 255, 255);
							imagefilledrectangle($blank_image, 0, 0, $width, $height, $col);
							$newimage    = ImageCopyResampled($blank_image, $new_image, 0, 0, 0, 0, $width, $height, $image_size[0], $image_size[1]);
							$image($blank_image, $destination . "thumbs/" . $md5_name . "_t");
							$new_image = $imagecreatefrom($destination . "thumbs/" . $md5_name . "_t");
							$blank_image = ImageCreateTrueColor($core_config['file']['thumbnail']['width'], $core_config['file']['thumbnail']['height']);
							$col         = imagecolorallocate($blank_image, 255, 255, 255);
							imagefilledrectangle($blank_image, 0, 0, $core_config['file']['thumbnail']['width'], $core_config['file']['thumbnail']['height'], $col);
							$newimage    = imagecopy($blank_image, $new_image, 0, 0, 0,($height - $core_config['file']['thumbnail']['height']) / 2 , $core_config['file']['thumbnail']['width'], $core_config['file']['thumbnail']['height']);
							@unlink($destination . "thumbs/" . $md5_name . "_t");
							$image($blank_image, $destination . "thumbs/" . $md5_name . "_t");
						}
						
						if (isset($_POST['file_width']) && is_numeric($_POST['file_width']) && $_POST['file_width'] > 1) {
							$width = $_POST['file_width'];
							$height = $image_size[1] * ($width / $image_size[0]);
							
							$type            = explode('/', $mime_type);
							$imagecreatefrom = 'imagecreatefrom' . $type[1];
							$image           = 'image' . $type[1];
    			
							$new_image   = $imagecreatefrom($destination . "files/" . $md5_name);
							$blank_image = ImageCreateTrueColor($width, $height);
							$col         = imagecolorallocate($blank_image, 255, 255, 255);
							imagefilledrectangle($blank_image, 0, 0, $width, $height, $col);
							$newimage    = ImageCopyResampled($blank_image, $new_image, 0, 0, 0, 0, $width, $height, $image_size[0], $image_size[1]);
							@unlink($destination . $md5_name);
							$image($blank_image, $destination . "files/" . $md5_name);
						}
					}
					
					// we insert a record of the file in the database
					$data = array();
					$data['file_type'] = $mime_type;
					$data['file_size'] = round($_FILES['frm_file']['size']/1000);
					$data['file_md5_name'] = $md5_name;
					$data['file_create_datetime'] = time();
					$data['webspace_id'] = $_REQUEST['ws'];
					$data['connection_id'] = $_SESSION['connection_id'];
					
					if (isset($_POST['frm_file_name']) && !empty($_POST['frm_file_name'])) {
						$data['file_title'] = $_POST['frm_file_name'];
					}
					else {
						$data['file_title'] = $_FILES['frm_file']['name'];
					}
					
					$table = $db->prefix . "_file";
					$db->insertDB($data, $table);
					
					if (in_array($mime_type, array("image/gif", "image/jpeg", "image/png"))) {
						header("location: index.php?ws=" . $_REQUEST['ws'] . "&t=file&file_md5_name=" . $md5_name);
						exit;
					}
					else {
						header("location: index.php?ws=". $_REQUEST['ws'] . "&t=file");
						exit;
					}
				}
				else {
					$GLOBALS['am_error_log'][] = array('file_not_uploaded'); 
				}
			}
		}
	}
	elseif (isset($_REQUEST['file_md5_name'])) {
		
		$temp = explode('_', $_REQUEST['file_md5_name']);
		$query = "
			SELECT *
			FROM " . $db->prefix . "_file
			WHERE webspace_id=" . $_REQUEST['ws'] . " AND
			file_md5_name='" . $temp[0] . "'"
		;
	
		$result = $db->Execute($query);
		
		if (isset($result[0]['file_id']) && isset($result[0]['file_type']) && in_array($result[0]['file_type'], array('image/gif', 'image/jpeg', 'image/png'))) {
			
			$image_size = @getimagesize($core_config['file']['dir'] . "files/" . $result[0]['file_md5_name']);
			
			$result[0]['file_width'] = $image_size[0];
			$result[0]['file_height'] = $image_size[1];
			$result[0]['file_md5_name'] .= '_' . $result[0]['file_type'];
			$result[0]['local_path'] = 'components/core/relay/get_file.php?file=' . $result[0]['file_md5_name'];
	
			if (substr($_SERVER["HTTP_HOST"], -1, 1) == "/") {
				$server_path = 'http://' . substr($_SERVER["HTTP_HOST"], 0, -1);
			}
			else {
				$server_path = 'http://' . $_SERVER["HTTP_HOST"];
			}
	
			$result[0]['global_path'] = $server_path . dirname($_SERVER['PHP_SELF']) . '/' . $result[0]['local_path'];
			
			$body->set('file_image', $result[0]);
		}
	}
	elseif (isset($_POST['delete_file']) && !empty($_POST['file_id'])) {
		
		// We need to see if the file is there
		$query = "
			SELECT *
			FROM " . $db->prefix . "_file
			WHERE file_id=" . $_POST['file_id'] . " AND 
			webspace_id=" . $_REQUEST['ws']
		;
	
		$result = $db->Execute($query);
		
		if (isset($result[0]) && isset($result[0]['file_id'])) {
			
			$temp = $result[0]['file_md5_name'];
			if (is_file($core_config['file']['dir'] . "files/" . $temp)) {
				if (@unlink($core_config['file']['dir'] . "files/" . $temp)) {
					if (is_file($core_config['file']['dir'] . "thumbs/" . $temp . '_t')) {
						@unlink($core_config['file']['dir'] . "thumbs/" . $temp . '_t');
					}
					
					// remove the entry from the database
					$query = "
						DELETE
						FROM " . $db->prefix . "_file
						WHERE file_id=" . $result[0]['file_id']
					;
					
					$db->Execute($query);
				}
			}
			else {
				$GLOBALS['am_error_log'][] = array('file_not_deleted');
			}
		}
		else {
			$GLOBALS['am_error_log'][] = array('file_not_deleted_database');
		}
	}
	elseif (isset($_POST['delete_files']) && !empty($_POST['delete_file'])) {
		
		$query = "
			SELECT *
			FROM " . $db->prefix . "_file
			WHERE file_id in (" . implode(', ', array_keys($_POST['delete_file'])) . ")"
		;
		
		$result = $db->Execute($query);
		
		if (isset($result[0])) {
			foreach($result as $r):
				if (is_file($core_config['file']['dir'] . $r['file_md5_name'])) {
					@unlink ($core_config['file']['dir'] . $r['file_md5_name']);
				}
				
				if (is_file($core_config['file']['dir'] . "thumbs/" . $r['file_md5_name'] . '_t')) {
					@unlink ($core_config['file']['dir'] . "thumbs/" . $r['file_md5_name'] . '_t');
				}
			endforeach;
		}
		else {
			$GLOBALS['am_error_log'][] = array('files_not_deleted');
		}
		
		
		$query = "
			DELETE
			FROM " . $db->prefix . "_file
			WHERE webspace_id=" . $_REQUEST['ws'] . " AND
			file_id IN (" . implode(', ', array_keys($_POST['delete_file'])) . ")"
		;
		
		$db->Execute($query);
	}
	
	$output_files = array();
	
	// fetch the files (image) for this webspace
	$query = "
		SELECT *
		FROM " . $db->prefix . "_file
		WHERE webspace_id=" . $_REQUEST['ws'] . " AND
		file_type LIKE 'image/%'
		ORDER BY file_create_datetime DESC"
	;
	
	$result = $db->Execute($query);
	
	if (isset($result)) {
		$output_files['images'] = $result;
	
		foreach ($output_files['images'] as $key => $i):
			$output_files['images'][$key]['file_md5_name'] .= '_' . $i['file_type'];
		endforeach;
	}
	else {
		$GLOBALS['am_error_log'][] = "error 6";
	}
	
	// fetch the files (application) for this webspace
	$query = "
		SELECT *
		FROM " . $db->prefix . "_file
		WHERE webspace_id=" . $_REQUEST['ws'] . " AND
		(file_type LIKE 'application/%' OR file_type LIKE 'text/%')"
	;
	
	if (isset($_REQUEST['sort_by']) && !empty($_REQUEST['sort_by'])) {
		$query .= " ORDER BY " . $_REQUEST['sort_by'];
		
		if (isset($_REQUEST['desc']) && $_REQUEST['desc'] == 1) {
			$query .= " DESC";
		}
	}
	else {
		$query .= " ORDER BY file_create_datetime DESC";
	}
	
	$result = $db->Execute($query);
	
	if (isset($result)) {
		$output_files['application'] = $result;
	
		foreach($output_files['application'] as $key => $i):
			$output_files['application'][$key]['file_md5_name'] .= '_' . $i['file_type'];
			$output_files['application'][$key]['local_path'] = 'components/core/relay/get_file.php?file=' . $i['file_md5_name'] . '_' . $i['file_type'];
			$output_files['application'][$key]['global_path'] = 'http://' . $_SERVER["HTTP_HOST"] . dirname($_SERVER['PHP_SELF']) . '/' . $output_files['application'][$key]['local_path'];
		endforeach;
	}
	else {
		$GLOBALS['am_error_log'][] = "error 9";
	}
	
	// fetch the files (video) for this webspace
	$query = "
		SELECT *
		FROM " . $db->prefix . "_file
		WHERE webspace_id=" . $output_webspace['webspace_id'] . " AND
		file_type LIKE 'video/%'
		ORDER BY file_create_datetime DESC"
	;
	
	$result = $db->Execute($query);
	
	if (isset($result)) {
		$output_files['video'] = $result;
	
		foreach($output_files['video'] as $key => $i):
			$output_files['video'][$key]['file_md5_name'] .= '_' . $i['file_type'];
		endforeach;
	}
	else {
		$GLOBALS['am_error_log'][] = "error 9";
	}
	
	
	
	if (!empty($output_files)) {
		$body->set('files', $output_files);
	}
	
	
	// file statistics
	$allocation = array();
	$allocation['allocation'] = 0;
	$allocation['allocation_used'] = 0;
	
	$query = "
		SELECT webspace_allocation
		FROM " . $db->prefix . "_webspace
		WHERE webspace_id=" . $_REQUEST['ws']
	;
	
	$result = $db->Execute($query);
	
	if (isset($result[0])) {
		$allocation['allocation'] = $result[0]['webspace_allocation'];
	}
	
	$query = "
		SELECT SUM(f.file_size) AS allocation_used
		FROM " . $db->prefix . "_file f
		WHERE f.webspace_id=" . $_REQUEST['ws']
	;
	
	$result = $db->Execute($query);
	
	if (isset($result[0])) {
		$allocation['allocation_used'] = $result[0]['allocation_used'];
	}
	
	$body->set('file_statistics', $allocation);
}
else { // no permission to be here
	header("Location: index.php?ws=" . $_REQUEST['ws']);
	exit;
}
	

function validateMimeType($mimes, $mime_type) {

	foreach($mimes as $m) {
		if ($m['mime'] == $mime_type) {
			return 1;
		}
	}
	return 0;
}

?>