<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// -----------------------------------------------------------------------


// MAIN INCLUDES ---------------------------------------------------------
include ("../components/core/config/core.config.php");

// SETUP DATABASE ------------------------------------------------------
require_once('../components/core/class/Db.class.php');
$db = new Database($core_config['db']);


// SETUP WEBSPACE ------------------------------------------------------
$query = "
	SELECT webspace_locked, language_code, webspace_description,
	webspace_title, webspace_unix_name, webspace_id 
	FROM " . $db->prefix . "_webspace
	WHERE
	webspace_id=" . $_REQUEST['ws']
;

$result = $db->Execute($query, 1);

if (isset($result[0])) {
	$output_webspace = $result[0];
}


if (!empty($output_webspace)) {
	if (empty($output_webspace['webspace_locked'])) {

		// //create URL
		$url = "http://" . $_SERVER['HTTP_HOST'];
		$url .= dirname ($_SERVER['PHP_SELF']);
		//sometimes the server adds / as the last character - we need to check.
		if (substr($url, -1, 1) != "/") {
			$url .= "/";
		}

		$url .= "../";


		$plugin_rss_comment_queries = array(); // init the array
		$plugin_rss_queries = array(); // init the array

		
		// include files 
		foreach (glob('../components/*/inc/plugin_rss.inc.php') as $f):
			require_once $f;
		endforeach;
		
		if (isset($_REQUEST['v']) && $_REQUEST['v'] == "comments") { // we create RSS items from comments
			
			$query = implode(' UNION ', $plugin_rss_comment_queries);
			$query .= " ORDER BY datetime";
			$result = $db->Execute($query);

			
			$items = array();
			
			if (!empty($result)) {
				foreach($result as $key => $p):
					$function_name = "am_plugin_" . $p['plugin_name'] . "_getRSSLink";
	
					if (function_exists($function_name)) {
						$p['link'] = $url . $function_name($p['item_id'], $p['webpage_id'], $p['webspace_id']) . "#comment_id" . $p['comment_id'];;
					}

					$p['description'] = strip_tags($p['description']);
					
					if (strlen($p['description']) > 220) {
						$p['description'] = substr_replace($p['description'], '...', 220);
					}
					
					$p['description'] = htmlspecialchars($p['description']);
	
					array_push($items, $p);
				endforeach;
			}

		}
		else { // We create RSS items from plugin content
			
			$query = implode(' UNION ', $plugin_rss_queries);
			$query .= " ORDER BY datetime";
			$result = $db->Execute($query);
			
			
			$items = array();
			
			if (!empty($result)) {
				foreach($result as $key => $p):
					$function_name = "am_plugin_" . $p['plugin_name'] . "_getRSSLink";
	
					if (function_exists($function_name)) {
						$p['link'] = $url . $function_name($p['item_id'], $p['webpage_id'], $p['webspace_id']);
					}

					$p['description'] = strip_tags($p['description']);
					
					if (strlen($p['description']) > 220) {
						$p['description'] = substr_replace($p['description'], '...', 220);
					}
					
					$p['description'] = htmlspecialchars($p['description']);
	
					array_push($items, $p);
				endforeach;
			}
		}
		
		if (empty($output_webspace['language_code'])) {
			$output_webspace['language_code'] = "en";
		}

		// build the source url
		if (!empty($core_config['am']['mode']) && $core_config['am']['mode'] > 0) { // single webspace configuration
			$domain_url = "http://" . $_SERVER['HTTP_HOST'];
		}
		else {
			$domain_parts = explode('.', $_SERVER['HTTP_HOST'], 2);
			$domain = $domain_parts[1];
		
			$domain_url = "http://" . $output_webspace['webspace_unix_name'] . "." . $domain;
		}
		
		header("Content-Type: application/xml; charset=ISO-8859-1");
		
		echo "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\n";
		echo "<?xml-stylesheet title=\"XSL_formatting\" type=\"text/xsl\" href=\"nolsol_" . $output_webspace['language_code'] . ".xsl\"?>\n";
		echo "<rss version=\"2.0\">\n";
		echo "<channel>\n";
		echo "<title>" . utf8_decode($output_webspace['webspace_title']) . "</title>\n";
		echo "<link>" . $domain_url . "</link>\n";
		echo "<description>" . utf8_decode($output_webspace['webspace_description']) . "</description>\n";
		echo "<language>" . $output_webspace['language_code'] . "</language>\n";
		echo "<lastBuildDate>" . date("r") . "</lastBuildDate>\n";
		
		if (!empty($items)) {
			foreach ($items as $key => $i):
				echo "<item>\n";
				echo "<title>" . utf8_decode($i['title']) . "</title>\n";
				echo "<description>" . utf8_decode($i['description']) . "</description>\n";
				echo "<link>" . $i['link'] . "</link>\n";
				echo "<pubDate>" . $i['datetime'] . "</pubDate>\n";
				echo "</item>";
			endforeach;
		}
		
		echo "</channel>\n";
		echo "</rss>";
	}
}
?>