<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


// PLUGIN: Barnraiser Blog

function plugin_blog ($attributes=null) {
	
	global $db, $ws, $output_webspace, $body;
	

	// PREPARE BLOCKS --------------------------------------------------------
	if (!isset($attributes['block'])) {
		$attributes['block'] = "blogs";
	}

	if ($attributes['block'] == "blogs") { // select multiple blogs
	
		$query = "
			SELECT b.blog_id, b.blog_title, b.blog_body, b.webpage_id
			FROM " . $db->prefix . "_plugin_blog b "
		;
		
		if (!empty($attributes['webpagename'])) {
			$query .= ", " . $db->prefix . "_webpage wp ";
		}

		$query .= "
			WHERE 
			b.webspace_id=" . $output_webspace['webspace_id'] . " AND 
			b.blog_archived IS NULL AND "
		;

		if (!empty($attributes['webpagename'])) {
			$query .= "
				wp.webspace_id=" . $output_webspace['webspace_id'] . " AND
				wp.webpage_id=b.webpage_id AND
				wp.webpage_name=" . $db->qstr($attributes['webpagename']) . " AND "
			;
		}
		
		$query .= "1=1 ORDER BY b.blog_create_datetime";
		
		if (!isset($attributes['order'])) {
			$query .= " desc";
		}
		
		if (isset($attributes['limit'])) {
			$result = $db->Execute($query, (int) $attributes['limit']);
		}
		else {
			$result = $db->Execute($query);
		}

		if (!empty($result)) {

			$link = "index.php?ws=" . $output_webspace['webspace_id'];

			foreach($result as $key => $i):
				$result[$key]['blog_body'] = strip_tags($result[$key]['blog_body']);

				if (strlen($result[$key]['blog_body']) > 80) {
					$result[$key]['blog_body'] = str_replace_dots($result[$key]['blog_body'], 80);
				}

				$result[$key]['link'] = $link . "&amp;wp=" . $i['webpage_id'] . "&amp;blog_id=" . $i['blog_id'];

			endforeach;
		}
		elseif (isset($_SESSION['connection_permission']) && checkPermission('blog', 'add_blog', $_SESSION['connection_permission']) && !empty($attributes['webpagename'])) {
			// We append the "no blogs" with a hint on how to add a blog entry
			global $lang;

			$url = "index.php?ws=" . $output_webspace['webspace_id'] . "&amp;wpn=" . $attributes['webpagename'];

			// check that the page is a valid page name
			$webpage_exists = $ws->selWebPages($attributes['webpagename']);

			if (!isset($webpage_exists[0]['webpage_name'])) {
				// we have a new page
				$url = "index.php?ws=" . $output_webspace['webspace_id'] . "&amp;t=admin_webpage&amp;wp=" . $output_webspace['webpage_id'] . "&amp;wpn=" . $attributes['webpagename'];
				$err_display_no_blogs = "<interlink name=\"" . $attributes['webpagename'] . "\">" . $lang['err_no_webpage'] . "</interlink>";
			}
			else {
				$lang['err_no_blogs_hint'] = str_replace('SYS_KEYWORD_URL', $url, $lang['err_no_blogs_hint']);

				$err_display_no_blogs = $lang['err_no_blogs'] . " " . $lang['err_no_blogs_hint'];
			}
			
		}
		else {
			global $lang;
			
			$err_display_no_blogs = $lang['err_no_blogs'];
		}


		// We push the array into a parent array - this is because we may have multiple listings
		// on a single page
		if (empty($result)) {
			$result['error_txt'] = $err_display_no_blogs;
		}

		$result = array($result);

		if (isset($body->vars['blogs'][0])) {
			$body->vars['blogs'] = $result;
		}
 		else {
			$body->set('blogs', $result);
 		}
	}
	elseif ($attributes['block'] == "blog") { // select single blog
		
		$query = "
			SELECT b.blog_id, b.blog_title, b.blog_body, 
			UNIX_TIMESTAMP(b.blog_create_datetime) as blog_create_datetime,
			UNIX_TIMESTAMP(b.blog_edit_datetime) as blog_edit_datetime, 
			c.connection_nickname, c.connection_openid, c.connection_id 
			FROM " . $db->prefix . "_plugin_blog b, " . $db->prefix . "_connection c
			WHERE
			b.connection_id=c.connection_id AND
			b.webspace_id=" . $output_webspace['webspace_id'] . " AND 
			b.webpage_id=" . $output_webspace['webpage_id'] . " AND "
		;

		if (isset($_REQUEST['blog_id'])) {
			$query .= "b.blog_id=" . $_REQUEST['blog_id'];
		}
		else { // if we do not get a blog_id we select the latest
			$query .= "1=1 ORDER BY b.blog_create_datetime desc";
		}

		$result = $db->Execute($query);

		if (isset($result[0])) {
			$blog = $result[0];

			$_REQUEST['blog_id'] = $blog['blog_id'];

			$body->set('blog', $blog);
		}
	}
}

?>