<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

// HEADER ------------------------------------------------------------------
include ("config/core.config.php");
include ("inc/functions.inc.php");


// SETUP DATABASE ------------------------------------------------------
require_once('class/Db.class.php');
$db = new Database($core_config['db']);


// START SESSION -----------------------------------------------------------
session_name($core_config['node']['php_session_name']);
session_start();

if(isset($_SESSION['connection_permission']) && checkPermission('core', 'edit_stylesheet', $_SESSION['connection_permission'])) {

	// temp
	$_SESSION['language_code'] = $core_config['language']['pack'][$core_config['language']['default_pack_id']];
	
	
	
	
	if (isset($_POST['update_webspace_css'])) {
		$query = "
			UPDATE " . $db->prefix . "_webspace
			SET
			webspace_css=" . $db->qstr($_POST['webspace_css']) . "
			WHERE webspace_id=" . $_POST['ws']
		;
		
		$result = $db->Execute($query);
		
		if (isset($result)) {
	
			// get the base window to refresh
			?>
			<script type="text/javascript">
				window.opener.location.reload(true);
			</script>
			<?php
		}
	}
	
	$query = "
		SELECT webspace_css, webspace_id
		FROM " . $db->prefix . "_webspace
		WHERE webspace_id=" . $_REQUEST['ws']
	;
	
	$result = $db->Execute($query);
	
	if (isset($result) && isset($result[0]['webspace_id'])) {
		$output_webspace = $result[0];
	}
	
	// SETUP TEMPLATE -------------------------------------------------------------------
	$template_path = "template/";
	
	require_once('class/Template.class.php');
	$tpl = & new Template();
	
	
	// get language include files and create language array
	$lang = array();
	$language_path = "language/" . $_SESSION['language_code'] . "/";
	require_once($language_path . 'popup_stylesheet.lang.php');
	
	
	// APPLY VARS TO TEMPLATES -----------------------------------------------
	$tpl->set('lang', $lang);
	$tpl->set('template_path', $template_path);
	$tpl->set('webspace', $output_webspace);
	
	
	echo $tpl->fetch($template_path . 'popup_stylesheet.tpl.php');
}
?>