<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


// PLUGIN: Barnraiser Guestbook

function plugin_guestbook ($attributes=null) {

	global $db, $ws, $output_webspace, $body;

	if (!isset($attributes['block'])) {
		$attributes['block'] = "list";
	}

	if ($attributes['block'] == "list") { // select multiple guestbooks

		$query = "
			SELECT UNIX_TIMESTAMP(gb.guestbook_create_datetime) as guestbook_create_datetime,
			gb.guestbook_body, c.connection_nickname, c.connection_openid
			FROM " . $db->prefix . "_plugin_guestbook gb, " . $db->prefix . "_connection c
			WHERE
			gb.connection_id=c.connection_id AND
			gb.webspace_id=" . $output_webspace['webspace_id'] . "
			ORDER BY gb.guestbook_create_datetime"
		;
		
		if (!isset($attributes['order'])) {
			$query .= " desc";
		}
		
		if (isset($attributes['limit'])) {
			$result = $db->Execute($query, (int) $attributes['limit']);
		}
		else {
			$result = $db->Execute($query);
		}
		
		if (isset($result)) {
			$body->set('guestbook_list', $result);
		}
	}
}
?>