<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


// MAIN INCLUDES ---------------------------------------------------------
include ("../components/core/config/core.config.php");


// SETUP DATABASE ------------------------------------------------------
require_once('../components/core/class/Db.class.php');
$db = new Database($core_config['db']);


// SETUP WEBSPACE ------------------------------------------------------
require_once('../components/core/class/Webspace.class.php');
$ws = new Webspace($db); // outer template
$ws->webspace_id = $_REQUEST['ws'];
$output_webspace = $ws->selWebSpace();


if (empty($output_webspace['webspace_locked'])) {
	// GATHER ITEMS --------------------------------------------------------
	if ($handle = opendir('../components')) {
	while (false !== ($file = readdir($handle))) {
		if ($file != "." && $file != ".." && $file != "core") {
			$output_plugins[] = $file;
		}
	}
	closedir($handle);
	}
	
	// //create URL
	// $url = "http://" . $_SERVER['HTTP_HOST'];
	// $url .= dirname ($_SERVER['PHP_SELF']);
	// //sometimes the server adds / as the last character - we need to check.
	// if (substr($url, -1, 1) != "/") {
	// 	$url .= "/";
	// }
	
	$url = "smudge.barnraiser.net";
	
	
	$items = array();
	
	if (!empty($output_plugins)) {
		foreach($output_plugins as $key => $p):
			if (is_file("../components/" . $p . "/inc/plugin_rss.inc.php")) {
				include_once ("../components/" . $p . "/inc/plugin_rss.inc.php");
			
				$function_name = "am_plugin_" . $p . "_getItemsArray";
				
				if (function_exists($function_name)) {
					$rss_results = $function_name();
	
					if (!empty($rss_results)) {
						foreach ($rss_results as $item_key => $i):
							array_push($items, $i);
						endforeach;
					}
				}
			}
		endforeach;
	}
	
	
	header("Content-Type: application/xml; charset=ISO-8859-1");
	
	echo "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>";
	echo "<?xml-stylesheet title=\"XSL_formatting\" type=\"text/xsl\" href=\"nolsol.xsl\"?>";
	echo "<rss version=\"2.0\">";
	echo "<channel>";
	echo "<title>" . $output_webspace['webspace_title'] . "</title>";
	echo "<link>Webspace url</link>";
	echo "<description>" . $output_webspace['webspace_description'] . "</description>";
	echo "<language>en-gb</language>";
	echo "<lastBuildDate>Fri, 30 Mar 2007 08:53:59 GMT</lastBuildDate>";
	
	if (!empty($items)) {
		foreach ($items as $key => $i):
			echo "<item>";
			echo "<title>" . $i['title'] . "</title>";
			echo "<description>" . $i['description'] . "</description>";
			echo "<link>" . $i['link'] . "</link>";
			echo "<pubDate>" . $i['datetime'] . "</pubDate>";
			echo "</item>";
		endforeach;
	}
	
	echo "</channel>";
	echo "</rss>";
}
?>