<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


class Database_Resources
{

  private static $instance;
  private $db;
  private function __construct () {
    $this->db = Database_SQLite::connect ("resources");
  }
  public static function getInstance ()
  {
    if (empty (self::$instance)) {
      self::$instance = new Database_Resources ();
    }
    return self::$instance;
  }


  public function create ()
  {
$sql = <<<'EOD'
CREATE TABLE IF NOT EXISTS resources (
  name text,
  command text,
  code text
);
EOD;
    Database_SQLite::exec ($this->db, $sql);
  }


  // This function loads the default external resources into the database.
  public function defaults ()
  {
    $folder = "../resource";

    $files = array ();
    foreach (new DirectoryIterator ($folder) as $fileInfo) {
      if ($fileInfo->isDot ()) continue;
      if ($fileInfo->isDir ()) continue;
      $files [] = $fileInfo->getFilename();
    }

    foreach ($files as $file) {
      if (strpos ($file, "default") === false) continue;
      $suffix = pathinfo ($file, PATHINFO_EXTENSION);
      $name = substr ($file, 7, -1 - strlen ($suffix));
      $name = str_replace ("_", " ", $name);
      $code = file_get_contents ("$folder/$file");
      $code = Database_SQLiteInjection::no ($code);

      Database_SQLite::exec ($this->db, "DELETE FROM resources WHERE name = '$name';");
      Database_SQLite::exec ($this->db, "INSERT INTO resources (name, command, code) VALUES ('$name', 'php script', '$code');");
    }
  }


  public function optimize ()
  {
    Database_SQLite::exec ($this->db, "REINDEX resources;");
    Database_SQLite::exec ($this->db, "VACUUM resources;");
  }


  public function save ($name, $command, $code)
  {
    $name = Database_SQLiteInjection::no ($name);
    $command = Database_SQLiteInjection::no ($command);
    $code = Database_SQLiteInjection::no ($code);
    $this->delete ($name);
    $query = "INSERT INTO resources (name, command, code) VALUES ('$name', '$command', '$code');";
    Database_SQLite::exec ($this->db, $query);
  }


  public function getNames ()
  {
    $names = array ();
    $query = "SELECT name FROM resources ORDER by name;";
    $result = Database_SQLite::query ($this->db, $query);
    foreach ($result as $row) {
      $names [] = $row [0];
    }
    return $names;
  }


  public function delete ($name)
  {
    $name = Database_SQLiteInjection::no ($name);
    $query = "DELETE FROM resources WHERE name = '$name';";
    Database_SQLite::exec ($this->db, $query);
  }


  public function getDetails ($name)
  {
    $name = Database_SQLiteInjection::no ($name);
    $query = "SELECT command, code FROM resources WHERE name = '$name';";
    $result = Database_SQLite::query ($this->db, $query);
    foreach ($result as $row) {
      return $row;
    }
    return array ();
  }


}



?>
