<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


require_once ("../bootstrap/bootstrap.php");


$database_logs = Database_Logs::getInstance ();


// Security: The script runs from the cli SAPI only.
if (php_sapi_name () != "cli") {
  $database_logs->log ("reindex: Fatal: This only runs through the cli Server API", Filter_Roles::ADMIN_LEVEL);
  die;
}


$database_bibles = Database_Bibles::getInstance ();
$database_search = Database_Search::getInstance ();


$bibles = $database_bibles->getBibles ();
foreach ($bibles as $bible) {
  $database_logs->log ("Refreshing search index for Bible $bible" , Filter_Roles::ADMIN_LEVEL);
  $books = $database_bibles->getBooks ($bible);
  foreach ($books as $book) {
    $chapters = $database_bibles->getChapters ($bible, $book);
    foreach ($chapters as $chapter) {
      $database_search->updateSearchFields ($bible, $book, $chapter);
    }
  }
}


$database_logs->log ("Refreshing search indexes ready", Filter_Roles::ADMIN_LEVEL);


?>
